/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Constant;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Operator;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.Checker;
import com.sixtyfour.util.Jitted;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Term
implements Atom {
    private static int termId;
    private Atom left;
    private Atom right;
    private Operator operator;
    private String expression;
    private String initial;
    private String key;
    private Type type;
    private int id = termId++;
    private int callCount = 0;
    private Method jittedMethod = null;
    private Jitted jittedInstance = null;
    private boolean jitRun = false;
    private boolean constant = false;

    public Term(String expression, Map<String, Term> termMap) {
        this.setExpression(expression);
        this.setInitial(expression, termMap);
    }

    public Term(Atom left) {
        this.left = left;
        this.operator = Operator.NOP;
        this.right = new Constant<Integer>(0);
    }

    public boolean isComplete() {
        return this.left != null && this.right != null && this.operator != null;
    }

    public boolean isEmpty() {
        return this.left == null || this.left.isTerm() && ((Term)this.left).isEmpty();
    }

    public Atom getLeft() {
        return this.left;
    }

    public void setLeft(Atom left) {
        this.left = left;
    }

    public Atom getRight() {
        return this.right;
    }

    public void setRight(Atom right) {
        this.right = right;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String toString() {
        return "([" + this.key + "]" + (this.constant ? "!" : "") + "\\l:" + this.left + "/" + this.operator + "\\r:" + this.right + ")";
    }

    @Override
    public Type getType() {
        return this.getType(false);
    }

    @Override
    public Type getType(boolean ignoreMT) {
        Type t1;
        if (this.type != null) {
            return this.type;
        }
        if (this.left == null) {
            throw new RuntimeException("Syntax error: " + this.toString());
        }
        Type t2 = t1 = this.left.getType();
        if (this.operator != Operator.NOP) {
            t2 = this.right.getType();
        }
        if (this.operator.isDelimiter()) {
            return t1;
        }
        if (t1.equals((Object)Type.INTEGER) && t2.equals((Object)Type.REAL)) {
            return t2;
        }
        if (t1.equals((Object)Type.REAL) && t2.equals((Object)Type.INTEGER)) {
            return t1;
        }
        if (!t1.equals((Object)t2)) {
            if (ignoreMT) {
                return Type.INTEGER;
            }
            if (Checker.isTypeMismatch(this)) {
                throw new RuntimeException("Type mismatch error: " + this.toString() + " | " + this.left + " | " + this.right + " | " + (Object)((Object)t1) + "/" + (Object)((Object)t2) + "/" + this.operator.getType());
            }
        }
        this.type = t1;
        return t1;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        if (this.operator.isNop()) {
            if (this.left == null) {
                throw new RuntimeException("Syntax error!");
            }
            return this.left.evalToCode(config, machine);
        }
        Type type = this.getType(true);
        if (type == Type.STRING) {
            if (this.operator.isPlus()) {
                List<String> s1 = this.left.evalToCode(config, machine).get(0).getExpression();
                List<String> s2 = this.right.evalToCode(config, machine).get(0).getExpression();
                ret.add(0, "_");
                s2.add(0, ":.");
                ret.addAll(0, s1);
                ret.addAll(0, s2);
                cc.add(new CodeContainer(ret));
                return cc;
            }
        } else {
            List<String> n1 = this.left.evalToCode(config, machine).get(0).getExpression();
            List<String> n2 = this.right.evalToCode(config, machine).get(0).getExpression();
            if (n1 == null || n2 == null) {
                throw new RuntimeException("Unknown function name: " + this.getExpression());
            }
            switch (this.operator.getType()) {
                case 0: {
                    ret.add(0, "_");
                    n2.add(0, ":^");
                    ret.addAll(0, n1);
                    ret.addAll(0, n2);
                    break;
                }
                case 1: {
                    ret.add(0, "_");
                    n2.add(0, ":*");
                    ret.addAll(0, n1);
                    ret.addAll(0, n2);
                    break;
                }
                case 2: {
                    ret.add(0, "_");
                    n2.add(0, ":/");
                    ret.addAll(0, n1);
                    ret.addAll(0, n2);
                    break;
                }
                case 3: {
                    ret.add(0, "_");
                    n2.add(0, ":+");
                    ret.addAll(0, n1);
                    ret.addAll(0, n2);
                    break;
                }
                case 4: {
                    ret.add(0, "_");
                    n2.add(0, ":-");
                    ret.addAll(0, n1);
                    ret.addAll(0, n2);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    ret.add(0, "_");
                    n2.add(0, ":|");
                    ret.addAll(0, n1);
                    ret.addAll(0, n2);
                    break;
                }
                case 8: {
                    ret.add(0, "_");
                    n2.add(0, ":&");
                    ret.addAll(0, n1);
                    ret.addAll(0, n2);
                    break;
                }
                case 9: {
                    ret.add("_");
                    n2.add(":!");
                    ret.addAll(0, n2);
                }
            }
            cc.add(new CodeContainer(ret));
            return cc;
        }
        throw new RuntimeException("Unable to evaluate term to expression: " + this.toString());
    }

    @Override
    public Object eval(Machine machine) {
        try {
            ++this.callCount;
            machine.setCurrentOperator(this.operator);
            if (this.jittedMethod != null) {
                Object object = machine.getJit().call(this);
                return object;
            }
            if (this.operator.isNop()) {
                if (this.left == null) {
                    throw new RuntimeException("Syntax error!");
                }
                Object object = this.left.eval(machine);
                return object;
            }
            Type type = this.getType();
            if (type == Type.STRING) {
                if (this.operator.isPlus()) {
                    String string = String.valueOf(this.left.eval(machine).toString()) + this.right.eval(machine).toString();
                    return string;
                }
            } else {
                Number n1;
                Number n2 = n1 = (Number)this.left.eval(machine);
                if (this.left != this.right) {
                    n2 = (Number)this.right.eval(machine);
                }
                double v1 = 0.0;
                switch (this.operator.getType()) {
                    case 0: {
                        v1 = Math.pow(n1.doubleValue(), n2.doubleValue());
                        break;
                    }
                    case 1: {
                        v1 = n1.doubleValue() * n2.doubleValue();
                        break;
                    }
                    case 2: {
                        if (n2.doubleValue() == 0.0) {
                            throw new RuntimeException("Division by zero error: " + n1 + "/" + n2);
                        }
                        v1 = n1.doubleValue() / n2.doubleValue();
                        break;
                    }
                    case 3: {
                        v1 = n1.doubleValue() + n2.doubleValue();
                        break;
                    }
                    case 4: {
                        v1 = n1.doubleValue() - n2.doubleValue();
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        v1 = n1.intValue() | n2.intValue();
                        break;
                    }
                    case 8: {
                        v1 = n1.intValue() & n2.intValue();
                        break;
                    }
                    case 9: {
                        v1 = ~n2.intValue();
                    }
                }
                Double d = v1;
                return d;
            }
            throw new RuntimeException("Unable to evaluate term: " + this.toString());
        }
        finally {
            machine.setCurrentOperator(null);
            if (!this.jitRun && this.callCount > 20 && machine.getJit() != null) {
                this.jitRun = machine.getJit().addMethod(this, machine);
            }
        }
    }

    @Override
    public String toCode(Machine machine) {
        if (this.operator.isNop()) {
            if (this.left == null) {
                throw new RuntimeException("Syntax error!");
            }
            String ls = this.left.toCode(machine);
            if (ls != null) {
                return this.filterCode("(" + ls + ")");
            }
            return null;
        }
        Type type = this.getType();
        if (type == Type.STRING) {
            if (this.operator.isPlus()) {
                String ls = this.left.toCode(machine);
                String rs = this.right.toCode(machine);
                if (ls == null || rs == null) {
                    return null;
                }
                return this.filterCode("(" + ls + "+" + rs + ")");
            }
        } else {
            String n1;
            String n2 = n1 = this.left.toCode(machine);
            if (this.left != this.right) {
                n2 = this.right.toCode(machine);
            }
            if (n1 == null || n2 == null) {
                return null;
            }
            String v1 = "";
            if (this.operator.isPlus()) {
                v1 = String.valueOf(n1) + "+" + n2;
            } else if (this.operator.isMinus()) {
                v1 = String.valueOf(n1) + "-" + n2;
            } else if (this.operator.isPower()) {
                v1 = "(float) Math.pow(" + n1 + "," + n2 + ")";
            } else if (this.operator.isMultiplication()) {
                v1 = String.valueOf(n1) + "*" + n2;
            } else if (this.operator.isDivision()) {
                v1 = String.valueOf(n1) + "/" + n2;
            } else if (this.operator.isOr()) {
                v1 = "(int) (" + n1 + ")|" + n2;
            } else if (this.operator.isAnd()) {
                v1 = "(int) (" + n1 + ")&" + n2;
            } else if (this.operator.isNot()) {
                v1 = "~(int) (" + n2 + ")";
            }
            return this.filterCode("(" + v1 + ")");
        }
        return null;
    }

    @Override
    public boolean isTerm() {
        return true;
    }

    public int getId() {
        return this.id;
    }

    public int getCallCount() {
        return this.callCount;
    }

    public Method getJittedMethod() {
        return this.jittedMethod;
    }

    public Jitted getJittedInstance() {
        return this.jittedInstance;
    }

    public void setJittedInstance(Jitted jittedInstance) {
        this.jittedInstance = jittedInstance;
    }

    public String getInitial() {
        return this.initial;
    }

    public String getTruncatedInitial() {
        String ini = this.initial;
        boolean inString = false;
        int brackets = 0;
        int ii = 0;
        while (ii < ini.length()) {
            char c = ini.charAt(ii);
            if (c == '\"') {
                inString = !inString;
            } else if (!inString) {
                if (c == '(') {
                    ++brackets;
                } else if (c == ')') {
                    --brackets;
                } else if (c == ',' && brackets == 0) {
                    ini = ini.substring(0, ii);
                    break;
                }
            }
            ++ii;
        }
        return ini;
    }

    public void setInitial(String initial) {
        this.initial = initial;
    }

    public void setInitial(String term, Map<String, Term> termMap) {
        boolean inString = false;
        boolean replaced = false;
        block0: do {
            replaced = false;
            int i = 0;
            while (i < term.length()) {
                String key;
                Term st;
                int end;
                char c = term.charAt(i);
                if (c == '\"') {
                    boolean bl = inString = !inString;
                }
                if (!inString && c == '{' && (end = term.indexOf("}", i)) != -1 && (st = termMap.get(key = term.substring(i, end + 1))) != null) {
                    term = String.valueOf(term.substring(0, i)) + "(" + st.getExpression() + ")" + term.substring(end + 1);
                    replaced = true;
                    continue block0;
                }
                ++i;
            }
        } while (replaced);
        this.initial = term;
    }

    public void setJittedMethod(Method jitted) {
        this.jittedMethod = jitted;
    }

    @Override
    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    private String filterCode(String code) {
        return code;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Term) {
            if (o == this && (!(this.left instanceof Function) || ((Function)this.left).isDeterministic())) {
                return true;
            }
            boolean eq = true;
            if (this.left != null) {
                eq = this.left.equals(((Term)o).left);
            }
            if (this.right != null && eq) {
                eq = this.right.equals(((Term)o).right);
            }
            if (this.operator != null && eq) {
                eq = this.operator.equals(((Term)o).operator);
            }
            return eq;
        }
        return false;
    }

    public int hashCode() {
        return (this.left != null ? this.left.hashCode() : 0) + (this.right != null ? this.right.hashCode() : 0);
    }
}

