/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.parser.Operator;
import com.sixtyfour.util.VarUtils;
import java.math.BigDecimal;

public class TermEnhancer {
    public static String addBrackets(String term) {
        TermEnhancer.checkBrackets(term);
        if (!term.startsWith("(") || !term.endsWith(")")) {
            term = "(" + term + ")";
        }
        term = term.replace('\u2191', '^');
        return TermEnhancer.addBrackets(TermEnhancer.addBrackets(TermEnhancer.addBrackets(TermEnhancer.addBrackets(TermEnhancer.handleSigns(TermEnhancer.replaceLogicOperators(term)), 3), 2), 0), 1);
    }

    public static String handleNonDecimalNumbers(CompilerConfig conf, String term) {
        boolean NONE = false;
        boolean BIN = true;
        int HEX = 2;
        if (!conf.isNonDecimalNumbersAware()) {
            return term;
        }
        int inNumber = 0;
        boolean inString = false;
        StringBuilder sb = new StringBuilder();
        String num = "";
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                char c2;
                boolean xs = false;
                if (c == '\\' && inNumber == 0 && i < term.length() - 3 && (c2 = Character.toLowerCase(term.charAt(i + 1))) == 'x') {
                    String hex = term.substring(i + 2, i + 4);
                    float val = Integer.parseInt(hex, 16);
                    if (val == 255.0f) {
                        sb.append(Math.PI);
                    } else {
                        sb.append(val);
                    }
                    i += 3;
                    xs = true;
                }
                if (!xs) {
                    if (inNumber > 0) {
                        char cl = Character.toLowerCase(c);
                        if (inNumber == 1 && (cl == '0' || cl == '1')) {
                            num = String.valueOf(num) + c;
                        } else if (cl >= '0' && cl <= '9' || cl >= 'a' && cl <= 'f') {
                            num = String.valueOf(num) + c;
                        } else {
                            sb.append(Integer.parseInt(num, inNumber == 1 ? 2 : 16));
                            if (c != '\\') {
                                sb.append(c);
                            } else {
                                --i;
                            }
                            inNumber = 0;
                            num = "";
                        }
                    } else {
                        if (i < term.length() - 1) {
                            char cf = Character.toLowerCase(term.charAt(i + 1));
                            if (c == '%' && (cf == '0' || cf == '1')) {
                                inNumber = 1;
                                num = "";
                            } else if (c == '$' && (cf >= '0' && cf <= '9' || cf >= 'a' && cf <= 'f')) {
                                inNumber = 2;
                                num = "";
                            }
                        }
                        if (inNumber == 0) {
                            sb.append(c);
                        }
                    }
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (!num.isEmpty()) {
            sb.append(Integer.parseInt(num, inNumber == 1 ? 2 : 16));
        }
        return sb.toString();
    }

    public static void checkBrackets(String term) {
        int open = 0;
        boolean inString = false;
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '(') {
                    ++open;
                } else if (c == ')') {
                    --open;
                }
            }
            ++i;
        }
        if (open != 0) {
            throw new RuntimeException("Invalid term: " + term + "/" + open);
        }
    }

    public static int findEndBracket(String term, int pos) {
        int open = 0;
        boolean inString = false;
        if (term.charAt(pos) != '(') {
            return -1;
        }
        int i = pos;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '(') {
                    ++open;
                } else if (c == ')') {
                    --open;
                }
            }
            if (open == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String removeWhiteSpace(String txt) {
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        int i = 0;
        while (i < txt.length()) {
            char c = txt.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (inString || c != ' ') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String replaceLogicOperators(String term) {
        String[] replacers = new String[]{"OR", Operator.getOrOperator(), "AND", Operator.getAndOperator(), "NOT", "(0" + Operator.getNotOperator() + "("};
        term = TermEnhancer.removeWhiteSpace(term);
        String uTerm = VarUtils.toUpper(term);
        int i = 0;
        while (i < replacers.length) {
            int pos = -1;
            do {
                String torep;
                if ((pos = uTerm.indexOf(torep = replacers[i], pos)) == -1) continue;
                boolean inString = false;
                int j = 0;
                while (j < pos) {
                    char c = uTerm.charAt(j);
                    if (c == '\"') {
                        inString = !inString;
                    }
                    ++j;
                }
                if (!inString) {
                    term = String.valueOf(term.substring(0, pos)) + replacers[i + 1] + term.substring(pos + torep.length());
                    uTerm = String.valueOf(uTerm.substring(0, pos)) + replacers[i + 1] + uTerm.substring(pos + torep.length());
                    if (!torep.equals("NOT")) continue;
                    int end = TermEnhancer.findLogicEnd(uTerm, pos + 3, true);
                    term = String.valueOf(term.substring(0, end)) + "))" + term.substring(end);
                    uTerm = String.valueOf(uTerm.substring(0, end)) + "))" + uTerm.substring(end);
                    continue;
                }
                ++pos;
            } while (pos != -1);
            i += 2;
        }
        return term;
    }

    public static String stripAssignment(String term, boolean stripAssignment) {
        int pos;
        if (stripAssignment && (pos = term.indexOf(61)) != -1) {
            term = term.substring(pos + 1);
        }
        return term;
    }

    public static String replaceScientificNotation(String line) {
        if (line.contains("\"") || line.contains("$")) {
            return line;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < line.length()) {
            char c = Character.toLowerCase(line.charAt(i));
            if (c == 'e' && i > 0) {
                char cp = line.charAt(i - 1);
                if (!Character.isDigit(cp)) {
                    sb.append(c);
                } else {
                    boolean signFound = false;
                    boolean numFound = false;
                    StringBuilder num = new StringBuilder();
                    int np = i;
                    int p = i + 1;
                    while (p < line.length()) {
                        cp = line.charAt(p);
                        if (!(signFound || cp != '-' && cp != '+')) {
                            signFound = true;
                            num.append(cp);
                            np = p;
                        } else {
                            if (!Character.isDigit(cp)) break;
                            num.append(cp);
                            numFound = true;
                            signFound = true;
                            np = p;
                        }
                        ++p;
                    }
                    if (!numFound) {
                        num.append("0");
                    }
                    if (num.length() > 0) {
                        int l = sb.length();
                        int p2 = TermEnhancer.findStart(sb.toString(), l - 1);
                        boolean rep = false;
                        try {
                            String vv = String.valueOf(sb.substring(p2, l)) + "e" + num.toString();
                            sb.setLength(p2);
                            sb.append(new BigDecimal(vv).toPlainString());
                            rep = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!rep) {
                            sb.append("*(10^" + num.toString() + "))");
                            sb.insert(p2, "(");
                        }
                        i = np;
                    } else {
                        sb.append(c);
                    }
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String addLogicBrackets(String term) {
        term = TermEnhancer.removeWhiteSpace(term);
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString && c == '&') {
                int start = TermEnhancer.findLogicStart(term, i);
                int end = TermEnhancer.findLogicEnd(term, i);
                i = TermEnhancer.addBracketsInternal(term, sb, i, start, end);
                term = sb.toString();
                sb.setLength(0);
            }
            ++i;
        }
        return term;
    }

    public static String addBrackets(String term, int level) {
        term = TermEnhancer.removeWhiteSpace(term);
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == ',') {
                    int end = TermEnhancer.findNextDelimiter(term, i);
                    String curPar = term.substring(i + 1, end);
                    boolean matching = true;
                    if (curPar.startsWith("(")) {
                        int endBra = TermEnhancer.findEndBracket(term, i + 1);
                        boolean bl = matching = endBra == end - 1;
                    }
                    if (!(curPar.startsWith("(") && curPar.endsWith(")") && matching)) {
                        sb.append(term.substring(0, i + 1)).append('(').append(curPar).append(')');
                        if (end != term.length()) {
                            sb.append(term.substring(end));
                        }
                        ++i;
                        term = sb.toString();
                        sb.setLength(0);
                    }
                }
                if (level == 2 && (c == '=' || c == '<' || c == '>') || level == 1 && (c == '*' || c == '/') || level == 0 && c == '^' || level == 3 && (c == '&' || c == '\u00b0')) {
                    int start = level != 3 ? TermEnhancer.findStart(term, i, level >= 2) : i + 1;
                    int end = TermEnhancer.findEnd(term, i, level >= 2);
                    i = TermEnhancer.addBracketsInternal(term, sb, i, start, end);
                    term = sb.toString();
                    sb.setLength(0);
                }
            }
            ++i;
        }
        if (level == 3) {
            term = TermEnhancer.addLogicBrackets(term);
        }
        return term;
    }

    private static int addBracketsInternal(String term, StringBuilder sb, int i, int start, int end) {
        if (start > 0 && term.charAt(start - 1) == '(' && end < term.length() && term.charAt(end) == ')') {
            sb.append(term.substring(0, start)).append(term.substring(start, end));
        } else {
            sb.append(term.substring(0, start)).append('(').append(term.substring(start, end)).append(')');
            ++i;
        }
        if (end != term.length()) {
            sb.append(term.substring(end));
        }
        return i;
    }

    private static int findNextDelimiter(String term, int pos) {
        int brackets = 1;
        term = String.valueOf(term) + ",";
        boolean inString = false;
        int i = pos + 1;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '(') {
                    ++brackets;
                }
                if (c == ')') {
                    --brackets;
                }
                if (c == ',' && brackets == 1 || c == ')' && brackets == 0) {
                    return i;
                }
            }
            ++i;
        }
        throw new RuntimeException("Syntax error: " + term);
    }

    private static String handleSigns(String term) {
        term = TermEnhancer.removeWhiteSpace(term);
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        boolean wasOp = true;
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString && c == '-' && wasOp) {
                TermEnhancer.wrapSign(term, sb, i, "-1");
                ++i;
                term = sb.toString();
                sb.setLength(0);
            } else if (!inString && c == '+' && wasOp) {
                sb.append(term.substring(0, i)).append(term.substring(i + 1, term.length()));
                --i;
                term = sb.toString();
                sb.setLength(0);
            }
            wasOp = Operator.isOperator(c) || c == '(';
            ++i;
        }
        return term;
    }

    private static void wrapSign(String term, StringBuilder sb, int i, String sign) {
        int end = TermEnhancer.findEndOfNegation(term, i, true);
        if (end == i + 1) {
            throw new RuntimeException("Syntax error: " + term);
        }
        if (end == -1) {
            sb.append(term.substring(0, i)).append(String.valueOf(sign) + "*").append(term.substring(i + 1));
        } else {
            sb.append(term.substring(0, i)).append("(" + sign + "*").append(term.substring(i + 1, end)).append(")").append(term.substring(end));
        }
    }

    private static int findEndOfNegation(String term, int pos, boolean negative) {
        int brackets = 0;
        boolean rowOfOps = true;
        boolean inString = false;
        int i = pos + 1;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == ',' && brackets == 0) {
                    return i;
                }
                boolean opi = Operator.isOperator(c);
                if (!opi && negative) {
                    rowOfOps = false;
                }
                if (brackets == 0 && (opi && !rowOfOps || c == ')')) {
                    if (c == '^') {
                        return -1;
                    }
                    return i;
                }
                if (c == '(') {
                    ++brackets;
                } else if (c == ')' && brackets > 0) {
                    --brackets;
                }
            }
            ++i;
        }
        return term.length();
    }

    private static int findEnd(String term, int pos, boolean logicCheck) {
        int st;
        int brackets = 0;
        boolean inString = false;
        int i = st = TermEnhancer.calcPositionAfter(term, pos);
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == ',' && brackets == 0) {
                    return i;
                }
                if (brackets == 0 && (!(logicCheck ? !Operator.isLogicOperator(c) : !Operator.isOperator(c)) || c == ')') && (logicCheck || c != '-' && c != '+' || i - 1 != pos)) {
                    return i;
                }
                if (c == '(') {
                    ++brackets;
                } else if (c == ')' && brackets > 0) {
                    --brackets;
                }
            }
            ++i;
        }
        return term.length();
    }

    private static int findStart(String term, int pos) {
        return TermEnhancer.findStart(term, pos, false);
    }

    private static int findStart(String term, int pos, boolean logicCheck) {
        int st;
        int brackets = 0;
        boolean inString = false;
        int i = st = TermEnhancer.calcPositionBefore(term, pos);
        while (i >= 0) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == ',' && brackets == 0) {
                    return i + 1;
                }
                char pc = c;
                if (i > 0) {
                    pc = term.charAt(i - 1);
                }
                if (brackets == 0 && ((logicCheck ? Operator.isLogicOperator(c) : Operator.isOperator(c)) && (c != '-' || i > 0 && !Operator.isOperator(pc) && pc != '(') || c == '(')) {
                    return i + 1;
                }
                if (c == ')') {
                    ++brackets;
                } else if (c == '(' && brackets > 0) {
                    --brackets;
                }
            }
            --i;
        }
        return 0;
    }

    private static int findLogicEnd(String term, int pos) {
        return TermEnhancer.findLogicEnd(term, pos, false);
    }

    private static int findLogicEnd(String term, int pos, boolean strict) {
        int st;
        int brackets = 0;
        boolean inString = false;
        int i = st = TermEnhancer.calcPositionAfter(term, pos);
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == ',' && brackets == 0) {
                    return i;
                }
                if (brackets == 0 && (c == '\u00b0' || c == '&' && strict)) {
                    return i;
                }
                if (c == '(') {
                    ++brackets;
                } else if (c == ')' && brackets > 0) {
                    --brackets;
                }
            }
            ++i;
        }
        return term.length();
    }

    private static int findLogicStart(String term, int pos) {
        int st;
        int brackets = 0;
        boolean inString = false;
        int i = st = TermEnhancer.calcPositionBefore(term, pos);
        while (i >= 0) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == ',' && brackets == 0) {
                    return i + 1;
                }
                if (brackets == 0 && c == '\u00b0') {
                    return i + 1;
                }
                if (c == ')') {
                    ++brackets;
                } else if (c == '(' && brackets > 0) {
                    --brackets;
                }
            }
            --i;
        }
        return 0;
    }

    private static int calcPositionBefore(String term, int pos) {
        int st = pos - 1;
        if (Operator.isComparisonOperator(term.charAt(pos)) && pos > 1 && Operator.isComparisonOperator(term.charAt(pos - 1))) {
            --st;
        }
        return st;
    }

    private static int calcPositionAfter(String term, int pos) {
        int st = pos + 1;
        if (Operator.isComparisonOperator(term.charAt(pos)) && pos < term.length() - 1 && Operator.isComparisonOperator(term.charAt(pos + 1))) {
            ++st;
        }
        return st;
    }
}

