/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.assembly;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.mnemonics.Mnemonic;
import com.sixtyfour.elements.mnemonics.MnemonicList;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.assembly.ConstantByte;
import com.sixtyfour.parser.assembly.ConstantDynamic;
import com.sixtyfour.parser.assembly.ConstantInt;
import com.sixtyfour.parser.assembly.ConstantValue;
import com.sixtyfour.parser.assembly.ConstantsContainer;
import com.sixtyfour.parser.assembly.ControlCodes;
import com.sixtyfour.parser.assembly.DelayedData;
import com.sixtyfour.parser.assembly.LabelAndCode;
import com.sixtyfour.parser.assembly.LabelsContainer;
import com.sixtyfour.system.Conversions;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class AssemblyParser {
    public static Mnemonic getMnemonic(CompilerConfig config, String linePart) {
        if (linePart.startsWith(".")) {
            return null;
        }
        List<Mnemonic> mnemonics = MnemonicList.getMnemonics(config);
        Mnemonic mne = null;
        for (Mnemonic mnee : mnemonics) {
            if (!mnee.isMnemonic(linePart)) continue;
            mne = mnee;
            break;
        }
        return mne;
    }

    public static String truncateComments(String linePart) {
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        int pos = linePart.indexOf("}");
        if (pos == -1) {
            pos = 0;
        }
        int i = 0;
        while (i < linePart.length()) {
            char c = linePart.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString && c == ';' && i > pos) {
                return sb.toString();
            }
            sb.append(c);
            ++i;
        }
        return sb.toString().trim();
    }

    public static LabelAndCode getLabel(String linePart) {
        if (linePart.startsWith(".")) {
            return null;
        }
        String linePart2 = Parser.replaceStrings(linePart, '_').trim();
        int pos = linePart2.indexOf(" ");
        if (pos != -1) {
            return new LabelAndCode(linePart.substring(0, pos).replace(":", ""), linePart.substring(pos + 1).trim());
        }
        return new LabelAndCode(linePart.replace(":", ""), "");
    }

    public static int getValue(CompilerConfig config, String number, int addr, ConstantsContainer ccon, LabelsContainer lcon, final boolean low, boolean high, int addrAdd, boolean isDataLine) {
        ConstantValue cv;
        if ((number = number.trim()).endsWith("\\")) {
            number = number.substring(0, number.length() - 1);
        }
        if (number.startsWith("{") && number.endsWith("}")) {
            number = number.substring(1, number.length() - 1);
            if (isDataLine && (cv = AssemblyParser.getConstantParsed(config, "___", number, ccon, false)) instanceof ConstantDynamic) {
                ccon.addData(new DelayedData(addr){
                    private int addy;
                    {
                        this.addy = n + 1;
                    }

                    @Override
                    public void apply(Machine machine, ConstantsContainer ccon) {
                        if (low) {
                            int val;
                            machine.getRam()[this.addy] = val = AssemblyParser.getLowByte(cv.getValue());
                        } else {
                            int vally = cv.getValue();
                            machine.getRam()[this.addy++] = AssemblyParser.getLowByteSigned(vally);
                            machine.getRam()[this.addy] = AssemblyParser.getHighByteSigned(vally);
                        }
                    }
                });
                return 0;
            }
        }
        if (!(number.startsWith("$") || number.startsWith("%") || Character.isDigit(number.charAt(0)) || number.startsWith("-"))) {
            Integer labelAddr;
            cv = ccon.get(number);
            if (cv != null) {
                return cv.getValue();
            }
            if (!number.startsWith("*") && (cv = AssemblyParser.getConstantParsed(config, "___", number, ccon, false)) != null && cv.getValue() != 0) {
                return cv.getValue();
            }
            cv = null;
            if (number.startsWith("*")) {
                number = number.replace("*", String.valueOf(addr));
                return AssemblyParser.getConstantParsed(config, "", number, ccon, true).getValue();
            }
            if (number != null && number.contains("+")) {
                number = number.substring(0, number.indexOf("+"));
            }
            if ((labelAddr = lcon.get(number)) != null) {
                return labelAddr + addrAdd;
            }
            lcon.addDelayedLabelRef(addr, number, low, high, addrAdd, isDataLine);
            return addr;
        }
        return AssemblyParser.getValue(number);
    }

    public static int getLowByte(int val) {
        return val % 256;
    }

    public static int getHighByte(int val) {
        return val / 256;
    }

    public static int getLowByteSigned(int val) {
        if (val >= 0) {
            return val % 256;
        }
        return val & 0xFF;
    }

    public static int getHighByteSigned(int val) {
        if (val >= 0) {
            return val / 256;
        }
        return (val &= Short.MAX_VALUE) >> 8 | 0x80;
    }

    /*
     * Unable to fully structure code
     */
    public static int[] getBinaryData(CompilerConfig config, int addr, String data, ConstantsContainer ccon, LabelsContainer lcon) {
        block39: {
            block37: {
                block38: {
                    ram = new ArrayList<Integer>();
                    data = data.trim();
                    datupper = VarUtils.toUpper(data);
                    addrAdd = 0;
                    if (!data.contains("{") && (posy = data.lastIndexOf("+")) != -1 && posy >= data.lastIndexOf("\"")) {
                        try {
                            addrAdd = Integer.parseInt(data.substring(posy + 1));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Parse error in " + data + "/" + addr);
                        }
                    }
                    if (!datupper.startsWith(".TEXT") && !datupper.startsWith(".STRG")) break block37;
                    if (!(data = data.substring(5).trim()).startsWith("\"") || !data.endsWith("\"")) break block38;
                    data = data.substring(1, data.length() - 1);
                    pos = 0;
                    if (data.length() <= 0) break block39;
                    do {
                        if ((c = data.charAt(pos)) != '{') ** GOTO lbl61
                        pos2 = data.indexOf("}", pos);
                        if (pos2 != -1) {
                            part = data.substring(pos, pos2 + 1);
                            pos = pos2;
                            mul = 1;
                            if (part.contains("*")) {
                                opart = part;
                                smul = part.substring(opart.indexOf("*") + 1).replace("}", "");
                                part = String.valueOf(opart.substring(0, opart.indexOf("*"))) + "}";
                                if (smul.length() > 0) {
                                    if (!Character.isDigit(smul.charAt(0))) {
                                        smul = opart.substring(1, opart.indexOf("*"));
                                        part = opart.substring(opart.indexOf("*") + 1).replace("}", "");
                                    }
                                    mul = Integer.parseInt(smul);
                                } else {
                                    part = opart;
                                }
                            } else if (Character.isDigit(part.charAt(1)) && !Character.isDigit(part.length() - 2)) {
                                nums = new StringBuilder();
                                i = 1;
                                while (i < part.length() - 1) {
                                    cc = part.charAt(i);
                                    if (!Character.isDigit(cc)) {
                                        part = "{" + part.substring(i);
                                        mul = Integer.parseInt(nums.toString());
                                        break;
                                    }
                                    nums.append(cc);
                                    ++i;
                                }
                            }
                            i = 0;
                            while (i < mul) {
                                code = ControlCodes.getCode(part);
                                if (code == -1) {
                                    AssemblyParser.addToRam(ram, part);
                                } else {
                                    ram.add(code);
                                }
                                ++i;
                            }
                        } else {
                            AssemblyParser.addToRam(ram, String.valueOf(c));
                            continue;
lbl61:
                            // 1 sources

                            if (c == '\\' && config.isNonDecimalNumbersAware()) {
                                pos2 = data.toLowerCase(Locale.ENGLISH).indexOf("\\x", pos);
                                if (pos2 == pos && data.length() + 2 >= pos2) {
                                    hex = data.substring(pos2 + 2, pos2 + 4);
                                    val = Integer.parseInt(hex, 16);
                                    if (val != 255) {
                                        ram.add(val);
                                    } else {
                                        ram.add(126);
                                    }
                                    pos += 3;
                                    continue;
                                }
                                AssemblyParser.addToRam(ram, String.valueOf(c));
                                continue;
                            }
                            AssemblyParser.addToRam(ram, String.valueOf(c));
                        }
                    } while (++pos < data.length());
                    break block39;
                }
                throw new RuntimeException("Invalid text data: " + data);
            }
            if (datupper.startsWith(".BYTE")) {
                var12_34 = parts = AssemblyParser.strip(data.substring(5)).split(" ");
                var11_26 = parts.length;
                pos2 = 0;
                while (pos2 < var11_26) {
                    part = var12_34[pos2];
                    val = AssemblyParser.getLowByte(AssemblyParser.getValue(config, part, addr - 1, ccon, lcon, true, false, addrAdd, true));
                    ++addr;
                    ram.add(val);
                    ++pos2;
                }
            } else if (datupper.startsWith(".WORD")) {
                var12_35 = parts = AssemblyParser.strip(data.substring(5)).split(" ");
                var11_27 = parts.length;
                pos2 = 0;
                while (pos2 < var11_27) {
                    part = var12_35[pos2];
                    val = AssemblyParser.getValue(config, part, addr - 1, ccon, lcon, false, false, addrAdd, true);
                    addr += 2;
                    ram.add(AssemblyParser.getLowByteSigned(val));
                    ram.add(AssemblyParser.getHighByteSigned(val));
                    ++pos2;
                }
            } else if (datupper.startsWith(".REAL")) {
                var12_36 = parts = AssemblyParser.strip(data.substring(5)).split(" ");
                var11_28 = parts.length;
                pos2 = 0;
                while (pos2 < var11_28) {
                    part = var12_36[pos2];
                    val = AssemblyParser.getRealValue(part);
                    var19_54 = res = Conversions.compactFloat(Conversions.convertDouble(val));
                    var18_53 = res.length;
                    var17_52 = 0;
                    while (var17_52 < var18_53) {
                        r = var19_54[var17_52];
                        ram.add(AssemblyParser.getLowByte(r));
                        ++var17_52;
                    }
                    ++pos2;
                }
            } else if (datupper.startsWith(".ARRAY")) {
                var12_37 = parts = data.substring(6).trim().split(" ");
                var11_29 = parts.length;
                pos2 = 0;
                while (pos2 < var11_29) {
                    part = var12_37[pos2];
                    val = AssemblyParser.getValue(config, part, addr - 1, ccon, lcon, false, false, addrAdd, true);
                    if (val < 0) {
                        throw new RuntimeException("Value out of range: " + val);
                    }
                    i = 0;
                    while (i < val) {
                        ram.add(0);
                        ++i;
                    }
                    ++pos2;
                }
            } else {
                throw new RuntimeException("Invalid data definition: " + data);
            }
        }
        res = new int[ram.size()];
        cnt = 0;
        for (Integer rv : ram) {
            res[cnt++] = rv;
        }
        return res;
    }

    private static String strip(String txt) {
        boolean inForm = false;
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < txt.length()) {
            char c = txt.charAt(i);
            if (c == '{') {
                inForm = true;
            } else if (c == '}') {
                inForm = false;
            }
            if (c != ' ' || !inForm) {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString().trim();
    }

    private static void addToRam(List<Integer> ram, String part) {
        int i = 0;
        while (i < part.length()) {
            int val = AssemblyParser.getLowByte(part.charAt(i));
            ram.add(AssemblyParser.getConvertedChar(val));
            ++i;
        }
    }

    public static ConstantValue getConstant(CompilerConfig config, String linePart, ConstantsContainer ccon) {
        String linePart2 = Parser.replaceStrings(linePart, '_').trim();
        int pos = linePart2.indexOf("=");
        if (pos != -1) {
            String left = linePart.substring(0, pos).trim();
            String right = linePart.substring(pos + 1).trim();
            if (ccon != null && (right.contains("+") || right.contains("-") || right.contains("*") || right.contains("/") || right.contains("^") || right.contains(")") || ccon.get(right) != null) || Character.isLetter(right.charAt(0))) {
                return AssemblyParser.getConstantParsed(config, left, right, ccon, true);
            }
            int val = AssemblyParser.getValue(right);
            if (val < 256) {
                return new ConstantByte(left, val);
            }
            return new ConstantInt(left, val);
        }
        return null;
    }

    public static ConstantValue getConstantParsed(CompilerConfig config, String left, String right, ConstantsContainer ccon, boolean raiseError) {
        HashMap<String, String> names2vars = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        StringBuilder res = new StringBuilder();
        boolean inName = false;
        char varName = 'A';
        right = String.valueOf(right) + ";";
        int i = 0;
        while (i < right.length()) {
            char c = right.charAt(i);
            boolean ended = false;
            if (Character.isLetter(c)) {
                inName = true;
            }
            if (inName && Character.isLetterOrDigit(c) || c == '_') {
                sb.append(c);
            } else {
                ended = true;
            }
            if (ended || i == right.length() - 1) {
                inName = false;
                if (sb.length() > 0) {
                    String name = sb.toString();
                    sb.setLength(0);
                    boolean isFun = Parser.isFunction(name);
                    if (!isFun && Parser.isFunction(String.valueOf(name) + "$") && c == '$') {
                        isFun = true;
                    }
                    if (!isFun) {
                        String var = (String)names2vars.get(name);
                        if (var == null) {
                            char c2 = varName;
                            varName = (char)(c2 + 1);
                            var = "" + c2;
                            names2vars.put(name, var);
                        }
                        res.append(var);
                    } else {
                        res.append(name);
                    }
                }
                if (c != ';') {
                    res.append(c);
                }
            }
            if (c == ';') break;
            ++i;
        }
        Machine machine = new Machine();
        for (String name : names2vars.keySet()) {
            ConstantValue cv = ccon.get(name);
            if (cv == null) {
                return new ConstantDynamic(left, right, config, ccon);
            }
            machine.add(new Variable((String)names2vars.get(name), ccon.get(name).getValue()));
        }
        Term ressy = null;
        try {
            ressy = Parser.getTerm(config, res.toString(), machine, true, true);
        }
        catch (Throwable nfe) {
            if (raiseError) {
                throw nfe;
            }
            return null;
        }
        int resultValue = ((Number)ressy.eval(machine)).intValue();
        if (resultValue < 256) {
            return new ConstantByte(left, resultValue);
        }
        return new ConstantInt(left, resultValue);
    }

    private static int getValue(String number) {
        number = number.trim();
        int val = 0;
        try {
            val = number.startsWith("$") ? Integer.parseInt(number.substring(1), 16) : (number.startsWith("%") ? Integer.parseInt(number.substring(1), 2) : Integer.parseInt(number));
            if (val < Short.MIN_VALUE || val > 65535) {
                throw new RuntimeException("Value out of range: " + val);
            }
            return val;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid number: " + number, e);
        }
    }

    private static double getRealValue(String number) {
        number = number.trim();
        try {
            return Double.parseDouble(number);
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid number: " + number, e);
        }
    }

    private static int getConvertedChar(int c) {
        if (c >= 97 && c <= 122) {
            c = (char)(c - 32);
        } else if (c >= 65 && c <= 90) {
            c = (char)(c + 32);
        }
        return c;
    }
}

