/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.assembly;

import com.sixtyfour.elements.mnemonics.MnemonicList;
import com.sixtyfour.parser.assembly.AssemblyParser;
import com.sixtyfour.parser.assembly.DelayedLabel;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LabelsContainer {
    private Map<String, Integer> labels2Addr = new HashMap<String, Integer>();
    private Map<Integer, DelayedLabel> delayed = new HashMap<Integer, DelayedLabel>();
    private Machine machine = null;

    public LabelsContainer(Machine machine) {
        this.machine = machine;
    }

    public void put(String label, int value) {
        this.labels2Addr.put(label, value);
        int orgValue = value;
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (Map.Entry<Integer, DelayedLabel> entry : this.delayed.entrySet()) {
            DelayedLabel dl = entry.getValue();
            String name = label;
            value = orgValue;
            if (!name.equals(dl.getLabel())) continue;
            value += dl.getAdd();
            toRemove.add(entry.getKey());
            int targetAddr = entry.getKey();
            int[] ram = this.machine.getRam();
            int opcode = ram[targetAddr];
            if (!dl.isDataLine() && MnemonicList.getConditonalBranches().contains(opcode)) {
                int offset = value - (targetAddr + 2);
                if (offset <= 127 && offset >= -128) {
                    ram[++targetAddr] = AssemblyParser.getLowByte(offset);
                    continue;
                }
                throw new RuntimeException("Destination address out of range: " + opcode + "/" + value + "/" + targetAddr + "/" + offset + "/" + label);
            }
            if (dl.isLow()) {
                ram[++targetAddr] = AssemblyParser.getLowByte(value);
                continue;
            }
            if (dl.isHigh()) {
                ram[++targetAddr] = AssemblyParser.getHighByte(value);
                continue;
            }
            ram[++targetAddr] = AssemblyParser.getLowByte(value);
            ram[++targetAddr] = AssemblyParser.getHighByte(value);
        }
        for (Integer tr : toRemove) {
            this.delayed.remove(tr);
        }
    }

    private String truncateAdd(String name) {
        int pos = name.lastIndexOf("+");
        if (pos != -1 && name.lastIndexOf("\"") < pos) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public boolean hasDelayedLabels() {
        return !this.delayed.isEmpty();
    }

    public String getFirstDelayedLabel() {
        if (!this.delayed.isEmpty()) {
            return this.delayed.entrySet().iterator().next().getValue().getLabel();
        }
        return null;
    }

    public Integer get(String name) {
        return this.labels2Addr.get(name);
    }

    public void addDelayedLabelRef(int addr, String label, boolean low, boolean high, int addrAdd, boolean isDataLine) {
        this.delayed.put(addr, new DelayedLabel(this.truncateAdd(label), low, high, addrAdd, isDataLine));
    }
}

