/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.logic;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.logic.Comparator;
import com.sixtyfour.parser.logic.LogicTerm;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.Checker;
import java.util.HashMap;
import java.util.Map;

public class LogicParser {
    public static boolean isLogicTerm(String term) {
        return (term = Parser.replaceStrings(term, ' ')).contains("=") || term.contains(">") || term.contains("<");
    }

    public static LogicTerm getTerm(CompilerConfig config, String term, Machine machine, Map<String, Term> termMap) {
        HashMap<String, LogicTerm> blocks = new HashMap<String, LogicTerm>();
        term = LogicParser.processLogicOperations(term);
        boolean inString = false;
        term = "(" + TermEnhancer.removeWhiteSpace(term) + ")";
        TermEnhancer.checkBrackets(term);
        String lastPart = term;
        int lastStart = 0;
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '(') {
                    int end = LogicParser.findEndBracket(term, i);
                    if (end <= i + 1) {
                        throw new RuntimeException("Syntax error: " + term);
                    }
                } else if (i == term.length() - 1) {
                    String toProcess = lastPart;
                    int startPos = lastStart;
                    String subt = toProcess.substring(1, toProcess.length() - 1);
                    String blockName = LogicParser.createLogicBlock(config, subt, blocks, machine, termMap);
                    int endy = Math.min(startPos + toProcess.length(), term.length());
                    term = String.valueOf(term.substring(0, startPos)) + blockName + (endy != term.length() ? term.substring(endy, term.length()) : "");
                    i = -1;
                    inString = false;
                    lastPart = term;
                    lastStart = 0;
                    String nbrack = term.replace("(", "").replace(")", "");
                    if (blocks.containsKey(nbrack)) {
                        return (LogicTerm)blocks.get(nbrack);
                    }
                }
            }
            ++i;
        }
        throw new RuntimeException("Syntax error: " + term);
    }

    private static String processLogicOperations(String term) {
        String partn;
        String part;
        char c;
        int i;
        int brackets;
        boolean inString;
        int pos;
        String rep;
        String[] reps;
        String[] stringArray = reps = new String[]{")=", ")>", ")<"};
        int n = reps.length;
        int n2 = 0;
        while (n2 < n) {
            rep = stringArray[n2];
            pos = 0;
            do {
                if ((pos = term.indexOf(rep, pos)) == -1) continue;
                inString = false;
                brackets = 0;
                i = pos;
                while (i >= 0) {
                    c = term.charAt(i);
                    if (c == '\"') {
                        boolean bl = inString = !inString;
                    }
                    if (!inString) {
                        if (c == ')') {
                            --brackets;
                        } else if (c == '(' && ++brackets == 0) {
                            part = term.substring(i, pos + 1);
                            partn = TermEnhancer.replaceLogicOperators(part);
                            term = String.valueOf(term.substring(0, i)) + partn + term.substring(pos + 1);
                            pos -= part.length() - partn.length();
                            break;
                        }
                    }
                    --i;
                }
                pos += 2;
            } while (pos != -1);
            ++n2;
        }
        stringArray = reps = new String[]{"=(", ">(", "<("};
        n = reps.length;
        n2 = 0;
        while (n2 < n) {
            rep = stringArray[n2];
            pos = 0;
            do {
                if ((pos = term.indexOf(rep, pos)) == -1) continue;
                inString = false;
                brackets = 0;
                i = pos;
                while (i < term.length()) {
                    c = term.charAt(i);
                    if (c == '\"') {
                        boolean bl = inString = !inString;
                    }
                    if (!inString) {
                        if (c == ')') {
                            if (--brackets == 0) {
                                part = term.substring(pos, i + 1);
                                partn = TermEnhancer.replaceLogicOperators(part);
                                term = String.valueOf(term.substring(0, pos)) + partn + term.substring(i + 1);
                                pos -= part.length() - partn.length();
                                break;
                            }
                        } else if (c == '(') {
                            ++brackets;
                        }
                    }
                    ++i;
                }
                pos += 2;
            } while (pos != -1);
            ++n2;
        }
        return term;
    }

    private static String createLogicBlock(CompilerConfig config, String toProcess, Map<String, LogicTerm> blocks, Machine machine, Map<String, Term> termMap) {
        LogicTerm block = new LogicTerm("{l" + blocks.size() + "}");
        String part = toProcess;
        boolean inString = false;
        int closest = -1;
        int i = 0;
        while (i < part.length()) {
            char c = part.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!(inString || c != '<' && c != '>' && c != '=')) {
                closest = i;
                break;
            }
            ++i;
        }
        String left = null;
        String right = null;
        Comparator comp = null;
        if (closest != -1) {
            left = part.substring(0, closest);
            right = part.substring(closest);
            comp = Comparator.getComparator(right);
            if (comp == null) {
                throw new RuntimeException("Syntax error: " + part);
            }
        } else {
            throw new RuntimeException("Syntax error: " + part);
        }
        right = right.substring(comp.getTermLength());
        if (left != null) {
            block.setComparator(comp);
            int bl = LogicParser.getBracketDelta(left);
            if (bl > 0) {
                left = left.substring(bl);
            } else if (bl < 0) {
                left = left.substring(0, left.length() + bl);
            }
            block.setLeft(Parser.getTerm(config, left, machine, false, true, termMap));
            if (right != null) {
                int br = LogicParser.getBracketDelta(right);
                if (br < 0) {
                    right = right.substring(0, right.length() + br);
                }
                block.setRight(Parser.getTerm(config, right, machine, false, true, termMap));
                LogicParser.checkTypeMismatch(block);
            }
        }
        blocks.put(block.getName(), block);
        return block.getName();
    }

    private static void checkTypeMismatch(LogicTerm compy) {
        if (Checker.isTypeMismatch(compy)) {
            Type lt = compy.getLeft().getType(true);
            Type rt = compy.getRight().getType(true);
            throw new RuntimeException("Type mismatch error: " + (Object)((Object)lt) + " | " + (Object)((Object)rt) + " --- " + compy.getLeft() + " --- " + compy.getRight());
        }
    }

    private static int getBracketDelta(String term) {
        int brackets = 0;
        boolean inString = false;
        int i = 0;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '(') {
                    ++brackets;
                } else if (c == ')') {
                    --brackets;
                }
            }
            ++i;
        }
        return brackets;
    }

    private static int findEndBracket(String term, int pos) {
        int brackets = 0;
        boolean inString = false;
        int i = pos;
        while (i < term.length()) {
            char c = term.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '(') {
                    ++brackets;
                } else if (c == ')' && --brackets == 0) {
                    return i;
                }
            }
            ++i;
        }
        if (brackets == 0) {
            return term.length();
        }
        throw new RuntimeException("Syntax error: " + term);
    }
}

