/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.logic;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.cbmnative.CodeContainer;
import com.sixtyfour.parser.logic.Comparator;
import com.sixtyfour.system.Machine;
import java.util.ArrayList;
import java.util.List;

public class LogicTerm
implements Atom {
    private String name;
    private Term left;
    private Term right;
    private Comparator comparator;

    public LogicTerm(String name) {
        this.name = name;
    }

    @Override
    public List<CodeContainer> evalToCode(CompilerConfig config, Machine machine) {
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<CodeContainer> cc = new ArrayList<CodeContainer>();
        List<String> n1 = this.left.evalToCode(config, machine).get(0).getExpression();
        List<String> n2 = this.right.evalToCode(config, machine).get(0).getExpression();
        ret.add(0, "_");
        n2.add(0, ":" + (this.left.getType() == Type.STRING ? "S" : "") + this.comparator.evalToCode());
        ret.addAll(0, n1);
        ret.addAll(0, n2);
        cc.add(new CodeContainer(ret));
        return cc;
    }

    public Term getLeft() {
        return this.left;
    }

    public void setLeft(Term left) {
        this.left = left;
    }

    public Term getRight() {
        return this.right;
    }

    public void setRight(Term right) {
        this.right = right;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public String toString() {
        return this.left + " " + (Object)((Object)this.comparator) + " " + this.right;
    }

    @Override
    public Type getType() {
        return Type.INTEGER;
    }

    @Override
    public Type getType(boolean ignoreMT) {
        return Type.INTEGER;
    }

    @Override
    public Object eval(Machine machine) {
        boolean ok = this.evalToBoolean(machine);
        return ok ? -1 : 0;
    }

    @Override
    public boolean isTerm() {
        return false;
    }

    @Override
    public String toCode(Machine machine) {
        return null;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public List<Term> getTerms() {
        ArrayList<Term> terms = new ArrayList<Term>();
        terms.add(this.right);
        terms.add(this.left);
        return terms;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof LogicTerm) {
            if (o == this && (!(this.left instanceof Function) || ((Function)((Object)this.left)).isDeterministic())) {
                return true;
            }
            boolean eq = true;
            if (this.left != null) {
                eq = this.left.equals(((LogicTerm)o).getLeft());
            }
            if (this.right != null && eq) {
                eq = this.right.equals(((LogicTerm)o).getRight());
            }
            if (this.comparator != null && eq) {
                eq = this.comparator.equals((Object)((LogicTerm)o).getComparator());
            }
            return eq;
        }
        return false;
    }

    public int hashCode() {
        return (this.left != null ? this.left.hashCode() : 0) + (this.right != null ? this.right.hashCode() : 0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private boolean evalToBoolean(Machine machine) {
        Object lo = this.left.eval(machine);
        Object ro = this.right != null ? this.right.eval(machine) : null;
        boolean ret = false;
        if (this.left.getType().equals((Object)Type.STRING)) {
            if (this.right == null) {
                ret = true;
            } else {
                int res = lo.toString().compareTo(ro.toString());
                ret = this.comparator.equals((Object)Comparator.EQUAL) && res == 0 || this.comparator.equals((Object)Comparator.LARGER) && res > 0 || this.comparator.equals((Object)Comparator.SMALLER) && res < 0 || this.comparator.equals((Object)Comparator.LARGER_OR_EQUAL) && res >= 0 || this.comparator.equals((Object)Comparator.SMALLER_OR_EQUAL) && res <= 0 || this.comparator.equals((Object)Comparator.NOT_EQUAL) && res != 0;
            }
        } else {
            Number lon = (Number)lo;
            Number ron = (Number)ro;
            if (this.right == null) {
                ret = lon.doubleValue() != 0.0;
            } else {
                double res = lon.doubleValue() - ron.doubleValue();
                ret = this.comparator.equals((Object)Comparator.EQUAL) && res == 0.0 || this.comparator.equals((Object)Comparator.LARGER) && res > 0.0 || this.comparator.equals((Object)Comparator.SMALLER) && res < 0.0 || this.comparator.equals((Object)Comparator.LARGER_OR_EQUAL) && res >= 0.0 || this.comparator.equals((Object)Comparator.SMALLER_OR_EQUAL) && res <= 0.0 || this.comparator.equals((Object)Comparator.NOT_EQUAL) && res != 0.0;
            }
        }
        return ret;
    }
}

