/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.optimize;

import com.sixtyfour.Logger;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Constant;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Operator;
import com.sixtyfour.parser.Term;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;

public class ConstantFolder {
    public static void foldConstants(CompilerConfig config, Machine machine) {
        if (config.isConstantFolding()) {
            Logger.log("Folding constants...");
            for (Command cmd : machine.getCommandList()) {
                for (Term cmdTerm : cmd.getAllTerms()) {
                    if (cmdTerm == null) continue;
                    ConstantFolder.foldConstants(config, cmdTerm, machine);
                }
            }
        }
    }

    public static Term foldConstants(CompilerConfig config, Term finalTerm, Machine machine) {
        if (config.isConstantFolding()) {
            Atom left = finalTerm.getLeft();
            Atom right = finalTerm.getRight();
            Operator op = finalTerm.getOperator();
            if (op.isNop()) {
                if (left.isConstant()) {
                    ConstantFolder.setConstant(finalTerm, machine, left);
                }
                return finalTerm;
            }
            if (left.isConstant() && right.isConstant() && !op.isDelimiter() && Type.isAssignable(left.getType(), right.getType())) {
                ConstantFolder.setConstant(finalTerm, machine, left);
            } else {
                Function fun;
                Constant<?> conty;
                if (left.isTerm()) {
                    finalTerm.setLeft(ConstantFolder.foldConstants(config, (Term)left, machine));
                }
                if (right.isTerm()) {
                    finalTerm.setRight(ConstantFolder.foldConstants(config, (Term)right, machine));
                }
                if (left instanceof Variable && !((Variable)left).isArray() && left.isConstant()) {
                    conty = ConstantFolder.createConstant(left, left.eval(machine));
                    finalTerm.setLeft(conty);
                }
                if (right instanceof Variable && !((Variable)right).isArray() && right.isConstant()) {
                    conty = ConstantFolder.createConstant(right, right.eval(machine));
                    finalTerm.setRight(conty);
                }
                if (left instanceof Function) {
                    fun = (Function)left;
                    fun.setTerm(ConstantFolder.foldConstants(config, fun.getTerm(), machine));
                }
                if (right instanceof Function) {
                    fun = (Function)right;
                    fun.setTerm(ConstantFolder.foldConstants(config, fun.getTerm(), machine));
                }
            }
        }
        return finalTerm;
    }

    private static void setConstant(Term finalTerm, Machine machine, Atom left) {
        Object val = finalTerm.eval(machine);
        Constant<?> conty = ConstantFolder.createConstant(left, val);
        if (conty != null) {
            finalTerm.setOperator(Operator.NOP);
            finalTerm.setLeft(conty);
            finalTerm.setRight(new Constant<Integer>(0));
            finalTerm.setConstant(true);
        }
    }

    private static Constant<?> createConstant(Atom left, Object val) {
        Constant<Object> conty = null;
        if (left.getType().equals((Object)Type.STRING)) {
            conty = new Constant<String>(val.toString());
        } else if (VarUtils.isFloat(val)) {
            conty = new Constant<Float>((Float)val);
        } else if (VarUtils.isDouble(val)) {
            conty = new Constant<Double>((Double)val);
        } else if (VarUtils.isInteger(val)) {
            conty = new Constant<Integer>((Integer)val);
        }
        return conty;
    }
}

