/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.optimize;

import com.sixtyfour.Logger;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Constant;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.Let;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.parser.Operator;
import com.sixtyfour.parser.Term;
import com.sixtyfour.system.Machine;
import java.util.HashSet;
import java.util.Set;

public class ConstantPropagator {
    private static final Set<Integer> POWERS_OF_TWO = new HashSet<Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(2);
            this.add(4);
            this.add(8);
            this.add(16);
            this.add(32);
            this.add(64);
            this.add(128);
            this.add(256);
            this.add(512);
        }
    };

    public static boolean propagateConstants(CompilerConfig config, Machine machine) {
        boolean found = false;
        boolean doneSomething = false;
        if (config.isConstantPropagation()) {
            Logger.log("Propagating constants...");
            do {
                found = false;
                for (Command cmd : machine.getCommandList()) {
                    Term term;
                    boolean termIsConstant;
                    Let let;
                    Variable var;
                    if (!cmd.isCommand("LET") || !machine.isAssignedOnce(var = (let = (Let)cmd).getVar()) || var.isConstant() || !(termIsConstant = ConstantPropagator.checkForConstant(config, machine, term = let.getTerm())) || var.isSystem()) continue;
                    var.setValue(term.eval(machine));
                    var.setConstant(true);
                    Logger.log(var + " can be considered constant!");
                    doneSomething = true;
                    found = true;
                }
            } while (found);
        }
        return doneSomething;
    }

    public static boolean checkForConstant(CompilerConfig config, Machine machine, Term t) {
        if (t == null) {
            return false;
        }
        boolean[] isConstant = new boolean[]{true};
        return ConstantPropagator.checkForConstant(config, machine, t, isConstant);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static boolean checkForConstant(CompilerConfig config, Machine machine, Term t, boolean[] isConstant) {
        block24: {
            block25: {
                block23: {
                    block22: {
                        block21: {
                            thresHold = 1000.0;
                            if (t.getOperator().isDelimiter()) {
                                isConstant[0] = false;
                                return false;
                            }
                            if (!config.isDeadStoreEliminationOfStrings() && t.getType(true) == Type.STRING) {
                                isConstant[0] = false;
                                return false;
                            }
                            left = t.getLeft();
                            right /* !! */  = t.getRight();
                            if (t.getOperator().isDivision()) {
                                val = 0.0;
                                if (right /* !! */ .isConstant()) {
                                    val = ((Number)right /* !! */ .eval(machine)).doubleValue();
                                    if (v0 < thresHold && val > -thresHold) {
                                        if (val != (double)((int)val) || !ConstantPropagator.POWERS_OF_TWO.contains((int)val)) {
                                            if (config.isFloatOptimizations()) {
                                                t.setOperator(new Operator('*'));
                                                right /* !! */  = new Constant<Double>(1.0 / val);
                                                t.setRight(right /* !! */ );
                                            }
                                        } else if (ConstantPropagator.POWERS_OF_TWO.contains((int)val)) {
                                            right /* !! */  = new Constant<Integer>((int)val);
                                            t.setRight(right /* !! */ );
                                        }
                                    }
                                }
                            }
                            if (t.getOperator().isPlus() && t.getType(true) != Type.STRING && left.isConstant() && ((Number)left.eval(machine)).doubleValue() == 1.0) {
                                t.setLeft(right /* !! */ );
                                t.setRight(left);
                                left = t.getLeft();
                                right /* !! */  = t.getRight();
                            }
                            if (!t.getOperator().isMultiplication()) break block21;
                            val = 0.0;
                            if (!right /* !! */ .isConstant()) ** GOTO lbl-1000
                            val = ((Number)right /* !! */ .eval(machine)).doubleValue();
                            if (v1 < thresHold && val > -thresHold) {
                                if (val == (double)((int)val) && ConstantPropagator.POWERS_OF_TWO.contains((int)val)) {
                                    right /* !! */  = new Constant<Integer>((int)val);
                                    t.setRight(right /* !! */ );
                                }
                            } else if (left.isConstant()) {
                                val = ((Number)left.eval(machine)).doubleValue();
                                if (v2 < thresHold && val > -thresHold && val == (double)((int)val) && ConstantPropagator.POWERS_OF_TWO.contains((int)val)) {
                                    left = right /* !! */ ;
                                    right /* !! */  = new Constant<Integer>((int)val);
                                    t.setLeft(left);
                                    t.setRight(right /* !! */ );
                                }
                            }
                        }
                        if (t.getOperator().isMultiplication() && (left.isConstant() && ((Number)left.eval(machine)).doubleValue() == 10.0 || right /* !! */ .isConstant() && ((Number)right /* !! */ .eval(machine)).doubleValue() == 1.6777217E7)) {
                            t.setLeft(right /* !! */ );
                            t.setRight(left);
                            left = t.getLeft();
                            right /* !! */  = t.getRight();
                        }
                        if (!isConstant[0]) {
                            return false;
                        }
                        if (!left.isTerm()) break block22;
                        lt = (Term)left;
                        isConstant[0] = isConstant[0] & ConstantPropagator.checkForConstant(config, machine, lt, isConstant);
                        break block23;
                    }
                    if (left.isConstant()) break block23;
                    if (!(left instanceof Function)) ** GOTO lbl66
                    func = (Function)left;
                    if (func.isDeterministic() && !func.isExcluded()) {
                        isConstant[0] = isConstant[0] & ConstantPropagator.checkForConstant(config, machine, func.getTerm(), isConstant);
                    } else {
                        isConstant[0] = false;
                        return false;
lbl66:
                        // 1 sources

                        isConstant[0] = false;
                        return false;
                    }
                }
                if (right /* !! */  == null) break block24;
                if (!isConstant[0] || !right /* !! */ .isTerm()) break block25;
                rt = (Term)right /* !! */ ;
                isConstant[0] = isConstant[0] & ConstantPropagator.checkForConstant(config, machine, rt, isConstant);
                break block24;
            }
            if (right /* !! */ .isConstant()) break block24;
            if (!(right /* !! */  instanceof Function)) ** GOTO lbl83
            func = (Function)right /* !! */ ;
            if (func.isDeterministic() && !func.isExcluded()) {
                isConstant[0] = isConstant[0] & ConstantPropagator.checkForConstant(config, machine, func.getTerm(), isConstant);
            } else {
                isConstant[0] = false;
                return false;
lbl83:
                // 1 sources

                isConstant[0] = false;
                return false;
            }
        }
        return isConstant[0];
    }
}

