/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.optimize;

import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.PCode;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.Data;
import com.sixtyfour.elements.commands.End;
import com.sixtyfour.elements.commands.Goto;
import com.sixtyfour.elements.commands.If;
import com.sixtyfour.elements.commands.Jump;
import com.sixtyfour.elements.commands.New;
import com.sixtyfour.elements.commands.Return;
import com.sixtyfour.elements.commands.Run;
import com.sixtyfour.elements.commands.Stop;
import com.sixtyfour.parser.Line;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeadCodeChecker {
    public static PCode removeDeadCode(PCode code) {
        Logger.log("Detecting dead code...");
        List<Integer> nums = code.getLineNumbers();
        Map<Integer, Line> lineMap = code.getLines();
        HashSet<Integer> used = new HashSet<Integer>();
        if (nums.isEmpty()) {
            return code;
        }
        DeadCodeChecker.addDatas(lineMap, used);
        DeadCodeChecker.trackCode(nums, lineMap, used, 0);
        Logger.log(String.valueOf(nums.size() - used.size()) + " lines of dead code removed!");
        for (Integer num : nums) {
            if (used.contains(num)) continue;
            lineMap.remove(num);
        }
        nums.retainAll(used);
        return new PCode(nums, lineMap);
    }

    private static void addDatas(Map<Integer, Line> lineMap, Set<Integer> used) {
        block0: for (Map.Entry<Integer, Line> lineEntry : lineMap.entrySet()) {
            Line line = lineEntry.getValue();
            List<Command> coms = line.getCommands();
            for (Command com : coms) {
                if (!(com instanceof Data)) continue;
                used.add(lineEntry.getKey());
                continue block0;
            }
        }
    }

    private static void trackCode(List<Integer> nums, Map<Integer, Line> lineMap, Set<Integer> used, int idx) {
        if (idx < 0) {
            throw new RuntimeException("Jump to undefined line " + idx);
        }
        Integer num = nums.get(idx);
        if (used.contains(num)) {
            return;
        }
        used.add(num);
        Line line = lineMap.get(num);
        List<Command> coms = line.getCommands();
        boolean cond = false;
        for (Command com : coms) {
            if (com instanceof If) {
                cond = true;
            }
            if (com instanceof Jump) {
                Jump jump = (Jump)((Object)com);
                List<Integer> tnums = jump.getTargetLineNumbers();
                for (Integer tnum : tnums) {
                    DeadCodeChecker.trackCode(nums, lineMap, used, DeadCodeChecker.getIndex(tnum, nums));
                }
                if (!(com instanceof Goto) || cond) continue;
                return;
            }
            if (!cond) {
                if (com instanceof End || com instanceof Stop || com instanceof New) {
                    return;
                }
                if (com instanceof Return) {
                    return;
                }
            }
            if (!(com instanceof Run)) continue;
            DeadCodeChecker.trackCode(nums, lineMap, used, 0);
        }
        if (++idx < nums.size()) {
            DeadCodeChecker.trackCode(nums, lineMap, used, idx);
        }
    }

    private static int getIndex(Integer tnum, List<Integer> nums) {
        int idx = 0;
        for (Integer num : nums) {
            if (num.equals(tnum)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }
}

