/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.optimize;

import com.sixtyfour.Basic;
import com.sixtyfour.Logger;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.Let;
import com.sixtyfour.elements.functions.Function;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.logic.LogicTerm;
import com.sixtyfour.parser.optimize.ConstantPropagator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeadStoreEliminator {
    public static boolean eliminateDeadStores(CompilerConfig config, Basic basic) {
        if (config.isDeadStoreElimination()) {
            Logger.log("Eliminating dead stores...");
            List<Command> commands = basic.getMachine().getCommandList();
            HashSet<Term> terms = new HashSet<Term>();
            for (Command cmd : commands) {
                List<Term> cmdTerms = cmd.getAllTerms();
                for (Term cmdTerm : cmdTerms) {
                    if (cmdTerm == null || ConstantPropagator.checkForConstant(config, basic.getMachine(), cmdTerm)) continue;
                    terms.add(cmdTerm);
                }
            }
            ArrayList<Command> toRemove = new ArrayList<Command>();
            for (Command cmd : commands) {
                boolean found;
                if (!cmd.isCommand("LET")) continue;
                Let let = (Let)cmd;
                String varName = let.getVar().getUpperCaseName();
                if (!config.isDeadStoreEliminationOfStrings() && varName.contains("$") || let.getVar().isSystem() || let.getVar().isSupposedToBeArray() || (found = DeadStoreEliminator.findVariableInTerms(varName, terms))) continue;
                toRemove.add(cmd);
            }
            basic.removeCommands(toRemove);
            return toRemove.size() > 0;
        }
        return false;
    }

    private static boolean findVariableInTerms(String varName, Set<Term> terms) {
        boolean found = false;
        for (Term term : terms) {
            if (found |= DeadStoreEliminator.findVariable(varName, term)) break;
        }
        return found;
    }

    private static boolean findVariable(String varName, Term term) {
        boolean found = false;
        Atom left = term.getLeft();
        Atom right = term.getRight();
        if (left != null && left instanceof LogicTerm) {
            found = DeadStoreEliminator.findVariableInTerms(varName, new HashSet<Term>(((LogicTerm)LogicTerm.class.cast(left)).getTerms()));
        }
        if (!found && left != null && left.isTerm()) {
            found = DeadStoreEliminator.findVariable(varName, (Term)left);
        }
        if (!found && right != null && right.isTerm()) {
            found = DeadStoreEliminator.findVariable(varName, (Term)right);
        }
        if (!found && left != null && left instanceof Function) {
            found = DeadStoreEliminator.findVariable(varName, ((Function)left).getTerm());
        }
        if (!found && right != null && right instanceof LogicTerm) {
            found = DeadStoreEliminator.findVariableInTerms(varName, new HashSet<Term>(((LogicTerm)LogicTerm.class.cast(right)).getTerms()));
        }
        if (!found && right != null && right instanceof Function) {
            found = DeadStoreEliminator.findVariable(varName, ((Function)right).getTerm());
        }
        if (!found && left != null && left instanceof Variable) {
            found = ((Variable)left).getUpperCaseName().equals(varName);
        }
        if (!found && right != null && right instanceof Variable) {
            found = ((Variable)right).getUpperCaseName().equals(varName);
        }
        return found;
    }
}

