/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.parser.optimize;

import com.sixtyfour.Basic;
import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.PCode;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Constant;
import com.sixtyfour.elements.Type;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.If;
import com.sixtyfour.elements.commands.Rem;
import com.sixtyfour.parser.Atom;
import com.sixtyfour.parser.Line;
import com.sixtyfour.parser.Operator;
import com.sixtyfour.parser.Parser;
import com.sixtyfour.parser.Term;
import com.sixtyfour.parser.TermBuilder;
import com.sixtyfour.parser.TermEnhancer;
import com.sixtyfour.parser.optimize.ConstantPropagator;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.VarUtils;
import java.util.Map;

public class TermOptimizer {
    public static String optimizePrintTerm(String line) {
        line = TermEnhancer.removeWhiteSpace(line);
        StringBuilder sb = new StringBuilder();
        boolean inString = false;
        int brackets = 0;
        boolean modify = false;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            modify = false;
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!inString) {
                if (c == '(') {
                    ++brackets;
                }
                if (c == ')') {
                    --brackets;
                }
                if (brackets == 0 && (c == '$' || c == '\"' || c == ')') && i < line.length() - 2) {
                    char nc = line.charAt(i + 1);
                    char nnc = line.charAt(i + 2);
                    if (nc == '+' && (nnc == '\"' || Character.isAlphabetic(nnc))) {
                        modify = true;
                    }
                }
            }
            sb.append(c);
            if (modify) {
                sb.append(';');
                ++i;
            }
            ++i;
        }
        return sb.toString();
    }

    public static Term optimizeTermTree(Term finalTerm, Machine machine) {
        Atom left = finalTerm.getLeft();
        Atom right = finalTerm.getRight();
        if (!left.isTerm()) {
            return finalTerm;
        }
        if (!finalTerm.getOperator().isNop()) {
            finalTerm.setLeft(TermOptimizer.optimizeTermTree((Term)left, machine));
            if (right.isTerm()) {
                finalTerm.setRight(TermOptimizer.optimizeTermTree((Term)right, machine));
            }
            return finalTerm;
        }
        return (Term)left;
    }

    public static void handleConstantConditions(CompilerConfig config, Machine machine, Basic basic) {
        if (config.isConstantFolding()) {
            PCode pCode = basic.getPCode();
            block0: for (Integer lineNumber : pCode.getLineNumbers()) {
                Line line = pCode.getLines().get(lineNumber);
                int i = 0;
                while (i < line.getCommands().size()) {
                    Command cmd = line.getCommands().get(i);
                    if (cmd.isConditional()) {
                        boolean allConst = true;
                        for (Term t : cmd.getAllTerms()) {
                            if (!(allConst &= ConstantPropagator.checkForConstant(config, machine, t))) break;
                        }
                        if (allConst) {
                            double res = VarUtils.getDouble(((If)cmd).getLogicTerm().eval(machine));
                            if (res == 0.0) {
                                Logger.log("Removed conditional block at line " + lineNumber);
                                int p = 0;
                                while (p < line.getCommands().size()) {
                                    line.getCommands().set(p, new Rem());
                                    ++p;
                                }
                                continue block0;
                            }
                            Logger.log("Always execute conditional block at line " + lineNumber);
                            line.getCommands().remove(i);
                            --i;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static Term optimizeTerm(CompilerConfig config, Machine machine, Term ret, Map<String, Term> termMap, TermBuilder builder) {
        if (ret.getType(true) == Type.STRING) {
            return ret;
        }
        if (ret.getOperator().isDelimiter()) {
            return ret;
        }
        if (ret.getLeft() instanceof Constant && ret.getOperator().isNop()) {
            return ret;
        }
        boolean isConst = ConstantPropagator.checkForConstant(config, machine, ret);
        if (isConst) {
            String ts = ret.eval(machine).toString();
            if (ts.toLowerCase().contains("e")) {
                return ret;
            }
            if (ts.endsWith(".0")) {
                ts = ts.substring(0, ts.length() - 2);
            }
            Term t = new Term(ts, termMap);
            if (!(t = builder.build(config, t, termMap, machine)).isComplete()) {
                t.setOperator(Operator.NOP);
                t.setRight(new Constant<Integer>(0));
            }
            ret = t;
        }
        return ret;
    }

    public static String optimizeLinearIndexTerm(String term) {
        int pos = 0;
        do {
            int lenTerm = term.length();
            if ((pos = term.indexOf("int(", pos)) == -1) continue;
            int sp = pos + 4;
            int ep = term.indexOf(")", sp);
            if (ep != -1) {
                String ns = term.substring(sp, ep);
                if (Parser.isInteger(ns) && ep < term.length() - 2 && term.charAt(ep + 1) == '*') {
                    int fv = Integer.parseInt(ns);
                    int sp1 = term.indexOf("+", ep);
                    ns = sp1 != -1 ? term.substring(ep + 2, sp1) : term.substring(ep + 2);
                    if (!Parser.isInteger(ns = ns.substring(1, ns.length() - 1))) continue;
                    int sv = Integer.parseInt(ns);
                    int tv = fv * sv;
                    term = tv == 0 ? String.valueOf(term.substring(0, pos > 0 ? pos - 1 : pos)) + (sp1 != -1 ? term.substring(sp1) : "") : String.valueOf(term.substring(0, pos)) + tv + (sp1 != -1 ? term.substring(sp1) : "");
                    pos -= lenTerm - term.length();
                    continue;
                }
                pos = ep;
                continue;
            }
            pos = sp;
        } while (pos != -1);
        return term;
    }
}

