/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.plugins.impl;

import com.sixtyfour.plugins.OutputChannel;
import com.sixtyfour.plugins.PrintConsumer;

public class ConsoleOutputChannel
implements OutputChannel {
    private int cursor = 0;
    private int channel = 0;
    private PrintConsumer otherConsumer = null;

    @Override
    public void print(int id, String txt) {
        if (this.otherConsumer != null) {
            this.otherConsumer.print(this.channel, txt);
        } else {
            this.setCursor(this.getCursor() + txt.length());
            System.out.print(txt);
        }
    }

    @Override
    public void println(int id, String txt) {
        if (this.otherConsumer != null) {
            this.otherConsumer.println(this.channel, txt);
        } else {
            System.out.println(txt);
            this.setCursor(0);
        }
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    @Override
    public void setPrintConsumer(PrintConsumer otherConsumer, int channel) {
        this.otherConsumer = otherConsumer;
        this.channel = channel;
    }

    @Override
    public PrintConsumer getPrintConsumer() {
        return this.otherConsumer;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void systemPrint(int id, String txt) {
        this.print(id, txt != null ? txt.toUpperCase() : "");
    }

    @Override
    public void systemPrintln(int id, String txt) {
        this.println(id, txt != null ? txt.toUpperCase() : "");
    }
}

