/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.plugins.impl;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.plugins.DeviceProvider;
import com.sixtyfour.plugins.FileMode;
import com.sixtyfour.plugins.FileType;
import com.sixtyfour.plugins.FileWrapper;
import com.sixtyfour.plugins.OutputChannel;
import com.sixtyfour.plugins.PrintConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MemoryDeviceProvider
implements DeviceProvider {
    private Map<Integer, FileWrapper> number2File = new HashMap<Integer, FileWrapper>();
    private List<FileWrapper> closedFiles = new ArrayList<FileWrapper>();
    private OutputChannel consoleOutput = null;

    public MemoryDeviceProvider(OutputChannel consoleOutput) {
        this.consoleOutput = consoleOutput;
    }

    @Override
    public void close(int fileNumber) {
        if (!this.number2File.containsKey(fileNumber)) {
            return;
        }
        FileWrapper file = this.number2File.remove(fileNumber);
        if (file.getDeviceNumber() == 3) {
            this.dump(this.consoleOutput, file, fileNumber);
        }
        if (!file.getFileMode().equals((Object)FileMode.READ) && !file.getFileMode().equals((Object)FileMode.STATUS)) {
            this.closedFiles.add(file);
        }
    }

    @Override
    public String inputString(int fileNumber) {
        return this.getFilePart(fileNumber);
    }

    @Override
    public char getChar(int fileNumber) {
        FileWrapper file = this.number2File.get(fileNumber);
        this.checkReadMode(fileNumber, file);
        if (file.getDeviceNumber() == 3) {
            return ' ';
        }
        if (file.getPointer() >= file.getContentAsString().length()) {
            throw new RuntimeException("File length exceeded: " + fileNumber);
        }
        char c = file.getContentAsString().charAt(file.getPointer());
        file.incPointer();
        return c;
    }

    @Override
    public Float inputNumber(int fileNumber) {
        String val = this.getFilePart(fileNumber);
        if (val.length() == 0) {
            val = "0";
        }
        try {
            return Float.valueOf(val);
        }
        catch (Exception e) {
            throw new RuntimeException("Bad data error: " + val);
        }
    }

    @Override
    public void println(int fileNumber, String content) {
        this.print(fileNumber, String.valueOf(content) + "\n");
    }

    @Override
    public void print(int fileNumber, String content) {
        FileWrapper file = this.number2File.get(fileNumber);
        if (file == null) {
            throw new RuntimeException("File not open error: " + fileNumber);
        }
        if (file.getFileMode().equals((Object)FileMode.READ)) {
            throw new RuntimeException("File not open for modifications: " + fileNumber);
        }
        file.print(content);
    }

    @Override
    public void open(int fileNumber) {
        this.open(fileNumber, 1);
    }

    @Override
    public void open(int fileNumber, int device) {
        this.open(fileNumber, device, 0);
    }

    @Override
    public void open(int fileNumber, int device, int secondaryAddress) {
        this.open(fileNumber, device, secondaryAddress, "tmp_" + System.nanoTime());
    }

    @Override
    public boolean isOpen(int fileNumber) {
        return this.number2File.containsKey(fileNumber);
    }

    @Override
    public void open(int fileNumber, int device, int secondaryAddress, String fileName) {
        FileWrapper file = new FileWrapper();
        file.setDeviceNumber(device);
        file.setFileName(fileName);
        file.setFileMode(FileMode.WRITE);
        file.setFileType(FileType.SEQ);
        file.reset();
        if (this.number2File.size() >= 10) {
            throw new RuntimeException("Too many files error!");
        }
        if (this.number2File.containsKey(fileNumber)) {
            throw new RuntimeException("File open error: " + fileNumber);
        }
        if (device < 0 || device > 11) {
            throw new RuntimeException("Device not present error: " + device);
        }
        this.number2File.put(fileNumber, file);
        if (device >= 8 && device <= 11 || device == 1) {
            file.setFileMode(FileMode.READ);
            boolean explicitType = false;
            String[] nameParts = fileName.split(",");
            file.setFileName(nameParts[0]);
            if (nameParts.length > 1) {
                file.setFileType(FileType.getFileType(nameParts[1]));
                explicitType = true;
                if (nameParts.length > 2) {
                    if (!file.getFileType().equals((Object)FileType.REL)) {
                        file.setFileMode(FileMode.getFileMode(nameParts[2]));
                    } else {
                        file.setFileMode(FileMode.WRITE);
                        if (nameParts[2].length() == 0) {
                            file.setRecordLength(0);
                        } else {
                            file.setRecordLength(nameParts[2].charAt(0));
                        }
                    }
                }
            }
            if (secondaryAddress == 0) {
                file.setFileMode(FileMode.READ);
                if (!explicitType) {
                    file.setFileType(FileType.PRG);
                }
            } else if (secondaryAddress == 1) {
                file.setFileMode(FileMode.WRITE);
                if (!explicitType) {
                    file.setFileType(FileType.PRG);
                }
            }
            if (file.getFileMode().equals((Object)FileMode.MODIFY)) {
                for (FileWrapper fw : this.number2File.values()) {
                    if (!fw.getFileName().equals(file.getFileName())) continue;
                    file.setContent(fw.getContent());
                    break;
                }
            }
            if (file.getFileMode().equals((Object)FileMode.READ) || file.getFileMode().equals((Object)FileMode.APPEND)) {
                for (FileWrapper fw : this.closedFiles) {
                    if (!fw.getFileName().equals(file.getFileName())) continue;
                    file.setContent(fw.getContent());
                    break;
                }
            }
            if (file.getFileMode().equals((Object)FileMode.WRITE) || file.getFileMode().equals((Object)FileMode.APPEND)) {
                Iterator<FileWrapper> fitty = this.closedFiles.iterator();
                while (fitty.hasNext()) {
                    FileWrapper fw = fitty.next();
                    if (!fw.getFileName().equals(file.getFileName())) continue;
                    fitty.remove();
                    break;
                }
            }
        } else {
            this.print(fileNumber, fileName);
        }
        if (secondaryAddress == 15) {
            file.setFileMode(FileMode.STATUS);
        }
    }

    @Override
    public void dump(PrintConsumer pc, FileWrapper file, int fileNumber) {
        for (String line : file.getContent()) {
            pc.print(fileNumber, line);
        }
    }

    @Override
    public void save(String fileName, int device, int secondary) {
    }

    @Override
    public void load(CompilerConfig config, String fileName, int device, int secondary) {
    }

    @Override
    public void verify(String fileName, int device, int secondary) {
    }

    @Override
    public void systemPrint(int id, String txt) {
        this.print(id, txt);
    }

    @Override
    public void systemPrintln(int id, String txt) {
        this.println(id, txt);
    }

    private void checkReadMode(int fileNumber, FileWrapper file) {
        if (file == null) {
            throw new RuntimeException("File not open error: " + fileNumber);
        }
        if (!file.getFileMode().equals((Object)FileMode.READ)) {
            throw new RuntimeException("File not open for reading: " + fileNumber);
        }
    }

    private String getFilePart(int fileNumber) {
        FileWrapper file = this.number2File.get(fileNumber);
        this.checkReadMode(fileNumber, file);
        if (file.getDeviceNumber() == 3) {
            return "";
        }
        String data = file.getContentAsString();
        int pos = file.getPosition();
        int cnt = 0;
        StringBuilder part = new StringBuilder();
        String ret = null;
        boolean inString = false;
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            if (c == '\"') {
                boolean bl = inString = !inString;
            }
            if (!(inString || c != '\n' && c != '\r' && c != ',' && c != ';' && c != ':')) {
                if (cnt == pos) {
                    ret = part.toString();
                    break;
                }
                part.setLength(0);
                ++cnt;
            } else {
                part.append(c);
            }
            ++i;
        }
        file.nextPosition();
        return ret;
    }
}

