/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.runner;

import com.sixtyfour.Assembler;
import com.sixtyfour.Basic;
import com.sixtyfour.Loader;
import com.sixtyfour.Logger;
import com.sixtyfour.cbmnative.NativeCompiler;
import com.sixtyfour.cbmnative.PlatformProvider;
import com.sixtyfour.cbmnative.ProgressListener;
import com.sixtyfour.cbmnative.Transformer;
import com.sixtyfour.cbmnative.javascript.PlatformJs;
import com.sixtyfour.cbmnative.mos6502.c64.Platform64;
import com.sixtyfour.cbmnative.mos6502.vic20.Platform20;
import com.sixtyfour.cbmnative.mos6502.x16.PlatformX16;
import com.sixtyfour.cbmnative.powerscript.PlatformPs;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.config.MemoryConfig;
import com.sixtyfour.extensions.x16.X16Extensions;
import com.sixtyfour.parser.Preprocessor;
import com.sixtyfour.parser.cbmnative.UnTokenizer;
import com.sixtyfour.system.FileWriter;
import com.sixtyfour.system.ProgramPart;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class VisualMospeed {
    private JFrame frame;
    private JPanel panel;
    private JButton load;
    private JButton compile;
    private int selectedTarget = 0;
    private JComboBox<String> target;
    private JPanel box;
    private JLabel targetLabel;
    private PlatformProvider platform = null;
    private String appendix = ".prg";
    private File file;
    private String[] code;
    private File lastDir;
    private long fileDate;

    public static void main(String[] args) {
        new VisualMospeed();
    }

    public VisualMospeed() {
        this.setup();
    }

    private void setup() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame = new JFrame("MOSpeed - Visual Compiler");
        this.frame.setLayout(new BorderLayout());
        this.frame.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(1, 2, 15, 15));
        this.load = new JButton();
        this.load.setText("LOAD");
        this.load.setActionCommand("load");
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("load".equals(e.getActionCommand())) {
                    VisualMospeed.this.loadProgram();
                }
            }
        });
        this.compile = new JButton();
        this.compile.setText("COMPILE");
        this.compile.setEnabled(false);
        this.compile.setActionCommand("compile");
        this.compile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("compile".equals(e.getActionCommand())) {
                    VisualMospeed.this.compile();
                }
            }
        });
        this.target = new JComboBox<String>(new String[]{"C64", "VIC20", "X16", "Javascript", "Powershell"});
        this.target.setToolTipText("Select target platform!");
        this.target.addActionListener(e -> {
            this.selectedTarget = this.target.getSelectedIndex();
        });
        this.targetLabel = new JLabel("Select target platform:");
        this.box = new JPanel();
        this.box.setLayout(new BoxLayout(this.box, 3));
        this.box.add(this.targetLabel);
        this.box.add(this.target);
        this.panel.add(this.box);
        this.panel.add(this.load);
        this.panel.add(this.compile);
        this.frame.add(this.panel);
        this.frame.pack();
        this.frame.setSize(640, 80);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    private void compile() {
        if (this.file != null && this.fileDate != 0L && this.file.lastModified() > this.fileDate) {
            Logger.log("File has changed, reloading...");
            this.load(this.file);
        }
        this.compile.setEnabled(false);
        this.load.setEnabled(false);
        this.target.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                VisualMospeed.this.compileInternal();
            }
        }.start();
    }

    private void compileInternal() {
        block16: {
            try {
                JFrame outFrame = new JFrame("MOSpeed - console output");
                outFrame.setLayout(new BorderLayout());
                outFrame.setDefaultCloseOperation(2);
                final PlainDocument doc = new PlainDocument();
                final JTextArea textArea = new JTextArea(40, 80);
                JScrollPane scrollPane = new JScrollPane(textArea);
                outFrame.setPreferredSize(new Dimension(800, 600));
                outFrame.setSize(new Dimension(800, 600));
                outFrame.add((Component)scrollPane, "Center");
                textArea.setDocument(doc);
                outFrame.setVisible(true);
                ByteArrayOutputStream logStream = new ByteArrayOutputStream();
                PrintStream consolePs = new PrintStream(logStream){

                    @Override
                    public void println(String x) {
                        try {
                            doc.insertString(doc.getLength(), String.valueOf(x) + "\n", null);
                            this.scrollDown(textArea);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void print(String x) {
                        try {
                            doc.insertString(doc.getLength(), x, null);
                            this.scrollDown(textArea);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void println() {
                        try {
                            doc.insertString(doc.getLength(), "\n", null);
                            this.scrollDown(textArea);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }

                    private void scrollDown(JTextArea textArea2) {
                        try {
                            textArea2.setCaretPosition(textArea2.getDocument().getLength());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                DotPrintingProgressListener dpl = new DotPrintingProgressListener(consolePs);
                Logger.setPrintStream(consolePs);
                CompilerConfig conf = new CompilerConfig();
                MemoryConfig memConfig = new MemoryConfig();
                this.setPlatform(conf);
                Basic basic = new Basic(this.code);
                try {
                    Logger.log("Checking source file...");
                    basic.compile(conf);
                }
                catch (Exception e) {
                    Logger.log("\n!!! Error compiling BASIC program: " + e.getMessage());
                    this.compile.setEnabled(true);
                    this.load.setEnabled(true);
                    this.target.setEnabled(true);
                    return;
                }
                conf.setProgressListener(dpl);
                List<String> nCode = null;
                NativeCompiler nComp = NativeCompiler.getCompiler();
                try {
                    nCode = nComp.compile(conf, basic, memConfig, this.platform);
                }
                catch (Exception e) {
                    Logger.log("\n!!! Error compiling: " + e.getMessage());
                    Logger.log("Error in line: " + nComp.getLastProcessedLine());
                    this.compile.setEnabled(true);
                    this.load.setEnabled(true);
                    this.target.setEnabled(true);
                    return;
                }
                Assembler assy = null;
                if (this.is6502Platform(this.platform)) {
                    assy = new Assembler(nCode);
                    try {
                        assy.compile(conf);
                    }
                    catch (Exception e) {
                        Logger.log("\n!!! Error running assembler: " + e.getMessage());
                        this.compile.setEnabled(true);
                        this.load.setEnabled(true);
                        this.target.setEnabled(true);
                        return;
                    }
                }
                try {
                    Logger.log("\nREADY!");
                    String targetFile = "++" + this.file.getName().replace(".BAS", "").replace(".bas", "").replace(".prg", "").replace(".PRG", "") + this.appendix;
                    File file = this.saveProgram(targetFile);
                    if (file != null) {
                        this.writeTargetFiles(memConfig, file, nCode, assy, this.platform);
                        break block16;
                    }
                    Logger.log("No file selected, nothing saved!");
                }
                catch (Exception e) {
                    Logger.log(e);
                }
            }
            finally {
                this.compile.setEnabled(true);
                this.load.setEnabled(true);
                this.target.setEnabled(true);
            }
        }
    }

    private void writeTargetFiles(MemoryConfig memConfig, File targetFile, List<String> ncode, Assembler assy, PlatformProvider platform) {
        if (this.is6502Platform(platform)) {
            ProgramPart part0;
            this.write6502(memConfig, targetFile, assy, platform);
            int se = memConfig.getStringEnd();
            if (se <= 0) {
                se = platform.getBasicMemoryEndAddress();
            }
            if (se >= 0 && (part0 = assy.getProgram().getParts().get(0)).getAddress() <= se && part0.getEndAddress() > se) {
                Logger.log("\nWARNING: Compiled program's length exceeds memory limit: " + part0.getEndAddress() + ">" + se);
            }
        } else if (platform instanceof PlatformJs) {
            this.writeJavascript(targetFile, ncode);
        } else if (platform instanceof PlatformPs) {
            this.writePowershell(targetFile, ncode);
        } else {
            Logger.log("\n!!! Unsupported platform: " + platform);
            return;
        }
    }

    private void writePowershell(File targetFile, List<String> ncode) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter pw = new PrintWriter(targetFile);){
                Logger.log("Writing target file: " + targetFile);
                for (String line : ncode) {
                    pw.println(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Logger.log("Failed to write target file '" + targetFile + "': " + e.getMessage());
            return;
        }
    }

    private void writeJavascript(File targetFile, List<String> ncode) {
        Transformer trsn = new PlatformJs().getTransformer();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                PrintWriter pw = new PrintWriter(targetFile);
                try {
                    try (PrintWriter cpw = new PrintWriter(targetFile.getPath().replace(".js", ".html"));){
                        Logger.log("Writing target files: " + targetFile);
                        for (String line : ncode) {
                            pw.println(line);
                        }
                        String[] parts = targetFile.getPath().replace("\\", "/").split("/");
                        for (String line : trsn.createCaller(parts[parts.length - 1])) {
                            cpw.println(line);
                        }
                    }
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (pw != null) {
                        pw.close();
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Logger.log("Failed to write target file '" + targetFile + "': " + e.getMessage());
            return;
        }
    }

    private void write6502(MemoryConfig memConfig, File targetFile, Assembler assy, PlatformProvider platform) {
        try {
            Logger.log("Writing target file: " + targetFile);
            FileWriter.writeAsPrg(assy.getProgram(), targetFile.getPath(), memConfig.getProgramStart() == -1 || memConfig.getProgramStart() < platform.getMaxHeaderAddress() && memConfig.getProgramStart() >= platform.getBaseAddress() + 23, platform.getBaseAddress(), true);
        }
        catch (Exception e) {
            Logger.log("Failed to write target file '" + targetFile + "': " + e.getMessage());
            return;
        }
    }

    private void setPlatform(CompilerConfig conf) {
        switch (this.selectedTarget) {
            case 0: {
                this.platform = new Platform64();
                this.appendix = ".prg";
                break;
            }
            case 1: {
                this.platform = new Platform20();
                this.appendix = ".prg";
                break;
            }
            case 2: {
                this.platform = new PlatformX16();
                Basic.registerExtension(new X16Extensions());
                conf.setNonDecimalNumbersAware(true);
                conf.setConvertStringToLower(true);
                this.appendix = ".prg";
                break;
            }
            case 3: {
                this.platform = new PlatformJs();
                this.appendix = ".js";
                break;
            }
            case 4: {
                this.platform = new PlatformPs();
                this.appendix = ".ps1";
            }
        }
    }

    private boolean is6502Platform(PlatformProvider platform) {
        return platform instanceof Platform64 || platform instanceof Platform20 || platform instanceof PlatformX16;
    }

    private void loadProgram() {
        int ret;
        JFileChooser fc = new JFileChooser();
        if (this.lastDir != null) {
            fc.setCurrentDirectory(this.lastDir);
        }
        if ((ret = fc.showOpenDialog(this.frame)) == 1 || ret == -1) {
            this.compile.setEnabled(this.code != null && this.code.length > 0);
            return;
        }
        this.load(fc.getSelectedFile());
    }

    private void load(File file) {
        this.file = file;
        this.fileDate = file.lastModified();
        String srcFile = file.toString();
        this.code = null;
        if (srcFile.toLowerCase(Locale.ENGLISH).endsWith(".prg")) {
            try {
                Logger.log("Looks like a PRG file, trying to convert it...");
                byte[] data = Loader.loadBlob(srcFile);
                UnTokenizer unto = new UnTokenizer();
                this.code = unto.getText(data, true).toArray(new String[0]);
                Logger.log("PRG file converted into ASCII, proceeding!");
                srcFile = srcFile.replace(".prg", ".bas");
            }
            catch (Exception e) {
                Logger.log("Failed to convert PRG file: " + e.getMessage());
                Logger.log("Proceeding as if it was ASCII instead!");
            }
        }
        if (this.code == null) {
            this.code = Loader.loadProgram(srcFile);
        }
        this.lastDir = file.getParentFile();
        String[] stringArray = this.code;
        if (this.code.length != 0) {
            String line = stringArray[0];
            if (!(line = line.trim()).isEmpty() && !Character.isDigit(line.charAt(0))) {
                this.code = Preprocessor.convertToLineNumbers(this.code);
                JOptionPane.showMessageDialog(this.frame, "Program converted from labels to line numbers!");
            }
        }
        this.compile.setEnabled(true);
        this.frame.setTitle(file.getName());
    }

    private File saveProgram(String targetFile) {
        boolean ok;
        Logger.log("Select file to save!");
        JFileChooser fc = new JFileChooser();
        if (this.lastDir != null) {
            fc.setCurrentDirectory(this.lastDir);
        }
        File f = new File(this.lastDir, targetFile);
        fc.setSelectedFile(f);
        int ret = fc.showSaveDialog(this.frame);
        if (ret == 1 || ret == -1) {
            this.compile.setEnabled(this.code != null && this.code.length > 0);
            return null;
        }
        File file = fc.getSelectedFile();
        if (file.isFile() && !(ok = file.delete())) {
            Logger.log("Failed to delete file: " + file);
        }
        return file;
    }

    private static class DotPrintingProgressListener
    implements ProgressListener {
        private PrintStream ps = null;
        private int cnt = 0;

        public DotPrintingProgressListener(PrintStream ps) {
            this.ps = ps;
        }

        @Override
        public void nextStep() {
            this.ps.print("*");
            ++this.cnt;
            if (this.cnt >= 80) {
                this.cnt = 0;
                this.ps.println();
            }
        }

        @Override
        public void start() {
        }

        @Override
        public void done() {
            this.ps.println();
        }
    }
}

