/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.runner;

import com.sixtyfour.Basic;
import com.sixtyfour.Loader;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.extensions.graphics.GraphicsBasic;
import com.sixtyfour.extensions.textmode.ConsoleSupport;
import com.sixtyfour.parser.Preprocessor;
import com.sixtyfour.plugins.CodeEnhancer;
import com.sixtyfour.plugins.impl.RamSystemCallListener;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class VisualRuntime {
    private JFrame frame;
    private JPanel panel;
    private JButton load;
    private JButton run;
    private JButton pause;
    private Basic basic;
    private String[] code;
    private File lastDir;
    private CompilerConfig config = new CompilerConfig();

    public static void main(String[] args) {
        new VisualRuntime();
    }

    public VisualRuntime() {
        this.setup();
    }

    private void setup() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frame = new JFrame("BASIC V2 - Visual Runtime");
        this.frame.setLayout(new BorderLayout());
        this.frame.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        this.panel.setLayout(new GridLayout(1, 3, 15, 15));
        this.load = new JButton();
        this.load.setText("LOAD");
        this.load.setActionCommand("load");
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("load".equals(e.getActionCommand())) {
                    VisualRuntime.this.terminate();
                    VisualRuntime.this.loadProgram();
                }
            }
        });
        this.run = new JButton();
        this.run.setText("RUN");
        this.run.setEnabled(false);
        this.run.setActionCommand("run");
        this.run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("run".equals(e.getActionCommand())) {
                    if (VisualRuntime.this.basic == null) {
                        VisualRuntime.this.runProgram();
                    } else {
                        VisualRuntime.this.stopProgram();
                    }
                }
            }
        });
        this.pause = new JButton();
        this.pause.setText("RESUME");
        this.pause.setEnabled(false);
        this.pause.setActionCommand("pause");
        this.pause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("pause".equals(e.getActionCommand()) && VisualRuntime.this.basic != null) {
                    VisualRuntime.this.basic.setPause(true);
                    VisualRuntime.this.pause.setActionCommand("resume");
                    VisualRuntime.this.pause.setText("RESUME");
                }
                if ("resume".equals(e.getActionCommand()) && VisualRuntime.this.basic != null) {
                    VisualRuntime.this.basic.setPause(false);
                    VisualRuntime.this.pause.setActionCommand("pause");
                    VisualRuntime.this.pause.setText("PAUSE");
                }
            }
        });
        this.panel.add(this.load);
        this.panel.add(this.run);
        this.panel.add(this.pause);
        this.frame.add(this.panel);
        this.frame.pack();
        this.frame.setSize(480, 80);
        this.frame.setLocationRelativeTo(null);
        this.pause.setText("PAUSE");
        this.frame.setVisible(true);
        Basic.registerExtension(ConsoleSupport.class);
        Basic.registerExtension(GraphicsBasic.class);
    }

    public void stopProgram() {
        if (this.basic != null) {
            this.basic.runStop();
            this.basic = null;
        }
        this.run.setText("RUN");
        this.run.setEnabled(true);
        this.pause.setText("PAUSE");
        this.pause.setEnabled(false);
        this.pause.setActionCommand("pause");
    }

    public void runProgram() {
        this.run.setText("STOP");
        this.pause.setText("PAUSE");
        this.run.setEnabled(true);
        this.pause.setEnabled(true);
        this.pause.setActionCommand("pause");
        new Thread(){

            @Override
            public void run() {
                VisualRuntime.this.basic = new Basic(VisualRuntime.this.code);
                VisualRuntime.this.basic.getMachine().addRoms();
                VisualRuntime.this.basic.setSystemCallListener(new RamSystemCallListener(VisualRuntime.this.basic.getMachine()));
                VisualRuntime.this.basic.setCodeEnhancer(new CodeEnhancer(){

                    @Override
                    public String getFirstCommand() {
                        return "CONSOLE1";
                    }

                    @Override
                    public String getLastCommand() {
                        JOptionPane.showMessageDialog(VisualRuntime.this.frame, "Program terminated, click OK to close console output!");
                        return "CONSOLE0";
                    }
                });
                try {
                    try {
                        VisualRuntime.this.basic.run(VisualRuntime.this.config);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(VisualRuntime.this.frame, "ERROR: " + e.getMessage());
                        VisualRuntime.this.stopProgram();
                    }
                }
                finally {
                    VisualRuntime.this.stopProgram();
                }
            }
        }.start();
    }

    public void terminate() {
        if (this.basic != null) {
            this.basic.runStop();
            this.basic = null;
        }
        this.run.setEnabled(false);
        this.pause.setEnabled(false);
        this.run.setText("RUN");
        this.pause.setText("PAUSE");
        this.pause.setActionCommand("pause");
    }

    public void loadProgram() {
        int ret;
        this.run.setText("RUN");
        JFileChooser fc = new JFileChooser();
        if (this.lastDir != null) {
            fc.setCurrentDirectory(this.lastDir);
        }
        if ((ret = fc.showOpenDialog(this.frame)) == 1 || ret == -1) {
            this.run.setEnabled(this.code != null && this.code.length > 0);
            return;
        }
        File file = fc.getSelectedFile();
        this.code = Loader.loadProgram(file.toString());
        this.lastDir = file.getParentFile();
        String[] stringArray = this.code;
        if (this.code.length != 0) {
            String line = stringArray[0];
            if (!(line = line.trim()).isEmpty() && !Character.isDigit(line.charAt(0))) {
                this.code = Preprocessor.convertToLineNumbers(this.code);
                JOptionPane.showMessageDialog(this.frame, "Program converted from labels to line numbers!");
            }
        }
        this.run.setEnabled(true);
        this.frame.setTitle(file.getName());
    }
}

