/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.system;

import com.sixtyfour.system.Machine;

public class Conversions {
    private static final double ACC_CORRECTOR = 1.0E-11;

    public static int[] compactFloat(int[] number) {
        int[] res = new int[5];
        System.arraycopy(number, 0, res, 0, 5);
        res[1] = res[1] & 0x7F | (number[5] == 0 ? 0 : 128);
        return res;
    }

    public static int[] extractFloat(int[] number) {
        int[] res = new int[6];
        System.arraycopy(number, 0, res, 0, 5);
        res[5] = (res[1] & 0x80) == 0 ? 0 : 255;
        res[1] = res[1] | 0x80;
        return res;
    }

    public static int[] convertFloat(float number) {
        return Conversions.convertDouble(number);
    }

    public static int[] convertDouble(double number) {
        int sign;
        int ei = 0;
        double num = number;
        int[] mem = new int[4];
        if (num == 0.0) {
            return new int[6];
        }
        if (num < 0.0) {
            sign = 128;
            num = -num;
        } else {
            sign = 0;
        }
        double a = 1.0;
        int i = 0;
        while (i < 126) {
            a *= 2.0;
            ++i;
        }
        int beit = 0;
        boolean flag = false;
        int count = 0;
        i = 126;
        while (i >= -128 && beit < 4) {
            int bit;
            if (num + 1.0E-11 >= a) {
                bit = 1;
                if (!flag) {
                    ei = i;
                }
                flag = true;
            } else {
                bit = 0;
            }
            if (flag) {
                mem[beit] = mem[beit] * 2 + bit;
                if (++count > 7) {
                    count = 0;
                    ++beit;
                }
                num -= a * (double)bit;
            }
            a /= 2.0;
            --i;
        }
        mem[0] = mem[0] - 128;
        int[] res = new int[]{129 + ei, mem[0] | 0x80, mem[1], mem[2], mem[3], sign == 0 ? 0 : 255};
        return res;
    }

    public static float convertFloat(Machine machine, int addr) {
        int[] ram = machine.getRam();
        return Conversions.convertFloat(ram[addr] & 0xFF, ram[addr + 5] & 0x80, ram[addr + 4] & 0xFF, ram[addr + 3] & 0xFF, ram[addr + 2] & 0xFF, ram[addr + 1] & 0xFF);
    }

    public static float convertCompactFloat(Machine machine, int addr) {
        int[] ram = machine.getRam();
        int[] res = new int[6];
        System.arraycopy(ram, addr, res, 0, 5);
        res[5] = (res[1] & 0x80) == 0 ? 0 : 255;
        res[1] = res[1] | 0x80;
        return Conversions.convertFloat(res[0] & 0xFF, res[5] & 0xFF, res[4] & 0xFF, res[3] & 0xFF, res[2] & 0xFF, res[1] & 0xFF);
    }

    public static float convertFloat(int exp, int neg, int m1, int m2, int m3, int m4) {
        if (exp == 0) {
            return 0.0f;
        }
        double expf = exp - 128;
        double man = (neg != 0 ? -1.0 : 1.0) * ((double)(m4 | 0x80) * Math.pow(2.0, -8.0) + (double)m3 * Math.pow(2.0, -16.0) + (double)m2 * Math.pow(2.0, -24.0) + (double)m1 * Math.pow(2.0, -32.0));
        return (float)(man * Math.pow(2.0, expf));
    }

    public static double convertDouble(int exp, int neg, int m1, int m2, int m3, int m4) {
        if (exp == 0) {
            return 0.0;
        }
        double expf = exp - 128;
        double man = (neg != 0 ? -1.0 : 1.0) * ((double)(m4 | 0x80) * Math.pow(2.0, -8.0) + (double)m3 * Math.pow(2.0, -16.0) + (double)m2 * Math.pow(2.0, -24.0) + (double)m1 * Math.pow(2.0, -32.0));
        return man * Math.pow(2.0, expf);
    }
}

