/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.system;

import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.mnemonics.Mnemonic;
import com.sixtyfour.elements.mnemonics.MnemonicList;
import com.sixtyfour.plugins.CpuCallListener;
import com.sixtyfour.system.CpuTracer;
import com.sixtyfour.system.Machine;
import com.sixtyfour.system.Program;
import java.util.List;

public class Cpu {
    private static final int STACK = 256;
    private int acc;
    private int x;
    private int y;
    private int status = 48;
    private int stackPointer = 255;
    private boolean exitOnBreak = true;
    private Machine machine;
    private boolean irq = false;
    private boolean nmi = false;
    private boolean brk = false;
    private long ticks = 0L;
    private int pc = 0;
    private int[] ram = null;
    private int tmp = 0;
    private int index = 0;
    private int lo = 0;
    private int hi = 0;
    private int ac = this.status & 1;
    private boolean paused = false;
    private CpuTracer cpuTracer = null;
    private CpuCallListener cpuCallListener = null;

    Cpu(Machine machine) {
        this.machine = machine;
    }

    public CpuTracer getCpuTracer() {
        return this.cpuTracer;
    }

    public void setCpuTracer(CpuTracer cpuTracer) {
        this.cpuTracer = cpuTracer;
    }

    public String getInstruction(CompilerConfig config, int opcode) {
        List<Mnemonic> mnes = MnemonicList.getMnemonics(config);
        for (Mnemonic mne : mnes) {
            String ins = mne.getInstruction(opcode);
            if (ins == null) continue;
            return ins;
        }
        return null;
    }

    public long getClockTicks() {
        return this.ticks;
    }

    public void setClockTicks(long ticks) {
        this.ticks = ticks;
    }

    public synchronized void nmi() {
        this.nmi = true;
    }

    public synchronized void irq() {
        this.irq = true;
    }

    public void stop() {
        this.brk = true;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public int getAcc() {
        return this.acc & 0xFF;
    }

    public void setAcc(int acc) {
        this.acc = acc & 0xFF;
    }

    public int getX() {
        return this.x & 0xFF;
    }

    public void setX(int x) {
        this.x = x & 0xFF;
    }

    public int getY() {
        return this.y & 0xFF;
    }

    public void setY(int y) {
        this.y = y & 0xFF;
    }

    public int getStatus() {
        return this.status & 0xFF;
    }

    public void setStatus(int status) {
        this.status = status & 0xFF;
    }

    public boolean isCarryFlagSet() {
        return (this.status & 1) != 0;
    }

    public boolean isZeroFlagSet() {
        return (this.status & 2) != 0;
    }

    public boolean isInterruptFlagSet() {
        return (this.status & 4) != 0;
    }

    public boolean isDecimalFlagSet() {
        return (this.status & 8) != 0;
    }

    public boolean isBreakFlagSet() {
        return (this.status & 0x10) != 0;
    }

    public boolean isOverflowFlagSet() {
        return (this.status & 0x40) != 0;
    }

    public boolean isNegativeFlagSet() {
        return (this.status & 0x80) != 0;
    }

    public int[] dumpStack() {
        int[] res = new int[255 - this.stackPointer];
        if (res.length == 0) {
            return res;
        }
        System.arraycopy(this.machine.getRam(), 256 + this.stackPointer + 1, res, 0, res.length);
        return res;
    }

    public int getStackPointer() {
        return this.stackPointer;
    }

    public void setStackPointer(int stackPointer) {
        this.stackPointer = stackPointer;
    }

    public boolean isExitOnBreak() {
        return this.exitOnBreak;
    }

    public void setExitOnBreak(boolean exitOnBreak) {
        this.exitOnBreak = exitOnBreak;
    }

    public void reset() {
        this.acc = 0;
        this.x = 0;
        this.y = 0;
        this.status = 48;
        this.stackPointer = 255;
        this.irq = false;
        this.nmi = false;
        this.brk = false;
        this.paused = false;
    }

    public void execute(Program prg) {
        this.machine.putProgram(prg);
        this.execute(prg.getCodeStart());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(int startAddress) {
        this.pc = startAddress;
        this.ram = this.machine.getRam();
        this.brk = false;
        this.push(this.ram, 0);
        this.push(this.ram, 0);
        do {
            boolean decimal;
            int lastPc = this.pc;
            int cmd = this.ram[this.pc++];
            int xb = this.x & 0xFF;
            int yb = this.y & 0xFF;
            int accb = this.acc & 0xFF;
            while (this.paused) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean bl = decimal = (this.status & 8) != 0;
            if (this.irq && !this.isInterruptFlagSet()) {
                Cpu cpu = this;
                synchronized (cpu) {
                    this.push(this.ram, this.getHigh(this.pc));
                    this.push(this.ram, this.getLow(this.pc));
                    this.push(this.ram, this.status & 0xEF);
                    this.pc = this.getWord(this.ram[65534], this.ram[65535]);
                    this.irq = false;
                }
            }
            if (this.nmi) {
                Cpu cpu = this;
                synchronized (cpu) {
                    this.push(this.ram, this.getHigh(this.pc));
                    this.push(this.ram, this.getLow(this.pc));
                    this.push(this.ram, this.status & 0xEF);
                    this.pc = this.getWord(this.ram[65530], this.ram[65531]);
                    this.nmi = false;
                }
            }
            switch (cmd) {
                case 96: {
                    int addr = this.getWord(this.pop(this.ram), this.pop(this.ram));
                    if (addr == 0) {
                        this.brk = true;
                    } else {
                        this.pc = ++addr;
                    }
                    this.ticks += 6L;
                    break;
                }
                case 0: {
                    this.brk();
                    break;
                }
                case 169: {
                    this.lda_nn();
                    break;
                }
                case 173: {
                    this.lda_hhll();
                    break;
                }
                case 189: {
                    this.lda_hhll(xb);
                    break;
                }
                case 185: {
                    this.lda_hhll(yb);
                    break;
                }
                case 165: {
                    this.lda_ll();
                    break;
                }
                case 181: {
                    this.lda_llx(xb);
                    break;
                }
                case 161: {
                    this.lda_ll_x();
                    break;
                }
                case 177: {
                    this.lda_lly(yb);
                    break;
                }
                case 162: {
                    this.ldx_nn();
                    break;
                }
                case 174: {
                    this.ldx_hhll();
                    break;
                }
                case 190: {
                    this.ldx_hhllx(yb);
                    break;
                }
                case 166: {
                    this.ldx_ll();
                    break;
                }
                case 182: {
                    this.ldx_lly(yb);
                    break;
                }
                case 160: {
                    this.ldy_nn();
                    break;
                }
                case 172: {
                    this.ldy_hhll();
                    break;
                }
                case 188: {
                    this.ldy_hhllx(xb);
                    break;
                }
                case 164: {
                    this.ldy_ll();
                    break;
                }
                case 180: {
                    this.ldy_llx(xb);
                    break;
                }
                case 141: {
                    this.sta_hhll(accb);
                    break;
                }
                case 157: {
                    this.sta_hhllx(xb, accb);
                    break;
                }
                case 153: {
                    this.sta_hhllx(yb, accb);
                    break;
                }
                case 133: {
                    this.sta_ll(accb);
                    break;
                }
                case 149: {
                    this.sta_llx(xb, accb);
                    break;
                }
                case 129: {
                    this.sta_ll_x(accb);
                    break;
                }
                case 145: {
                    this.sta_lly(accb);
                    break;
                }
                case 142: {
                    this.sta_hhll(xb);
                    break;
                }
                case 134: {
                    this.sta_ll(xb);
                    break;
                }
                case 150: {
                    this.sta_llx(yb, xb);
                    break;
                }
                case 140: {
                    this.sta_hhll(yb);
                    break;
                }
                case 132: {
                    this.sta_ll(yb);
                    break;
                }
                case 148: {
                    this.sta_llx(xb, yb);
                    break;
                }
                case 170: {
                    this.tax(accb);
                    break;
                }
                case 168: {
                    this.tay(accb);
                    break;
                }
                case 138: {
                    this.txa(xb);
                    break;
                }
                case 152: {
                    this.txa(yb);
                    break;
                }
                case 186: {
                    this.tsx();
                    break;
                }
                case 154: {
                    this.txs(xb);
                    break;
                }
                case 41: {
                    this.and_nn();
                    break;
                }
                case 45: {
                    this.and_hhll();
                    break;
                }
                case 61: {
                    this.and_hhllx(xb);
                    break;
                }
                case 57: {
                    this.and_hhllx(yb);
                    break;
                }
                case 37: {
                    this.and_ll();
                    break;
                }
                case 53: {
                    this.and_llx(xb);
                    break;
                }
                case 33: {
                    this.and_ll_x();
                    break;
                }
                case 49: {
                    this.and_lly(yb);
                    break;
                }
                case 9: {
                    this.or_nn();
                    break;
                }
                case 13: {
                    this.or_hhll();
                    break;
                }
                case 29: {
                    this.or_hhllx(xb);
                    break;
                }
                case 25: {
                    this.or_hhllx(yb);
                    break;
                }
                case 5: {
                    this.or_ll();
                    break;
                }
                case 21: {
                    this.or_llx(xb);
                    break;
                }
                case 1: {
                    this.or_ll_x();
                    break;
                }
                case 17: {
                    this.or_lly(yb);
                    break;
                }
                case 73: {
                    this.eor_nn();
                    break;
                }
                case 77: {
                    this.eor_hhll();
                    break;
                }
                case 93: {
                    this.eor_hhllx(xb);
                    break;
                }
                case 89: {
                    this.eor_hhllx(yb);
                    break;
                }
                case 69: {
                    this.eor_ll();
                    break;
                }
                case 85: {
                    this.eor_llx(xb);
                    break;
                }
                case 65: {
                    this.eor_ll_x();
                    break;
                }
                case 81: {
                    this.eor_lly(yb);
                    break;
                }
                case 105: {
                    this.adc_nn(accb, decimal);
                    break;
                }
                case 109: {
                    this.adc_hhll(accb, decimal);
                    break;
                }
                case 125: {
                    this.adc_hhllx(xb, accb, decimal);
                    break;
                }
                case 121: {
                    this.adc_hhllx(yb, accb, decimal);
                    break;
                }
                case 101: {
                    this.adc_ll(accb, decimal);
                    break;
                }
                case 117: {
                    this.adc_llx(xb, accb, decimal);
                    break;
                }
                case 97: {
                    this.adc_ll_x(accb, decimal);
                    break;
                }
                case 113: {
                    this.adc_lly(yb, accb, decimal);
                    break;
                }
                case 233: {
                    this.sbc_nn(accb, decimal);
                    break;
                }
                case 237: {
                    this.sbc_hhll(accb, decimal);
                    break;
                }
                case 253: {
                    this.sbc_hhllx(xb, accb, decimal);
                    break;
                }
                case 249: {
                    this.sbc_hhllx(yb, accb, decimal);
                    break;
                }
                case 229: {
                    this.sbc_ll(accb, decimal);
                    break;
                }
                case 245: {
                    this.sbc_llx(xb, accb, decimal);
                    break;
                }
                case 225: {
                    this.sbc_ll_x(accb, decimal);
                    break;
                }
                case 241: {
                    this.sbc_lly(yb, accb, decimal);
                    break;
                }
                case 238: {
                    this.inc_hhll();
                    break;
                }
                case 254: {
                    this.inc_hhllx(xb);
                    break;
                }
                case 230: {
                    this.inc_ll();
                    break;
                }
                case 246: {
                    this.inc_llx(xb);
                    break;
                }
                case 206: {
                    this.dec_hhll();
                    break;
                }
                case 222: {
                    this.dec_hhllx(xb);
                    break;
                }
                case 198: {
                    this.dec_ll();
                    break;
                }
                case 214: {
                    this.dec_llx(xb);
                    break;
                }
                case 232: {
                    this.inx(xb);
                    break;
                }
                case 200: {
                    this.iny(yb);
                    break;
                }
                case 202: {
                    this.dex(xb);
                    break;
                }
                case 136: {
                    this.dey(yb);
                    break;
                }
                case 10: {
                    this.asl_(accb);
                    break;
                }
                case 14: {
                    this.asl_hhll();
                    break;
                }
                case 30: {
                    this.asl_hhllx(xb);
                    break;
                }
                case 6: {
                    this.asl_ll();
                    break;
                }
                case 22: {
                    this.asl_llx(xb);
                    break;
                }
                case 74: {
                    this.lsr_(accb);
                    break;
                }
                case 78: {
                    this.lsr_hhll();
                    break;
                }
                case 94: {
                    this.lsr_hhllx(xb);
                    break;
                }
                case 70: {
                    this.lsr_ll();
                    break;
                }
                case 86: {
                    this.lsr_llx(xb);
                    break;
                }
                case 42: {
                    this.rol_(accb);
                    break;
                }
                case 46: {
                    this.rol_hhll();
                    break;
                }
                case 62: {
                    this.rol_hhllx(xb);
                    break;
                }
                case 38: {
                    this.rol_ll();
                    break;
                }
                case 54: {
                    this.rol_llx(xb);
                    break;
                }
                case 106: {
                    this.ror_(accb);
                    break;
                }
                case 110: {
                    this.ror_hhll();
                    break;
                }
                case 126: {
                    this.ror_hhllx(xb);
                    break;
                }
                case 102: {
                    this.ror_ll();
                    break;
                }
                case 118: {
                    this.ror_llx(xb);
                    break;
                }
                case 201: {
                    this.cmp_nn(accb);
                    break;
                }
                case 205: {
                    this.cmp_hhll(accb);
                    break;
                }
                case 221: {
                    this.cmp_hhllx(xb, accb);
                    break;
                }
                case 217: {
                    this.cmp_hhllx(yb, accb);
                    break;
                }
                case 197: {
                    this.cmp_ll(accb);
                    break;
                }
                case 213: {
                    this.cmp_llx(xb, accb);
                    break;
                }
                case 193: {
                    this.cmp_llx(accb);
                    break;
                }
                case 209: {
                    this.cmp_lly(yb, accb);
                    break;
                }
                case 224: {
                    this.cmp_nn(xb);
                    break;
                }
                case 236: {
                    this.cmp_hhll(xb);
                    break;
                }
                case 228: {
                    this.cmp_ll(xb);
                    break;
                }
                case 192: {
                    this.cmp_nn(yb);
                    break;
                }
                case 204: {
                    this.cmp_hhll(yb);
                    break;
                }
                case 196: {
                    this.cmp_ll(yb);
                    break;
                }
                case 44: {
                    this.bit_hhll(accb);
                    break;
                }
                case 36: {
                    this.bit_ll(accb);
                    break;
                }
                case 76: {
                    this.jmp_hhll();
                    break;
                }
                case 108: {
                    this.jmp_hhll_();
                    break;
                }
                case 32: {
                    this.jsr_hhll();
                    break;
                }
                case 64: {
                    this.rti();
                    break;
                }
                case 144: {
                    this.bcc_hhll();
                    break;
                }
                case 176: {
                    this.bcs_hhll();
                    break;
                }
                case 240: {
                    this.beq_hhll();
                    break;
                }
                case 208: {
                    this.bne_hhll();
                    break;
                }
                case 16: {
                    this.bpl_hhll();
                    break;
                }
                case 48: {
                    this.bmi_hhll();
                    break;
                }
                case 80: {
                    this.bvc_hhll();
                    break;
                }
                case 112: {
                    this.bvs_hhll();
                    break;
                }
                case 56: {
                    this.sec();
                    break;
                }
                case 24: {
                    this.clc();
                    break;
                }
                case 120: {
                    this.sei();
                    break;
                }
                case 88: {
                    this.cli();
                    break;
                }
                case 184: {
                    this.clv();
                    break;
                }
                case 248: {
                    this.sed();
                    break;
                }
                case 216: {
                    this.cld();
                    break;
                }
                case 72: {
                    this.pha(accb);
                    break;
                }
                case 8: {
                    this.php();
                    break;
                }
                case 104: {
                    this.pla();
                    break;
                }
                case 40: {
                    this.plp();
                    break;
                }
                case 234: {
                    this.ticks += 2L;
                    break;
                }
                default: {
                    if (this.cpuTracer != null) {
                        this.cpuTracer.exception(this, cmd, lastPc, this.pc);
                    }
                    throw new RuntimeException(String.valueOf(this.pc) + ": Illegal opcode @:" + Integer.toHexString(lastPc) + "/" + Integer.toHexString(this.pc) + " $" + Integer.toHexString(cmd));
                }
            }
            if (this.cpuTracer == null) continue;
            this.cpuTracer.commandExecuted(this, cmd, lastPc, this.pc);
        } while (!this.brk);
    }

    private void plp() {
        this.status = this.pop(this.ram);
        this.ticks += 3L;
    }

    private void pla() {
        this.acc = this.pop(this.ram);
        this.setFlags(this.acc, true, true);
        this.ticks += 3L;
    }

    private void php() {
        this.push(this.ram, this.status);
        this.ticks += 3L;
    }

    private void pha(int accb) {
        this.push(this.ram, accb);
        this.ticks += 3L;
    }

    private void cld() {
        this.status &= 0xF7;
        this.ticks += 2L;
    }

    private void sed() {
        this.status |= 8;
        this.ticks += 2L;
    }

    private void clv() {
        this.status &= 0xBF;
        this.ticks += 2L;
    }

    private void cli() {
        this.status &= 0xFB;
        this.ticks += 2L;
    }

    private void sei() {
        this.status |= 4;
        this.ticks += 2L;
    }

    private void clc() {
        this.status &= 0xFE;
        this.ticks += 2L;
    }

    private void sec() {
        this.status |= 1;
        this.ticks += 2L;
    }

    private void bvs_hhll() {
        this.ticks += 2L;
        if ((this.status & 0x40) != 0) {
            this.tmp = this.pc;
            this.pc += (byte)(this.ram[this.pc] & 0xFF) + 1;
            ++this.ticks;
            if (this.tmp >> 8 != this.pc >> 8) {
                ++this.ticks;
            }
        } else {
            ++this.pc;
        }
    }

    private void bvc_hhll() {
        this.ticks += 2L;
        if ((this.status & 0x40) == 0) {
            this.tmp = this.pc;
            this.pc += (byte)(this.ram[this.pc] & 0xFF) + 1;
            ++this.ticks;
            if (this.tmp >> 8 != this.pc >> 8) {
                ++this.ticks;
            }
        } else {
            ++this.pc;
        }
    }

    private void bmi_hhll() {
        this.ticks += 2L;
        if ((this.status & 0x80) != 0) {
            this.tmp = this.pc;
            this.pc += (byte)(this.ram[this.pc] & 0xFF) + 1;
            ++this.ticks;
            if (this.tmp >> 8 != this.pc >> 8) {
                ++this.ticks;
            }
        } else {
            ++this.pc;
        }
    }

    private void bpl_hhll() {
        this.ticks += 2L;
        if ((this.status & 0x80) == 0) {
            this.tmp = this.pc;
            this.pc += (byte)(this.ram[this.pc] & 0xFF) + 1;
            ++this.ticks;
            if (this.tmp >> 8 != this.pc >> 8) {
                ++this.ticks;
            }
        } else {
            ++this.pc;
        }
    }

    private void bne_hhll() {
        this.ticks += 2L;
        if ((this.status & 2) == 0) {
            this.tmp = this.pc;
            this.pc += (byte)(this.ram[this.pc] & 0xFF) + 1;
            ++this.ticks;
            if (this.tmp >> 8 != this.pc >> 8) {
                ++this.ticks;
            }
        } else {
            ++this.pc;
        }
    }

    private void beq_hhll() {
        this.ticks += 2L;
        if ((this.status & 2) != 0) {
            this.tmp = this.pc;
            this.pc += (byte)(this.ram[this.pc] & 0xFF) + 1;
            ++this.ticks;
            if (this.tmp >> 8 != this.pc >> 8) {
                ++this.ticks;
            }
        } else {
            ++this.pc;
        }
    }

    private void bcs_hhll() {
        this.ticks += 2L;
        if ((this.status & 1) != 0) {
            this.tmp = this.pc;
            this.pc += (byte)(this.ram[this.pc] & 0xFF) + 1;
            ++this.ticks;
            if (this.tmp >> 8 != this.pc >> 8) {
                ++this.ticks;
            }
        } else {
            ++this.pc;
        }
    }

    private void bcc_hhll() {
        this.ticks += 2L;
        if ((this.status & 1) == 0) {
            this.tmp = this.pc;
            this.pc += (byte)(this.ram[this.pc] & 0xFF) + 1;
            ++this.ticks;
            if (this.tmp >> 8 != this.pc >> 8) {
                ++this.ticks;
            }
        } else {
            ++this.pc;
        }
    }

    private void rti() {
        this.status = this.pop(this.ram);
        this.pc = this.getWord(this.pop(this.ram), this.pop(this.ram));
        this.ticks += 6L;
    }

    private void jsr_hhll() {
        this.tmp = this.getWord(this.ram[this.pc], this.ram[++this.pc]);
        if (this.cpuCallListener == null || !this.cpuCallListener.jsr(this, this.tmp)) {
            this.push(this.ram, this.getHigh(this.pc));
            this.push(this.ram, this.getLow(this.pc));
            this.pc = this.tmp;
        } else {
            ++this.pc;
        }
        this.ticks += 6L;
    }

    private void jmp_hhll_() {
        this.lo = this.ram[this.pc++];
        this.hi = this.ram[this.pc];
        this.tmp = this.ram[this.getWord(this.lo, this.hi)];
        this.lo = this.lo + 1 & 0xFF;
        this.pc = this.getWord(this.tmp, this.ram[this.getWord(this.lo, this.hi)]);
        this.ticks += 5L;
    }

    private void jmp_hhll() {
        this.pc = this.getWord(this.ram[this.pc++], this.ram[this.pc]);
        this.ticks += 3L;
    }

    private void bit_ll(int accb) {
        this.tmp = this.ram[this.ram[this.pc++] & 0xFF] & 0xFF;
        this.status = this.status & 0x3F | this.tmp & 0xC0;
        this.tmp &= accb;
        this.setFlags(this.tmp, false, true);
        this.ticks += 3L;
    }

    private void bit_hhll(int accb) {
        this.tmp = this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])] & 0xFF;
        this.status = this.status & 0x3F | this.tmp & 0xC0;
        this.tmp &= accb;
        this.setFlags(this.tmp, false, true);
        this.ticks += 4L;
    }

    private void cmp_hhll(int val) {
        this.tmp = val - this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])];
        this.setFlags(this.tmp, val, true, true, false, true, false);
        this.ticks += 4L;
    }

    private void cmp_lly(int yb, int accb) {
        this.index = this.getWord(this.ram[this.ram[this.pc]], this.ram[this.ram[this.pc++] + 1 & 0xFF]);
        this.tmp = accb - this.ram[this.index + yb & 0xFFFF];
        this.setFlags(this.tmp, accb, true, true, false, true, false);
        this.ticks += 5L;
        if (this.index >> 8 != this.index + yb >> 8) {
            ++this.ticks;
        }
    }

    private void cmp_llx(int accb) {
        this.tmp = accb - this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])];
        this.setFlags(this.tmp, accb, true, true, false, true, false);
        this.ticks += 6L;
    }

    private void cmp_llx(int xb, int accb) {
        this.tmp = accb - this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF];
        this.setFlags(this.tmp, accb, true, true, false, true, false);
        this.ticks += 4L;
    }

    private void cmp_ll(int accb) {
        this.tmp = accb - this.ram[this.ram[this.pc++] & 0xFF];
        this.setFlags(this.tmp, accb, true, true, false, true, false);
        this.ticks += 3L;
    }

    private void cmp_hhllx(int xb, int accb) {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.tmp = accb - this.ram[this.index + xb & 0xFFFF];
        this.setFlags(this.tmp, accb, true, true, false, true, false);
        this.ticks += 4L;
        if (this.index >> 8 != this.index + xb >> 8) {
            ++this.ticks;
        }
    }

    private void cmp_nn(int accb) {
        this.tmp = accb - this.ram[this.pc++];
        this.setFlags(this.tmp, accb, true, true, false, true, false);
        this.ticks += 2L;
    }

    private void ror_llx(int xb) {
        this.index = (this.ram[this.pc++] & 0xFF) + xb & 0xFF;
        this.ram[this.index] = this.ror(this.ram[this.index]);
        this.ticks += 6L;
    }

    private void ror_ll() {
        this.index = this.ram[this.pc++] & 0xFF;
        this.ram[this.index] = this.ror(this.ram[this.index]);
        this.ticks += 5L;
    }

    private void ror_hhllx(int xb) {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]) + xb;
        this.ram[this.index] = this.ror(this.ram[this.index & 0xFFFF]);
        this.ticks += 7L;
    }

    private void ror_hhll() {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.ram[this.index] = this.ror(this.ram[this.index]);
        this.ticks += 6L;
    }

    private void ror_(int accb) {
        this.acc = this.ror(accb);
        this.ticks += 2L;
    }

    private void rol_llx(int xb) {
        this.index = (this.ram[this.pc++] & 0xFF) + xb & 0xFF;
        this.ram[this.index] = this.rol(this.ram[this.index]);
        this.ticks += 6L;
    }

    private void rol_ll() {
        this.index = this.ram[this.pc++] & 0xFF;
        this.ram[this.index] = this.rol(this.ram[this.index]);
        this.ticks += 5L;
    }

    private void rol_hhllx(int xb) {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]) + xb;
        this.ram[this.index] = this.rol(this.ram[this.index & 0xFFFF]);
        this.ticks += 7L;
    }

    private void rol_hhll() {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.ram[this.index] = this.rol(this.ram[this.index]);
        this.ticks += 6L;
    }

    private void rol_(int accb) {
        this.acc = this.rol(accb);
        this.ticks += 2L;
    }

    private void lsr_llx(int xb) {
        this.index = (this.ram[this.pc++] & 0xFF) + xb & 0xFF;
        this.ram[this.index] = this.lsr(this.ram[this.index]);
        this.ticks += 6L;
    }

    private void lsr_ll() {
        this.index = this.ram[this.pc++] & 0xFF;
        this.ram[this.index] = this.lsr(this.ram[this.index]);
        this.ticks += 5L;
    }

    private void lsr_hhllx(int xb) {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]) + xb;
        this.ram[this.index] = this.lsr(this.ram[this.index & 0xFFFF]);
        this.ticks += 7L;
    }

    private void lsr_hhll() {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.ram[this.index] = this.lsr(this.ram[this.index]);
        this.ticks += 6L;
    }

    private void lsr_(int accb) {
        this.acc = this.lsr(accb);
        this.ticks += 2L;
    }

    private void asl_llx(int xb) {
        this.index = (this.ram[this.pc++] & 0xFF) + xb & 0xFF;
        this.ram[this.index] = this.asl(this.ram[this.index]);
        this.ticks += 6L;
    }

    private void asl_ll() {
        this.index = this.ram[this.pc++] & 0xFF;
        this.ram[this.index] = this.asl(this.ram[this.index]);
        this.ticks += 5L;
    }

    private void asl_hhllx(int xb) {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]) + xb;
        this.ram[this.index] = this.asl(this.ram[this.index & 0xFFFF]);
        this.ticks += 7L;
    }

    private void asl_hhll() {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.ram[this.index] = this.asl(this.ram[this.index]);
        this.ticks += 6L;
    }

    private void asl_(int accb) {
        this.acc = this.asl(accb);
        this.ticks += 2L;
    }

    private void dey(int yb) {
        this.y = yb - 1 & 0xFF;
        this.setFlags(this.y, true, true);
        this.ticks += 2L;
    }

    private void dex(int xb) {
        this.x = xb - 1 & 0xFF;
        this.setFlags(this.x, true, true);
        this.ticks += 2L;
    }

    private void iny(int yb) {
        this.y = yb + 1 & 0xFF;
        this.setFlags(this.y, true, true);
        this.ticks += 2L;
    }

    private void inx(int xb) {
        this.x = xb + 1 & 0xFF;
        this.setFlags(this.x, true, true);
        this.ticks += 2L;
    }

    private void dec_llx(int xb) {
        this.index = (this.ram[this.pc++] & 0xFF) + xb & 0xFF;
        this.ram[this.index] = this.ram[this.index] - 1 & 0xFF;
        this.setFlags(this.ram[this.index], true, true);
        this.ticks += 6L;
    }

    private void dec_ll() {
        this.index = this.ram[this.pc++] & 0xFF;
        this.ram[this.index] = this.ram[this.index] - 1 & 0xFF;
        this.setFlags(this.ram[this.index], true, true);
        this.ticks += 5L;
    }

    private void dec_hhllx(int xb) {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]) + xb & 0xFFFF;
        this.ram[this.index] = this.ram[this.index] - 1 & 0xFF;
        this.setFlags(this.ram[this.index], true, true);
        this.ticks += 7L;
    }

    private void dec_hhll() {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.ram[this.index] = this.ram[this.index] - 1 & 0xFF;
        this.setFlags(this.ram[this.index], true, true);
        this.ticks += 6L;
    }

    private void inc_llx(int xb) {
        this.index = (this.ram[this.pc++] & 0xFF) + xb & 0xFF;
        this.ram[this.index] = this.ram[this.index] + 1 & 0xFF;
        this.setFlags(this.ram[this.index], true, true);
        this.ticks += 6L;
    }

    private void inc_ll() {
        this.index = this.ram[this.pc++] & 0xFF;
        this.ram[this.index] = this.ram[this.index] + 1 & 0xFF;
        this.setFlags(this.ram[this.index], true, true);
        this.ticks += 5L;
    }

    private void inc_hhllx(int xb) {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]) + xb & 0xFFFF;
        this.ram[this.index] = this.ram[this.index] + 1 & 0xFF;
        this.setFlags(this.ram[this.index], true, true);
        this.ticks += 7L;
    }

    private void inc_hhll() {
        this.index = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.ram[this.index] = this.ram[this.index] + 1 & 0xFF;
        this.setFlags(this.ram[this.index], true, true);
        this.ticks += 6L;
    }

    private void sbc_lly(int yb, int accb, boolean decimal) {
        this.ac = ~(this.status & 1) & 1;
        this.tmp = this.getWord(this.ram[this.ram[this.pc]], this.ram[this.ram[this.pc++] + 1 & 0xFF]);
        this.acc = !decimal ? (this.acc -= this.ram[this.tmp + yb] + this.ac) : this.subBCD(this.subBCD(accb, this.ac), this.ram[this.tmp + yb]);
        this.setFlags(this.acc, accb, true, true, true, true, false);
        this.acc &= 0xFF;
        this.ticks += 5L;
        if (this.tmp >> 8 != this.tmp + yb >> 8) {
            ++this.ticks;
        }
    }

    private void sbc_ll_x(int accb, boolean decimal) {
        this.ac = ~(this.status & 1) & 1;
        this.acc = !decimal ? (this.acc -= this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])] + this.ac) : this.subBCD(this.subBCD(accb, this.ac), this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])]);
        this.setFlags(this.acc, accb, true, true, true, true, false);
        this.acc &= 0xFF;
        this.ticks += 6L;
    }

    private void sbc_llx(int xb, int accb, boolean decimal) {
        this.ac = ~(this.status & 1) & 1;
        this.acc = !decimal ? (this.acc -= this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF] + this.ac) : this.subBCD(this.subBCD(accb, this.ac), this.ram[(this.ram[this.pc++] & 0xFF) + xb]);
        this.setFlags(this.acc, accb, true, true, true, true, false);
        this.acc &= 0xFF;
        this.ticks += 4L;
    }

    private void sbc_ll(int accb, boolean decimal) {
        this.ac = ~(this.status & 1) & 1;
        this.acc = !decimal ? (this.acc -= this.ram[this.ram[this.pc++] & 0xFF] + this.ac) : this.subBCD(this.subBCD(accb, this.ac), this.ram[this.ram[this.pc++] & 0xFF]);
        this.setFlags(this.acc, accb, true, true, true, true, false);
        this.acc &= 0xFF;
        this.ticks += 3L;
    }

    private void sbc_hhllx(int xb, int accb, boolean decimal) {
        this.ac = ~(this.status & 1) & 1;
        this.tmp = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.acc = !decimal ? (this.acc -= this.ram[this.tmp + xb & 0xFFFF] + this.ac) : this.subBCD(this.subBCD(accb, this.ac), this.ram[this.tmp + xb & 0xFFFF]);
        this.setFlags(this.acc, accb, true, true, true, true, false);
        this.acc &= 0xFF;
        this.ticks += 4L;
        if (this.tmp >> 8 != this.tmp + xb >> 8) {
            ++this.ticks;
        }
    }

    private void sbc_hhll(int accb, boolean decimal) {
        this.ac = ~(this.status & 1) & 1;
        this.acc = !decimal ? (this.acc -= this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])] + this.ac) : this.subBCD(this.subBCD(accb, this.ac), this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])]);
        this.setFlags(this.acc, accb, true, true, true, true, false);
        this.acc &= 0xFF;
        this.ticks += 4L;
    }

    private void sbc_nn(int accb, boolean decimal) {
        this.ac = ~(this.status & 1) & 1;
        this.acc = !decimal ? (this.acc -= this.ram[this.pc++] + this.ac) : this.subBCD(this.subBCD(accb, this.ac), this.ram[this.pc++]);
        this.setFlags(this.acc, accb, true, true, true, true, false);
        this.acc &= 0xFF;
        this.ticks += 2L;
    }

    private void adc_lly(int yb, int accb, boolean decimal) {
        this.ac = this.status & 1;
        this.tmp = this.getWord(this.ram[this.ram[this.pc]], this.ram[this.ram[this.pc++] + 1 & 0xFF]);
        this.acc = !decimal ? (this.acc += this.ram[this.tmp + yb] + this.ac) : this.addBCD(this.addBCD(accb, this.ac), this.ram[this.tmp + yb]);
        this.setFlags(this.acc, accb, true, true, true, true, true);
        this.acc &= 0xFF;
        this.ticks += 5L;
        if (this.tmp >> 8 != this.tmp + yb >> 8) {
            ++this.ticks;
        }
    }

    private void adc_ll_x(int accb, boolean decimal) {
        this.ac = this.status & 1;
        this.acc = !decimal ? (this.acc += this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])] + this.ac) : this.addBCD(this.addBCD(accb, this.ac), this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])]);
        this.setFlags(this.acc, accb, true, true, true, true, true);
        this.acc &= 0xFF;
        this.ticks += 6L;
    }

    private void adc_llx(int xb, int accb, boolean decimal) {
        this.ac = this.status & 1;
        this.acc = !decimal ? (this.acc += this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF] + this.ac) : this.addBCD(this.addBCD(accb, this.ac), this.ram[(this.ram[this.pc++] & 0xFF) + xb]);
        this.setFlags(this.acc, accb, true, true, true, true, true);
        this.acc &= 0xFF;
        this.ticks += 4L;
    }

    private void adc_ll(int accb, boolean decimal) {
        this.ac = this.status & 1;
        this.acc = !decimal ? (this.acc += this.ram[this.ram[this.pc++] & 0xFF] + this.ac) : this.addBCD(this.addBCD(accb, this.ac), this.ram[this.ram[this.pc++] & 0xFF]);
        this.setFlags(this.acc, accb, true, true, true, true, true);
        this.acc &= 0xFF;
        this.ticks += 3L;
    }

    private void adc_hhllx(int xb, int accb, boolean decimal) {
        this.ac = this.status & 1;
        this.tmp = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.acc = !decimal ? (this.acc += this.ram[this.tmp + xb & 0xFFFF] + this.ac) : this.addBCD(this.addBCD(accb, this.ac), this.ram[this.tmp + xb & 0xFFFF]);
        this.setFlags(this.acc, accb, true, true, true, true, true);
        this.acc &= 0xFF;
        this.ticks += 4L;
        if (this.tmp >> 8 != this.tmp + xb >> 8) {
            ++this.ticks;
        }
    }

    private void adc_hhll(int accb, boolean decimal) {
        this.ac = this.status & 1;
        this.acc = !decimal ? (this.acc += this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])] + this.ac) : this.addBCD(this.addBCD(accb, this.ac), this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])]);
        this.setFlags(this.acc, accb, true, true, true, true, true);
        this.acc &= 0xFF;
        this.ticks += 4L;
    }

    private void adc_nn(int accb, boolean decimal) {
        this.ac = this.status & 1;
        this.acc = !decimal ? (this.acc += this.ram[this.pc++] + this.ac) : this.addBCD(this.addBCD(accb, this.ac), this.ram[this.pc++]);
        this.setFlags(this.acc, accb, true, true, true, true, true);
        this.acc &= 0xFF;
        this.ticks += 2L;
    }

    private void eor_lly(int yb) {
        this.tmp = this.getWord(this.ram[this.ram[this.pc]], this.ram[this.ram[this.pc++] + 1 & 0xFF]);
        this.acc ^= this.ram[this.tmp + yb];
        this.setFlags(this.acc, true, true);
        this.ticks += 5L;
        if (this.tmp >> 8 != this.tmp + yb >> 8) {
            ++this.ticks;
        }
    }

    private void eor_ll_x() {
        this.acc ^= this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])];
        this.setFlags(this.acc, true, true);
        this.ticks += 6L;
    }

    private void eor_llx(int xb) {
        this.acc ^= this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
    }

    private void eor_ll() {
        this.acc ^= this.ram[this.ram[this.pc++] & 0xFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 3L;
    }

    private void eor_hhllx(int xb) {
        this.tmp = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.acc ^= this.ram[this.tmp + xb & 0xFFFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
        if (this.tmp >> 8 != this.tmp + xb >> 8) {
            ++this.ticks;
        }
    }

    private void eor_hhll() {
        this.acc ^= this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
    }

    private void eor_nn() {
        this.acc ^= this.ram[this.pc++];
        this.setFlags(this.acc, true, true);
        this.ticks += 2L;
    }

    private void or_lly(int yb) {
        this.tmp = this.getWord(this.ram[this.ram[this.pc]], this.ram[this.ram[this.pc++] + 1 & 0xFF]);
        this.acc |= this.ram[this.tmp + yb];
        this.setFlags(this.acc, true, true);
        this.ticks += 5L;
        if (this.tmp >> 8 != this.tmp + yb >> 8) {
            ++this.ticks;
        }
    }

    private void or_ll_x() {
        this.acc |= this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])];
        this.setFlags(this.acc, true, true);
        this.ticks += 6L;
    }

    private void or_llx(int xb) {
        this.acc |= this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
    }

    private void or_ll() {
        this.acc |= this.ram[this.ram[this.pc++] & 0xFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 3L;
    }

    private void or_hhllx(int xb) {
        this.tmp = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.acc |= this.ram[this.tmp + xb & 0xFFFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
        if (this.tmp >> 8 != this.tmp + xb >> 8) {
            ++this.ticks;
        }
    }

    private void or_hhll() {
        this.acc |= this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
    }

    private void or_nn() {
        this.acc |= this.ram[this.pc++];
        this.setFlags(this.acc, true, true);
        this.ticks += 2L;
    }

    private void and_lly(int yb) {
        this.tmp = this.getWord(this.ram[this.ram[this.pc]], this.ram[this.ram[this.pc++] + 1 & 0xFF]);
        this.acc &= this.ram[this.tmp + yb];
        this.setFlags(this.acc, true, true);
        this.ticks += 5L;
        if (this.tmp >> 8 != this.tmp + yb >> 8) {
            ++this.ticks;
        }
    }

    private void and_ll_x() {
        this.acc &= this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])];
        this.setFlags(this.acc, true, true);
        this.ticks += 6L;
    }

    private void and_llx(int xb) {
        this.acc &= this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
    }

    private void and_ll() {
        this.acc &= this.ram[this.ram[this.pc++] & 0xFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 3L;
    }

    private void and_hhllx(int xb) {
        this.tmp = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.acc &= this.ram[this.tmp + xb & 0xFFFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
        if (this.tmp >> 8 != this.tmp + xb >> 8) {
            ++this.ticks;
        }
    }

    private void and_hhll() {
        this.acc &= this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
    }

    private void and_nn() {
        this.acc &= this.ram[this.pc++];
        this.setFlags(this.acc, true, true);
        this.ticks += 2L;
    }

    private void txs(int xb) {
        this.stackPointer = xb;
        this.ticks += 2L;
    }

    private void tsx() {
        this.x = this.stackPointer & 0xFF;
        this.setFlags(this.x, true, true);
        this.ticks += 2L;
    }

    private void txa(int xb) {
        this.acc = xb;
        this.setFlags(this.acc, true, true);
        this.ticks += 2L;
    }

    private void tay(int accb) {
        this.y = accb;
        this.setFlags(this.y, true, true);
        this.ticks += 2L;
    }

    private void tax(int accb) {
        this.x = accb;
        this.setFlags(this.x, true, true);
        this.ticks += 2L;
    }

    private void sta_lly(int accb) {
        this.ram[this.getWord((int)this.ram[this.ram[this.pc]], (int)this.ram[this.ram[this.pc++] + 1 & 0xFF]) + this.y & 0xFFFF] = accb;
        this.ticks += 6L;
    }

    private void sta_ll_x(int accb) {
        this.ram[this.getWord((int)this.ram[this.ram[this.pc] + this.x & 0xFF], (int)this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])] = accb;
        this.ticks += 6L;
    }

    private void sta_llx(int xb, int accb) {
        this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF] = accb;
        this.ticks += 4L;
    }

    private void sta_ll(int accb) {
        this.ram[this.ram[this.pc++] & 0xFF] = accb;
        this.ticks += 3L;
    }

    private void sta_hhllx(int xb, int accb) {
        this.ram[this.getWord((int)this.ram[this.pc++], (int)this.ram[this.pc++]) + xb & 0xFFFF] = accb;
        this.ticks += 5L;
    }

    private void sta_hhll(int accb) {
        this.ram[this.getWord((int)this.ram[this.pc++], (int)this.ram[this.pc++])] = accb;
        this.ticks += 4L;
    }

    private void ldy_llx(int xb) {
        this.y = this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF];
        this.setFlags(this.y, true, true);
        this.ticks += 4L;
    }

    private void ldy_ll() {
        this.y = this.ram[this.ram[this.pc++] & 0xFF];
        this.setFlags(this.y, true, true);
        this.ticks += 3L;
    }

    private void ldy_hhllx(int xb) {
        this.tmp = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.y = this.ram[this.tmp + xb & 0xFFFF];
        this.setFlags(this.y, true, true);
        this.ticks += 4L;
        if (this.tmp >> 8 != this.tmp + xb >> 8) {
            ++this.ticks;
        }
    }

    private void ldy_hhll() {
        this.y = this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])];
        this.setFlags(this.y, true, true);
        this.ticks += 4L;
    }

    private void ldy_nn() {
        this.y = this.ram[this.pc++];
        this.setFlags(this.y, true, true);
        this.ticks += 2L;
    }

    private void ldx_lly(int yb) {
        this.x = this.ram[(this.ram[this.pc++] & 0xFF) + yb & 0xFF];
        this.setFlags(this.x, true, true);
        this.ticks += 4L;
    }

    private void ldx_ll() {
        this.x = this.ram[this.ram[this.pc++] & 0xFF];
        this.setFlags(this.x, true, true);
        this.ticks += 3L;
    }

    private void ldx_hhllx(int yb) {
        this.tmp = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.x = this.ram[this.tmp + yb & 0xFFFF];
        this.setFlags(this.x, true, true);
        this.ticks += 4L;
        if (this.tmp >> 8 != this.tmp + yb >> 8) {
            ++this.ticks;
        }
    }

    private void ldx_hhll() {
        this.x = this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])];
        this.setFlags(this.x, true, true);
        this.ticks += 4L;
    }

    private void ldx_nn() {
        this.x = this.ram[this.pc++];
        this.setFlags(this.x, true, true);
        this.ticks += 2L;
    }

    private void lda_lly(int yb) {
        this.tmp = this.getWord(this.ram[this.ram[this.pc]], this.ram[this.ram[this.pc++] + 1 & 0xFF]);
        this.acc = this.ram[this.tmp + yb & 0xFFFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 5L;
        if (this.tmp >> 8 != this.tmp + yb >> 8) {
            ++this.ticks;
        }
    }

    private void lda_ll_x() {
        this.acc = this.ram[this.getWord(this.ram[this.ram[this.pc] + this.x & 0xFF], this.ram[this.ram[this.pc++] + this.x + 1 & 0xFF])];
        this.setFlags(this.acc, true, true);
        this.ticks += 6L;
    }

    private void lda_llx(int xb) {
        this.acc = this.ram[(this.ram[this.pc++] & 0xFF) + xb & 0xFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
    }

    private void lda_ll() {
        this.acc = this.ram[this.ram[this.pc++] & 0xFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 3L;
    }

    private void lda_hhll(int xb) {
        this.tmp = this.getWord(this.ram[this.pc++], this.ram[this.pc++]);
        this.acc = this.ram[this.tmp + xb & 0xFFFF];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
        if (this.tmp >> 8 != this.tmp + xb >> 8) {
            ++this.ticks;
        }
    }

    private void lda_hhll() {
        this.acc = this.ram[this.getWord(this.ram[this.pc++], this.ram[this.pc++])];
        this.setFlags(this.acc, true, true);
        this.ticks += 4L;
    }

    private void lda_nn() {
        this.acc = this.ram[this.pc++];
        this.setFlags(this.acc, true, true);
        this.ticks += 2L;
    }

    private void brk() {
        ++this.pc;
        this.push(this.ram, this.getHigh(this.pc));
        this.push(this.ram, this.getLow(this.pc));
        this.push(this.ram, this.status & 0xF7 | 0x10);
        this.pc = this.getWord(this.ram[65534], this.ram[65535]);
        this.brk = this.exitOnBreak;
        this.ticks += 7L;
    }

    public CpuCallListener getCpuCallListener() {
        return this.cpuCallListener;
    }

    public void setCpuCallListener(CpuCallListener cpuCallListener) {
        this.cpuCallListener = cpuCallListener;
    }

    private int asl(int a) {
        a &= 0xFF;
        int cf = ((a <<= 1) & 0x100) >> 8;
        this.status = this.status & 0xFE | cf;
        this.setFlags(a &= 0xFF, true, true);
        return a;
    }

    private int rol(int a) {
        int cf = ((a &= 0xFF) & 0x80) >> 7;
        a = a << 1 | this.status & 1;
        this.status = this.status & 0xFE | cf;
        this.setFlags(a &= 0xFF, true, true);
        return a;
    }

    private int lsr(int a) {
        int cf = (a &= 0xFF) & 1;
        this.status = this.status & 0xFE | cf;
        this.setFlags(a >>= 1, true, true);
        return a;
    }

    private int ror(int a) {
        int cf = (a &= 0xFF) & 1;
        a = a >> 1 | (this.status & 1) << 7;
        this.status = this.status & 0xFE | cf;
        this.setFlags(a, true, true);
        return a;
    }

    private int addBCD(int a, int b) {
        int o1 = this.convertFromBCD(a);
        int o2 = this.convertFromBCD(b);
        int r = o1 + o2;
        return this.convertToBCD(r);
    }

    private int subBCD(int a, int b) {
        int o1 = this.convertFromBCD(a);
        int o2 = this.convertFromBCD(b);
        int r = o1 - o2;
        return this.convertToBCD(r);
    }

    private int convertToBCD(int r) {
        return r % 10 + (r / 10 << 4);
    }

    private int convertFromBCD(int a) {
        return (a & 0xF) + 10 * ((a & 0xF0) >> 4);
    }

    private void setFlags(int a, boolean negative, boolean zero) {
        this.setFlags(a, a, negative, zero, false, false, false);
    }

    private void setFlags(int a, int oldA, boolean negative, boolean zero, boolean overflow, boolean carry, boolean wasAdd) {
        if (negative) {
            this.status = this.status & 0x7F | a & 0x80;
        }
        if (zero) {
            int zeroFlag = (a & 0xFF) == 0 ? 2 : 0;
            this.status = this.status & 0xFD | zeroFlag;
        }
        if (overflow) {
            int ov = oldA >= -128 && a < 127 || oldA <= 127 && a > 127 ? 64 : 0;
            this.status = this.status & 0xBF | ov;
        }
        if (carry) {
            if (wasAdd) {
                boolean decimal;
                boolean bl = decimal = (this.status & 8) > 0;
                int cf = decimal ? (a > 153 ? 1 : 0) : (a > 255 ? 1 : 0);
                this.status = this.status & 0xFE | cf;
            } else {
                int cf = a < 0 ? 0 : 1;
                this.status = this.status & 0xFE | cf;
            }
        }
    }

    private int getLow(int val) {
        return val & 0xFF;
    }

    private int getHigh(int val) {
        return val >> 8;
    }

    private int getWord(int lo, int hi) {
        return (hi & 0xFF) << 8 | lo & 0xFF;
    }

    private int pop(int[] ram) {
        ++this.stackPointer;
        int val = ram[256 + this.stackPointer];
        return val;
    }

    private void push(int[] ram, int value) {
        ram[256 + this.stackPointer] = value & 0xFF;
        --this.stackPointer;
        if (this.stackPointer < 0) {
            this.stackPointer = 255;
        }
    }
}

