/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.system;

import com.sixtyfour.Logger;
import com.sixtyfour.system.Program;
import com.sixtyfour.system.ProgramPart;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class FileWriter {
    private static final int[] HEADER;

    static {
        int[] nArray = new int[22];
        nArray[0] = 22;
        nArray[1] = 8;
        nArray[4] = 158;
        nArray[5] = 50;
        nArray[6] = 48;
        nArray[7] = 54;
        nArray[8] = 56;
        nArray[9] = 58;
        nArray[10] = 143;
        nArray[11] = 32;
        nArray[12] = 77;
        nArray[13] = 79;
        nArray[14] = 83;
        nArray[15] = 80;
        nArray[16] = 69;
        nArray[17] = 69;
        nArray[18] = 68;
        HEADER = nArray;
    }

    public static void writeAsDatas(Program prg, String fileName, int lineNumber) throws IOException {
        FileWriter.writeAsDatas(prg, new FileOutputStream(fileName), lineNumber);
    }

    public static void writeAsPrg(Program prg, String fileName, boolean withBasicHeader) throws IOException {
        FileWriter.writeAsPrg(prg, new FileOutputStream(fileName), withBasicHeader, 2049, true);
    }

    public static void writeAsPrg(Program prg, OutputStream os, boolean withBasicHeader) throws IOException {
        FileWriter.writeAsPrg(prg, os, withBasicHeader, 2049, true);
    }

    public static void writeAsPrg(Program prg, String fileName, boolean withBasicHeader, int baseAddr, boolean withAddressBytes) throws IOException {
        FileWriter.writeAsPrg(prg, new FileOutputStream(fileName), withBasicHeader, baseAddr, withAddressBytes);
    }

    public static void writeAsPrg(Program prg, OutputStream os, boolean withBasicHeader, int baseAddr, boolean withAddressBytes) throws IOException {
        int cc;
        int c;
        int codeStart;
        FilterOutputStream bos = null;
        int codeStartOrg = codeStart = prg.getCodeStart();
        int[] header = null;
        int sa = baseAddr + 23;
        int ea = sa + 228;
        if (withBasicHeader) {
            if (codeStart >= sa && codeStart < ea) {
                header = new int[codeStart - baseAddr];
                System.arraycopy(HEADER, 0, header, 0, HEADER.length);
                String hss = String.valueOf(codeStart);
                int i = 0;
                while (i < hss.length()) {
                    c = hss.charAt(i);
                    header[i + 5] = cc = c - 48 + 48;
                    ++i;
                }
                codeStart = baseAddr;
            } else {
                throw new RuntimeException("Starting address out of range for a BASIC header: " + prg.getCodeStart() + "/" + baseAddr);
            }
        }
        try {
            Object object;
            ArrayList<ProgramPart> parts = new ArrayList<ProgramPart>(prg.getParts());
            Collections.sort(parts);
            bos = new BufferedOutputStream(os);
            if (withAddressBytes) {
                if (!withBasicHeader) {
                    ((BufferedOutputStream)bos).write(((ProgramPart)parts.get(0)).getAddress() % 256);
                    ((BufferedOutputStream)bos).write(((ProgramPart)parts.get(0)).getAddress() >> 8);
                } else {
                    ((BufferedOutputStream)bos).write(codeStart % 256);
                    ((BufferedOutputStream)bos).write(codeStart >> 8);
                }
            }
            if (header != null) {
                object = header;
                cc = header.length;
                c = 0;
                while (c < cc) {
                    Object b = object[c];
                    ((BufferedOutputStream)bos).write((int)b);
                    ++c;
                }
            }
            int lastEnd = -1;
            int cnt = 0;
            object = parts.iterator();
            while (object.hasNext()) {
                Integer end;
                ProgramPart part = (ProgramPart)object.next();
                int start = part.getAddress();
                int[] bin = part.getBytes();
                if (lastEnd != -1) {
                    int i = lastEnd;
                    while (i < start) {
                        ((BufferedOutputStream)bos).write(0);
                        ++i;
                    }
                }
                if ((end = prg.getLabelsContainer().get("PROGRAMEND")) != null && end < part.getEndAddress() && end > (cnt == 0 ? codeStartOrg : start)) {
                    int clip = end - (cnt == 0 ? codeStartOrg : start);
                    if (clip < bin.length) {
                        bin = Arrays.copyOfRange(bin, 0, clip);
                    }
                } else {
                    end = part.getEndAddress();
                }
                lastEnd = end;
                ++cnt;
                int[] nArray = bin;
                int n = bin.length;
                int n2 = 0;
                while (n2 < n) {
                    int b = nArray[n2];
                    ((BufferedOutputStream)bos).write(b);
                    ++n2;
                }
            }
        }
        finally {
            if (bos != null) {
                bos.close();
            }
        }
    }

    private static void writeAsDatas(Program prg, FileOutputStream fileOutputStream, int lineNumber) {
        ArrayList<ProgramPart> parts = new ArrayList<ProgramPart>(prg.getParts());
        Collections.sort(parts);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (PrintWriter pw = new PrintWriter(fileOutputStream);){
                for (ProgramPart part : parts) {
                    pw.println(String.valueOf(lineNumber++) + " for qq=" + part.getAddress() + " to " + (part.getEndAddress() - 1) + ":read dq:pokeqq,dq:next");
                }
                pw.println(String.valueOf(lineNumber++) + " return");
                StringBuilder sb = new StringBuilder();
                for (ProgramPart part : parts) {
                    int[] nArray = part.getBytes();
                    int n = nArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int bite = nArray[n2];
                        boolean first = false;
                        if (sb.length() == 0) {
                            sb.append(lineNumber++).append(" data ");
                            first = true;
                        }
                        if (!first) {
                            sb.append(",");
                        }
                        sb.append(bite & 0xFF);
                        if (sb.length() > 70) {
                            pw.println(sb.toString());
                            sb.setLength(0);
                        }
                        ++n2;
                    }
                    if (sb.length() > 0 && !sb.toString().endsWith(" data ")) {
                        pw.println(sb.toString());
                    }
                    sb.setLength(0);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Logger.log("Failed to write data file!", e);
            throw e;
        }
    }
}

