/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.system;

import com.sixtyfour.system.Machine;
import com.sixtyfour.util.Colors;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class Graphics {
    private static final int WHITE = 0xFFFFFF;
    private static final int RED = 0xFF0000;
    private static final int GREEN = 65280;
    private static final int BLUE = 255;
    private static final int COLOR_MEMORY = 55296;

    public static BufferedImage createImage(Machine machine, int bitmapStartAddress, int textramStartAddress, boolean multiColor, boolean withColors) {
        return Graphics.createImage(machine.getRam(), bitmapStartAddress, textramStartAddress, multiColor, withColors);
    }

    public static BufferedImage createImage(int[] ram, int bitmapStartAddress, int textramStartAddress, boolean multiColor, boolean withColors) {
        BufferedImage bi = new BufferedImage(320, 200, 1);
        Graphics.fillImage(ram, bitmapStartAddress, textramStartAddress, multiColor, withColors, bi);
        return bi;
    }

    public static void fillImage(int[] ram, int bitmapStartAddress, int textramStartAddress, boolean multiColor, boolean withColors, BufferedImage bi) {
        int[] nArray = new int[4];
        nArray[1] = 255;
        nArray[2] = 65280;
        nArray[3] = 0xFF0000;
        int[] mc = nArray;
        if (!withColors) {
            Graphics.createWithDefaultColors(bitmapStartAddress, multiColor, bi, ram, mc);
        } else {
            Graphics.createWithRamColors(bitmapStartAddress, textramStartAddress, multiColor, bi, ram);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void savePng(BufferedImage bi, OutputStream os) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                BufferedOutputStream bos = new BufferedOutputStream(os);
                try {
                    try (ImageOutputStream ios = ImageIO.createImageOutputStream(bos);){
                        Iterator<ImageWriter> itty = ImageIO.getImageWritersBySuffix("png");
                        if (itty.hasNext()) {
                            ImageWriter iw = itty.next();
                            ImageWriteParam iwp = iw.getDefaultWriteParam();
                            iw.setOutput(ios);
                            iw.write(null, new IIOImage(bi, null, null), iwp);
                        }
                    }
                    if (bos == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (bos == null) throw throwable;
                    bos.close();
                    throw throwable;
                }
                bos.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void createWithRamColors(int startAddress, int textramStartAddress, boolean multiColor, BufferedImage bi, int[] ram) {
        int bgColor = Colors.COLORS[ram[53281] & 0xFF];
        if (!multiColor) {
            int x = 0;
            while (x < 320) {
                int y = 0;
                while (y < 200) {
                    int p = x + (y & 7) + (y >> 3) * 320 + startAddress;
                    int ramPos = x / 8 + y / 8 * 40;
                    int col = ram[p] & 0xFF;
                    int s = 128;
                    int b = 0;
                    while (b < 8) {
                        int c = (col & s) == s ? Colors.COLORS[ram[textramStartAddress + ramPos] >> 4] : Colors.COLORS[ram[textramStartAddress + ramPos] & 0xF];
                        s >>= 1;
                        bi.setRGB(x + b, y, c);
                        ++b;
                    }
                    ++y;
                }
                x += 8;
            }
        } else {
            int x = 0;
            while (x < 320) {
                int y = 0;
                while (y < 200) {
                    int p = x + (y & 7) + (y >> 3) * 320 + startAddress;
                    int ramPos = x / 8 + y / 8 * 40;
                    int col = ram[p] & 0xFF;
                    int s = 128;
                    int b = 0;
                    while (b < 8) {
                        int c1 = (col & s) == s ? 1 : 0;
                        int n = (col & (s >>= 1)) == s ? 2 : 0;
                        s >>= 1;
                        switch (c1 += n) {
                            case 0: {
                                c1 = bgColor;
                                break;
                            }
                            case 2: {
                                c1 = Colors.COLORS[ram[textramStartAddress + ramPos] >> 4];
                                break;
                            }
                            case 1: {
                                c1 = Colors.COLORS[ram[textramStartAddress + ramPos] & 0xF];
                                break;
                            }
                            case 3: {
                                c1 = Colors.COLORS[ram[55296 + ramPos] & 0xF];
                            }
                        }
                        bi.setRGB(x + b, y, c1);
                        bi.setRGB(x + b + 1, y, c1);
                        b += 2;
                    }
                    ++y;
                }
                x += 8;
            }
        }
    }

    private static void createWithDefaultColors(int startAddress, boolean multiColor, BufferedImage bi, int[] ram, int[] mc) {
        if (!multiColor) {
            int x = 0;
            while (x < 320) {
                int y = 0;
                while (y < 200) {
                    int p = x + (y & 7) + (y >> 3) * 320 + startAddress;
                    int col = ram[p] & 0xFF;
                    int s = 128;
                    int b = 0;
                    while (b < 8) {
                        int c = (col & s) == s ? 0xFFFFFF : 0;
                        s >>= 1;
                        bi.setRGB(x + b, y, c);
                        ++b;
                    }
                    ++y;
                }
                x += 8;
            }
        } else {
            int x = 0;
            while (x < 320) {
                int y = 0;
                while (y < 200) {
                    int p = x + (y & 7) + (y >> 3) * 320 + startAddress;
                    int col = ram[p] & 0xFF;
                    int s = 128;
                    int b = 0;
                    while (b < 8) {
                        int c1 = (col & s) == s ? 1 : 0;
                        int c2 = (col & (s >>= 1)) == s ? 2 : 0;
                        s >>= 1;
                        bi.setRGB(x + b, y, mc[c1 + c2]);
                        bi.setRGB(x + b + 1, y, mc[c1 + c2]);
                        b += 2;
                    }
                    ++y;
                }
                x += 8;
            }
        }
    }
}

