/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.system;

import com.sixtyfour.Basic;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.elements.commands.Command;
import com.sixtyfour.elements.commands.For;
import com.sixtyfour.elements.commands.Rem;
import com.sixtyfour.elements.systemvars.Pie;
import com.sixtyfour.elements.systemvars.Status;
import com.sixtyfour.elements.systemvars.Time;
import com.sixtyfour.elements.systemvars.TimeDate;
import com.sixtyfour.extensions.BasicExtension;
import com.sixtyfour.parser.Operator;
import com.sixtyfour.plugins.DeviceProvider;
import com.sixtyfour.plugins.InputProvider;
import com.sixtyfour.plugins.MemoryListener;
import com.sixtyfour.plugins.OutputChannel;
import com.sixtyfour.plugins.SystemCallListener;
import com.sixtyfour.plugins.impl.ConsoleInputProvider;
import com.sixtyfour.plugins.impl.ConsoleOutputChannel;
import com.sixtyfour.plugins.impl.MemoryDeviceProvider;
import com.sixtyfour.plugins.impl.NullMemoryListener;
import com.sixtyfour.plugins.impl.NullSystemCallListener;
import com.sixtyfour.system.Cpu;
import com.sixtyfour.system.DataStore;
import com.sixtyfour.system.Program;
import com.sixtyfour.system.ProgramPart;
import com.sixtyfour.system.StackEntry;
import com.sixtyfour.util.Jit;
import com.sixtyfour.util.VarUtils;
import java.io.BufferedInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Machine {
    private Map<String, Variable> vars = new HashMap<String, Variable>();
    private int[] ram = new int[65536];
    private List<StackEntry> stack = new LinkedList<StackEntry>();
    private List<Command> commandList = new ArrayList<Command>();
    private Command currentCommand = null;
    private Operator currentOperator = null;
    private Map<String, Command> functions = new HashMap<String, Command>();
    private DataStore data = new DataStore();
    private OutputChannel outputChannel = null;
    private InputProvider inputProvider = null;
    private MemoryListener memoryListener = null;
    private SystemCallListener systemCallListener = null;
    private DeviceProvider deviceProvider = null;
    private Cpu cpu = null;
    private Jit jit = null;
    private List<StackEntry> toRemove = new ArrayList<StackEntry>();
    private List<RomInfo> roms;
    private Map<String, Integer> usageIndicator = new HashMap<String, Integer>();
    private List<Variable> extendedSystemVars = new ArrayList<Variable>();

    public Machine() {
        this.inputProvider = new ConsoleInputProvider();
        this.outputChannel = new ConsoleOutputChannel();
        this.memoryListener = new NullMemoryListener();
        this.deviceProvider = new MemoryDeviceProvider(this.outputChannel);
        this.setSystemCallListener(new NullSystemCallListener());
        this.addDefaults();
        this.cpu = new Cpu(this);
    }

    public void addRoms() {
        this.roms = new ArrayList<RomInfo>();
        this.roms.add(this.loadRom("basic.$A000.bin", 40960));
        this.roms.add(this.loadRom("kernal.$E000.bin", 57344));
        this.copyRoms();
    }

    public void addSystemVariables(List<Variable> vars) {
        if (vars == null) {
            return;
        }
        Set names = this.extendedSystemVars.stream().map(p -> p.getName()).collect(Collectors.toSet());
        for (Variable var : vars) {
            var.setPersistent(false);
            this.addXSystemVar(var);
            if (names.contains(var.getName())) continue;
            this.extendedSystemVars.add(var);
        }
    }

    public boolean isSystemVariable(String name) {
        Variable var = this.vars.get(name.toUpperCase(Locale.ENGLISH));
        return var != null && var.isSystem();
    }

    public void setFunction(String name, Command function) {
        this.functions.put(name, function);
    }

    public Command getFunction(String name) {
        return this.functions.get(name);
    }

    public int[] getRam() {
        return this.ram;
    }

    public void push(Command command) {
        if (this.stack.size() > 10000) {
            throw new RuntimeException("Out of memory error, stack size exceeds 10000!");
        }
        this.stack.add(new StackEntry(command));
    }

    public void pushFor(For fory) {
        if (this.stack.size() > 10000) {
            int i = 0;
            while (i < this.stack.size()) {
                StackEntry se = this.stack.get(i);
                if (se.isSubroutineCall()) {
                    System.out.println(se.getCommand());
                }
                ++i;
            }
            throw new RuntimeException("Out of memory error, stack size exceeds 10000!");
        }
        int i = 0;
        while (i < this.stack.size()) {
            StackEntry cmd = this.stack.get(i);
            if (cmd.isFor() && ((For)cmd.getCommand()).getVar().equals(fory.getVar())) {
                this.popFor((For)cmd.getCommand());
                break;
            }
            ++i;
        }
        this.stack.add(new StackEntry(fory));
    }

    public For popFor(For fory) {
        int end;
        int i = end = this.stack.size() - 1;
        while (i >= 0) {
            StackEntry entry = this.stack.get(i);
            if (entry.getCommand() == fory) {
                if (i == end) {
                    this.stack.remove(end);
                } else {
                    this.toRemove.clear();
                    int p = end;
                    while (p >= i) {
                        entry = this.stack.get(p);
                        if (entry.isFor()) {
                            this.toRemove.add(entry);
                        }
                        --p;
                    }
                    this.stack.removeAll(this.toRemove);
                }
                return (For)entry.getCommand();
            }
            --i;
        }
        return null;
    }

    public For peekFor(String varName) {
        int i = this.stack.size() - 1;
        while (i >= 0) {
            StackEntry entry = this.stack.get(i);
            if (entry.isFor() && (varName == null || varName.equalsIgnoreCase(((For)entry.getCommand()).getVar().getName()))) {
                return (For)entry.getCommand();
            }
            --i;
        }
        return null;
    }

    public StackEntry getCaller() {
        int i = this.stack.size() - 1;
        while (i >= 0) {
            StackEntry entry = this.stack.get(i);
            if (entry.isSubroutineCall()) {
                int end = this.stack.size();
                int p = 0;
                while (p < end - i) {
                    this.stack.remove(this.stack.size() - 1);
                    ++p;
                }
                return entry;
            }
            --i;
        }
        return null;
    }

    public StackEntry peek() {
        if (this.stack.size() > 0) {
            return this.stack.get(this.stack.size() - 1);
        }
        return null;
    }

    public StackEntry pop() {
        if (this.stack.isEmpty()) {
            throw new RuntimeException("Out of memory error, stack is empty!");
        }
        return this.stack.remove(this.stack.size() - 1);
    }

    public void resetMemory() {
        int i = 0;
        while (i < this.ram.length) {
            this.ram[i] = 0;
            ++i;
        }
        this.vars.clear();
        this.clearVars();
        this.clearCommandList();
        this.functions.clear();
        for (BasicExtension ex : Basic.getExtensions()) {
            ex.reset(this);
        }
        this.copyRoms();
    }

    public void clearVars() {
        for (Variable var : this.vars.values()) {
            var.setPersistent(false);
            var.clear();
            var.setConstant(false);
        }
        this.addDefaults();
        for (Variable var : this.extendedSystemVars) {
            var.setPersistent(false);
            this.addXSystemVar(var);
        }
        this.stack.clear();
        this.usageIndicator.clear();
    }

    private void addXSystemVar(Variable var) {
        if (this.vars.containsKey(var.getUpperCaseName())) {
            this.vars.remove(var.getUpperCaseName());
        }
        this.add(var);
    }

    public Variable add(Variable var) {
        if (var.isPersistent()) {
            return var;
        }
        Variable ret = this.getVariableUpperCase(var.getUpperCaseName());
        if (ret == null) {
            this.vars.put(var.getUpperCaseName(), var);
            var.setPersistent(true);
            ret = var;
        }
        return ret;
    }

    public Variable addOrSet(Variable var) {
        Variable ret = this.getVariableUpperCase(var.getUpperCaseName());
        if (ret == null) {
            this.vars.put(var.getUpperCaseName(), var);
            ret = var;
        } else {
            ret.setValue(var.getValue());
        }
        return ret;
    }

    public void trackVariableUsage(Variable var, boolean assignment) {
        if (var.isSupposedToBeArray()) {
            return;
        }
        String name = var.getUpperCaseName();
        Integer indicator = this.usageIndicator.get(name);
        if (indicator == null) {
            indicator = 0;
        }
        this.usageIndicator.put(name, assignment ? indicator + 1 : indicator + 10);
    }

    public Variable getVariable(String name) {
        if (name == null) {
            throw new RuntimeException("Null variable found!");
        }
        name = VarUtils.toUpper(name);
        return this.vars.get(name);
    }

    public boolean isAssignedOnce(Variable var) {
        if (var.isSupposedToBeArray()) {
            return false;
        }
        Integer cnt = this.usageIndicator.get(var.getUpperCaseName());
        return cnt != null && cnt == 1;
    }

    public Map<String, Variable> getVariables() {
        return new HashMap<String, Variable>(this.vars);
    }

    public Variable getVariableUpperCase(String name) {
        return this.vars.get(name);
    }

    public void addCommand(Command command) {
        this.commandList.add(command);
    }

    public List<Command> getCommandList() {
        return this.commandList;
    }

    public void setCommandList(List<Command> commandList) {
        this.commandList = commandList;
    }

    public void clearCommandList() {
        this.commandList.clear();
        this.data.clear();
    }

    public void removeCommands(List<Command> toRemove) {
        HashSet<Command> remSet = new HashSet<Command>(toRemove);
        int i = 0;
        while (i < this.commandList.size()) {
            Command cmd = this.commandList.get(i);
            if (remSet.contains(cmd)) {
                this.commandList.set(i, new Rem());
            }
            ++i;
        }
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public void setCurrentCommand(Command currentCommand) {
        this.currentCommand = currentCommand;
        if (this.jit != null) {
            this.jit.autoCompile();
        }
    }

    public Operator getCurrentOperator() {
        return this.currentOperator;
    }

    public void setCurrentOperator(Operator currentOperator) {
        this.currentOperator = currentOperator;
    }

    public OutputChannel getOutputChannel() {
        return this.outputChannel;
    }

    public void setOutputChannel(OutputChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public MemoryListener getMemoryListener() {
        return this.memoryListener;
    }

    public void setMemoryListener(MemoryListener memoryListener) {
        this.memoryListener = memoryListener;
    }

    public InputProvider getInputProvider() {
        return this.inputProvider;
    }

    public void setInputProvider(InputProvider inputProvider) {
        this.inputProvider = inputProvider;
    }

    public DataStore getDataStore() {
        return this.data;
    }

    public void setDataStore(DataStore data) {
        this.data = data;
    }

    public SystemCallListener getSystemCallListener() {
        return this.systemCallListener;
    }

    public void setSystemCallListener(SystemCallListener systemCallListener) {
        this.systemCallListener = systemCallListener;
    }

    public DeviceProvider getDeviceProvider() {
        return this.deviceProvider;
    }

    public void setDeviceProvider(DeviceProvider deviceProvider) {
        this.deviceProvider = deviceProvider;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public void putProgram(Program prg) {
        List<ProgramPart> parts = prg.getParts();
        for (ProgramPart part : parts) {
            int[] bin = part.getBytes();
            System.arraycopy(bin, 0, this.getRam(), part.getAddress(), bin.length);
        }
    }

    public Jit getJit() {
        return this.jit;
    }

    public void setJit(Jit jit) {
        this.jit = jit;
    }

    private void addDefaults() {
        this.add(new Pie());
        this.add(new Time());
        this.add(new TimeDate());
        this.add(new Status());
    }

    private void copyRoms() {
        if (this.roms != null) {
            for (RomInfo rom : this.roms) {
                System.arraycopy(rom.data, 0, this.ram, rom.address, rom.data.length);
            }
        }
        this.ram[53272] = 21;
        this.ram[648] = 4;
        this.ram[806] = 202;
        this.ram[807] = 241;
        this.ram[804] = 87;
        this.ram[805] = 241;
        this.ram[802] = 51;
        this.ram[803] = 243;
        this.ram[800] = 80;
        this.ram[801] = 242;
        this.ram[798] = 14;
        this.ram[799] = 242;
        this.ram[796] = 145;
        this.ram[797] = 242;
        this.ram[794] = 74;
        this.ram[795] = 243;
        this.ram[808] = 237;
        this.ram[809] = 246;
        this.ram[810] = 62;
        this.ram[811] = 241;
        this.ram[812] = 47;
        this.ram[813] = 243;
        int[] nArray = new int[256];
        nArray[0] = 47;
        nArray[1] = 55;
        nArray[3] = 170;
        nArray[4] = 177;
        nArray[5] = 145;
        nArray[6] = 179;
        nArray[7] = 34;
        nArray[8] = 34;
        nArray[13] = 255;
        nArray[22] = 25;
        nArray[43] = 1;
        nArray[44] = 8;
        nArray[45] = 3;
        nArray[46] = 8;
        nArray[56] = 160;
        nArray[58] = 255;
        nArray[83] = 3;
        nArray[84] = 76;
        nArray[145] = 255;
        nArray[157] = 128;
        nArray[197] = 64;
        nArray[203] = 64;
        nArray[204] = 1;
        nArray[217] = 132;
        nArray[218] = 132;
        nArray[219] = 132;
        nArray[220] = 132;
        nArray[221] = 132;
        nArray[222] = 132;
        nArray[223] = 132;
        nArray[224] = 133;
        nArray[225] = 133;
        nArray[226] = 133;
        nArray[227] = 133;
        nArray[228] = 133;
        nArray[229] = 133;
        nArray[230] = 134;
        nArray[231] = 134;
        nArray[232] = 134;
        nArray[233] = 134;
        nArray[234] = 134;
        nArray[235] = 134;
        nArray[236] = 135;
        nArray[237] = 135;
        nArray[238] = 135;
        nArray[239] = 135;
        nArray[240] = 135;
        nArray[245] = 129;
        nArray[246] = 235;
        int[] zeropage = nArray;
        if (zeropage.length != 256) {
            throw new RuntimeException("Invalid zeo page definition: " + zeropage.length);
        }
        zeropage[209] = 0;
        zeropage[210] = 4;
        zeropage[243] = 0;
        zeropage[244] = 216;
        zeropage[153] = 0;
        zeropage[154] = 3;
        zeropage[213] = 40;
        System.arraycopy(zeropage, 0, this.ram, 0, 256);
        int[] nArray2 = new int[24];
        nArray2[0] = 230;
        nArray2[1] = 122;
        nArray2[2] = 208;
        nArray2[3] = 2;
        nArray2[4] = 230;
        nArray2[5] = 123;
        nArray2[6] = 173;
        nArray2[8] = 8;
        nArray2[9] = 201;
        nArray2[10] = 58;
        nArray2[11] = 176;
        nArray2[12] = 10;
        nArray2[13] = 201;
        nArray2[14] = 32;
        nArray2[15] = 240;
        nArray2[16] = 239;
        nArray2[17] = 56;
        nArray2[18] = 233;
        nArray2[19] = 48;
        nArray2[20] = 56;
        nArray2[21] = 233;
        nArray2[22] = 208;
        nArray2[23] = 96;
        int[] chrget = nArray2;
        System.arraycopy(chrget, 0, this.ram, 115, chrget.length);
    }

    private RomInfo loadRom(String rom, int address) {
        RomInfo ri = new RomInfo();
        ri.address = address;
        BufferedInputStream br = null;
        byte[] buffer = new byte[8192];
        int[] dest = new int[8192];
        try {
            try {
                br = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(rom));
                int len = 0;
                int cnt = 0;
                do {
                    if ((len = br.read(buffer)) <= 0) continue;
                    int i = 0;
                    while (i < len) {
                        if (cnt + i >= dest.length) {
                            throw new RuntimeException("ROM file too large!");
                        }
                        dest[cnt + i] = buffer[i] & 0xFF;
                        ++i;
                    }
                } while (len != -1);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load ROM file: " + rom, e);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
        }
        ri.data = dest;
        return ri;
    }

    private static class RomInfo {
        int[] data;
        int address;

        private RomInfo() {
        }
    }
}

