/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.templating;

import com.sixtyfour.Assembler;
import com.sixtyfour.Basic;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.parser.Line;
import com.sixtyfour.parser.Preprocessor;
import com.sixtyfour.plugins.CpuCallListener;
import com.sixtyfour.system.Cpu;
import com.sixtyfour.system.Machine;
import com.sixtyfour.system.Program;
import com.sixtyfour.templating.StaticTemplateCallListener;
import com.sixtyfour.templating.TemplateDeviceProvider;
import com.sixtyfour.templating.TemplateOutputChannel;
import com.sixtyfour.templating.TemplatePart;
import com.sixtyfour.util.VarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Template {
    private Map<String, Object> vars = new HashMap<String, Object>();
    private Basic basic = null;
    private List<Program> prgs = new ArrayList<Program>();
    private Map<Integer, TemplatePart> staticParts = new HashMap<Integer, TemplatePart>();
    private TemplateOutputChannel out;
    private String basicCode;
    private String path;

    public Template(CompilerConfig config, String template, Map<String, Object> variables) {
        if (variables != null) {
            this.vars.putAll(variables);
        }
        this.parseTemplate(config, template);
    }

    public void setVariable(String name, Object value) {
        this.vars.put(name, value);
    }

    public void setVariables(Map<String, Object> variables) {
        this.vars.clear();
        this.vars.putAll(variables);
    }

    public void setVariablesWithType(Map<String, Object> variables) {
        this.vars.clear();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : variables.entrySet()) {
            String name = entry.getKey();
            Object obj = entry.getValue();
            if (VarUtils.isDouble(obj) || VarUtils.isFloat(obj)) {
                obj = Float.valueOf(((Number)obj).floatValue());
            }
            if (VarUtils.isInteger(obj) && !name.endsWith("%")) {
                name = String.valueOf(name) + "%";
            } else if (VarUtils.isString(obj) && !name.endsWith("$")) {
                name = String.valueOf(name) + "$";
            }
            vars.put(name, obj);
        }
        this.setVariables(vars);
    }

    public String getBasicCode() {
        return this.basicCode;
    }

    public Object getVariable(String name) {
        Variable var = this.basic.getMachine().getVariable(VarUtils.toUpper(name));
        if (var == null) {
            return null;
        }
        return var.getValue();
    }

    public String process(CompilerConfig config) {
        this.out.reset();
        Machine machine = this.basic.getMachine();
        machine.resetMemory();
        machine.getCpu().reset();
        for (Program program : this.prgs) {
            machine.putProgram(program);
        }
        for (Map.Entry entry : this.vars.entrySet()) {
            Variable vary = new Variable(VarUtils.toUpper((String)entry.getKey()), entry.getValue());
            machine.addOrSet(vary);
        }
        this.basic.start(config);
        return this.out.getResult();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Machine getMachine() {
        return this.basic.getMachine();
    }

    public void setMachine(Machine machine) {
        this.basic.setMachine(machine);
    }

    String processPart(CompilerConfig config) {
        this.out.reset();
        this.basic.start(config);
        return this.out.getResult();
    }

    private void parseTemplate(CompilerConfig config, String template) {
        boolean labels;
        int pl = template.toLowerCase(Locale.ENGLISH).indexOf("<!labels>");
        boolean bl = labels = pl != -1;
        if (labels) {
            template = String.valueOf(template) + "<?cbm REM end ?>";
            template = String.valueOf(template.substring(0, pl)) + template.substring(pl + 9);
        } else {
            template = String.valueOf(template) + "<?cbm 9999999 REM end ?>";
        }
        String utemp = VarUtils.toUpper(template);
        int pos = 0;
        int last = 0;
        int lastLine = 0;
        StringBuilder code = new StringBuilder();
        do {
            int opos;
            if ((pos = utemp.indexOf("<?CBM", opos = pos)) == -1) continue;
            int pos2 = -1;
            boolean inString = false;
            int i = pos;
            while (i < utemp.length() - 1) {
                char c = utemp.charAt(i);
                if (c == '\"') {
                    boolean bl2 = inString = !inString;
                }
                if (!inString && c == '?' && utemp.charAt(i + 1) == '>') {
                    pos2 = i + 2;
                    break;
                }
                ++i;
            }
            if (pos2 == -1) {
                throw new RuntimeException("Syntax error in template, no closing ?> found!");
            }
            String prior = template.substring(last, pos);
            String codePart = template.substring(pos + 5, pos2 - 2);
            int firstLine = -1;
            int endLine = -1;
            boolean asm = codePart.toLowerCase(Locale.ENGLISH).startsWith(":asm");
            if (asm) {
                codePart = codePart.substring(4);
            }
            String[] lines = codePart.split("\n");
            if (!asm) {
                if (!labels) {
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (!(line = line.replace("\t", "").trim()).isEmpty()) {
                            Line lo = Line.getLine(line);
                            firstLine = lo.getNumber();
                            break;
                        }
                        ++n2;
                    }
                    int i2 = lines.length - 1;
                    while (i2 >= 0) {
                        String line = lines[i2];
                        if (!(line = line.replace("\t", "").trim()).isEmpty()) {
                            Line lo = Line.getLine(line);
                            endLine = lo.getNumber();
                            break;
                        }
                        --i2;
                    }
                    if (firstLine <= lastLine) {
                        throw new RuntimeException("Line numbers (" + firstLine + "/" + lastLine + ") too close, can't insert static content into template!");
                    }
                    lastLine = this.addStaticPart(lastLine, code, prior, firstLine, labels);
                    prior = null;
                    lastLine = endLine;
                } else if (!prior.isEmpty()) {
                    TemplatePart tp = new TemplatePart(prior);
                    prior = null;
                    code.append("SYS1000,").append(++lastLine).append('\n');
                    this.staticParts.put(lastLine, tp);
                }
                code.append(codePart).append('\n');
            } else {
                lastLine = this.addStaticPart(lastLine, code, prior, firstLine, labels);
                prior = null;
                Assembler assem = new Assembler(lines);
                assem.compile(config);
                this.prgs.add(assem.getProgram());
            }
            last = pos2;
            pos = pos2;
        } while (pos != -1);
        if (labels) {
            String[] lines = code.toString().split("\n");
            lines = Preprocessor.convertToLineNumbers(lines);
            code.setLength(0);
            String[] stringArray = lines;
            int n = lines.length;
            int n3 = 0;
            while (n3 < n) {
                String line = stringArray[n3];
                code.append(line).append('\n');
                ++n3;
            }
        }
        this.basicCode = code.toString();
        this.basic = new Basic(this.basicCode);
        this.basic.compile(config);
        this.out = new TemplateOutputChannel();
        this.basic.setOutputChannel(this.out);
        this.basic.getMachine().setSystemCallListener(new StaticTemplateCallListener(this.staticParts, this.out, this.basic.getMachine()));
        this.basic.getMachine().setDeviceProvider(new TemplateDeviceProvider(this.basic, this));
        this.basic.getMachine().getCpu().setCpuCallListener(new CpuCallListener(){

            @Override
            public boolean jsr(Cpu cpu, int addr) {
                if (addr == 65490) {
                    if (cpu.getAcc() != 0) {
                        Template.this.out.print(0, String.valueOf((char)cpu.getAcc()));
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private int addStaticPart(int lastLine, StringBuilder code, String prior, int firstLine, boolean labels) {
        if (!prior.isEmpty()) {
            TemplatePart tp = new TemplatePart(prior);
            tp.setFirstLine(lastLine);
            tp.setLastLine(firstLine - 1);
            code.append(labels ? "" : Integer.valueOf(++lastLine)).append(" SYS1000,").append(lastLine).append('\n');
            this.staticParts.put(lastLine, tp);
        }
        return lastLine;
    }
}

