/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.templating;

import com.sixtyfour.Basic;
import com.sixtyfour.Logger;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.plugins.OutputChannel;
import com.sixtyfour.plugins.impl.MemoryDeviceProvider;
import com.sixtyfour.system.Machine;
import com.sixtyfour.templating.Template;
import com.sixtyfour.templating.TemplateManager;
import java.util.Map;

public class TemplateDeviceProvider
extends MemoryDeviceProvider {
    private Template baseTemplate;

    public TemplateDeviceProvider(Basic basic, Template baseTemplate) {
        super(basic.getOutputChannel());
        this.baseTemplate = baseTemplate;
    }

    @Override
    public void load(CompilerConfig config, String fileName, int device, int secondary) {
        if (device == 8) {
            TemplateManager tm = TemplateManager.getInstance();
            String baseName = this.baseTemplate.getPath().replace('\\', '/');
            int pos = baseName.lastIndexOf(47);
            if (pos != -1) {
                baseName = baseName.substring(0, pos + 1);
                if (fileName.startsWith("/") || fileName.startsWith("\\")) {
                    fileName = fileName.substring(1);
                }
                fileName = String.valueOf(baseName) + fileName;
            }
            Template tmpl = tm.getTemplate(fileName);
            OutputChannel oo = this.baseTemplate.getMachine().getOutputChannel();
            Machine base = this.baseTemplate.getMachine();
            for (Map.Entry<String, Variable> entry : base.getVariables().entrySet()) {
                if (entry.getValue().isSystem()) continue;
                tmpl.getMachine().addOrSet(entry.getValue());
            }
            String result = tmpl.processPart(config);
            oo.print(0, result);
        } else {
            Logger.log("Device not found, load call ignored: " + device);
        }
    }
}

