/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.templating;

import com.sixtyfour.Logger;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.templating.Template;
import com.sixtyfour.templating.TemplateFactory;
import com.sixtyfour.templating.TemplateInfo;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;

public class TemplateManager {
    private Map<TemplateInfo, ThreadLocal<Template>> templates = new HashMap<TemplateInfo, ThreadLocal<Template>>();
    private Map<String, TemplateInfo> templateInfos = new HashMap<String, TemplateInfo>();
    private static TemplateManager instance = new TemplateManager();
    private CompilerConfig config = new CompilerConfig();

    public static TemplateManager getInstance() {
        return instance;
    }

    private TemplateManager() {
    }

    public synchronized Template getTemplate(String pathToTemplate) {
        ThreadLocal<Template> tl;
        TemplateInfo existing = this.templateInfos.get(pathToTemplate);
        if (existing == null) {
            existing = new TemplateInfo(pathToTemplate);
            ThreadLocal<Template> tl2 = new ThreadLocal<Template>();
            this.templates.put(existing, tl2);
            Template tmpl = this.createTemplate(this.config, pathToTemplate, existing, tl2);
            this.templateInfos.put(pathToTemplate, existing);
            return tmpl;
        }
        if (existing.hasChanged()) {
            Logger.log("Template " + pathToTemplate + " has been modified, reloading...");
            this.templates.remove(existing);
        }
        if ((tl = this.templates.get(existing)) == null) {
            tl = new ThreadLocal();
            this.templates.put(existing, tl);
            return this.createTemplate(this.config, pathToTemplate, existing, tl);
        }
        Template tmpl = tl.get();
        if (tmpl == null) {
            return this.createTemplate(this.config, pathToTemplate, existing, tl);
        }
        return tmpl;
    }

    private Template createTemplate(CompilerConfig config, String pathToTemplate, TemplateInfo existing, ThreadLocal<Template> tl) {
        try {
            Logger.log("Creating new template instance for " + pathToTemplate);
            Template tmpl = TemplateFactory.getTemplate(config, new FileInputStream(pathToTemplate), null);
            tl.set(tmpl);
            tmpl.setPath(pathToTemplate);
            existing.setBasicCode(tmpl.getBasicCode());
            return tmpl;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate template: " + pathToTemplate, e);
        }
    }
}

