/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.templating;

import com.sixtyfour.plugins.OutputChannel;
import com.sixtyfour.plugins.PrintConsumer;

public class TemplateOutputChannel
implements OutputChannel {
    private int cursor = 0;
    private int channel = 0;
    private PrintConsumer otherConsumer = null;
    private StringBuilder result = new StringBuilder();

    public void reset() {
        this.cursor = 0;
        this.channel = 0;
        this.otherConsumer = null;
        this.result.setLength(0);
    }

    @Override
    public void print(int id, String txt) {
        if (this.otherConsumer != null) {
            this.otherConsumer.print(this.channel, txt);
        } else {
            this.setCursor(this.getCursor() + txt.length());
            this.result.append(txt);
        }
    }

    @Override
    public void println(int id, String txt) {
        if (this.otherConsumer != null) {
            this.otherConsumer.println(this.channel, txt);
        } else {
            this.result.append(txt);
            this.result.append("\n");
            this.setCursor(0);
        }
    }

    @Override
    public int getCursor() {
        return this.cursor;
    }

    @Override
    public void setCursor(int cursor) {
        this.cursor = cursor;
    }

    @Override
    public void setPrintConsumer(PrintConsumer otherConsumer, int channel) {
        this.otherConsumer = otherConsumer;
        this.channel = channel;
    }

    @Override
    public PrintConsumer getPrintConsumer() {
        return this.otherConsumer;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    public String getResult() {
        return this.result.toString();
    }

    @Override
    public void systemPrint(int id, String txt) {
    }

    @Override
    public void systemPrintln(int id, String txt) {
    }
}

