/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.util;

import com.sixtyfour.Logger;
import com.sixtyfour.elements.Variable;
import com.sixtyfour.parser.Term;
import com.sixtyfour.system.Machine;
import com.sixtyfour.util.Jitted;
import com.sixtyfour.util.VarUtils;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class Jit {
    private StringBuilder code = new StringBuilder();
    private List<Term> jittedTerms = new ArrayList<Term>();
    private int compileThreshold = 0;
    private boolean failed = false;
    private List<Variable> vars = new ArrayList<Variable>();
    private static Object sync = new Object();
    private long lastAdd = 0L;
    private boolean compilerRunning = false;
    private static int id = 0;

    public Jit() {
        this(0);
    }

    public Jit(int compileThreshold) {
        this.compileThreshold = compileThreshold;
        this.initCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVariable(Variable var) {
        Object object = sync;
        synchronized (object) {
            if (this.compilerRunning) {
                return;
            }
            if (!this.vars.contains(var)) {
                this.vars.add(var);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addMethod(Term term, Machine machine) {
        Object object = sync;
        synchronized (object) {
            if (this.compilerRunning) {
                return false;
            }
        }
        if (!this.failed && !this.jittedTerms.contains(term)) {
            String cody = term.toCode(machine);
            if (cody == null || cody.length() < 80) {
                return true;
            }
            this.code.append("\npublic final Object m").append(term.getId()).append("() {").append("return ").append(cody.trim()).append(";}\n");
            this.jittedTerms.add(term);
            this.lastAdd = System.currentTimeMillis();
            if (this.compileThreshold > 0 && this.jittedTerms.size() > this.compileThreshold && !this.compilerRunning) {
                this.compile();
            }
        }
        return true;
    }

    public void autoCompile() {
        if (this.lastAdd > 0L && this.compileThreshold <= 0 && !this.failed && System.currentTimeMillis() - this.lastAdd >= 200L && !this.compilerRunning) {
            Logger.log("Auto-compilation triggered!");
            this.compile();
        }
    }

    public Object call(Term term) {
        Method m = term.getJittedMethod();
        if (m == null) {
            throw new RuntimeException("Internal JIT error: " + term);
        }
        try {
            return m.invoke((Object)term.getJittedInstance(), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Internal JIT error: " + term, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compile() {
        if (!this.failed) {
            Object object = sync;
            synchronized (object) {
                if (this.compilerRunning) {
                    return;
                }
                this.compilerRunning = true;
                Thread compileThread = new Thread(){

                    @Override
                    public void run() {
                        StringBuilder stringBuilder = new StringBuilder("JittedImpl");
                        int n = id;
                        id = n + 1;
                        String clazzName = stringBuilder.append(n).toString();
                        File sourceFile = null;
                        try {
                            long s = System.currentTimeMillis();
                            Logger.log("Running JIT-Compiler...");
                            Jit.this.code.append("}");
                            String source = Jit.this.code.toString();
                            StringBuilder varStr = new StringBuilder();
                            for (Variable var : Jit.this.vars) {
                                varStr.append("\npublic Variable ").append(VarUtils.relabel(var.getName())).append("=null;\n");
                            }
                            source = source.replace("[vars]", varStr.toString());
                            sourceFile = new File(String.valueOf(clazzName) + ".java");
                            Files.write(sourceFile.toPath(), source.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                            if (compiler == null) {
                                Logger.log("Unable to run JIT-Compiler! Please run this application using a JDK, not a JRE!");
                                Jit.this.failed = true;
                                return;
                            }
                            try {
                                compiler.run(null, null, null, sourceFile.getPath());
                                URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{new File(".").toURI().toURL()});
                                Class<?> cls = Class.forName(clazzName, true, classLoader);
                                Jitted jittedCode = (Jitted)cls.newInstance();
                                jittedCode.setVars(Jit.this.vars.toArray(new Variable[Jit.this.vars.size()]));
                                for (Variable var : Jit.this.vars) {
                                    jittedCode.getClass().getField(VarUtils.relabel(var.getName())).set(jittedCode, var);
                                }
                                Logger.log("JIT-Compiler executed in " + (System.currentTimeMillis() - s) + "ms, " + Jit.this.jittedTerms.size() + " methods compiled into " + clazzName + ".class!");
                                for (Term jittedTerm : Jit.this.jittedTerms) {
                                    try {
                                        jittedTerm.setJittedInstance(jittedCode);
                                        jittedTerm.setJittedMethod(jittedCode.getClass().getMethod("m" + jittedTerm.getId(), new Class[0]));
                                    }
                                    catch (Exception e) {
                                        throw new RuntimeException("Internal JIT error: " + jittedTerm, e);
                                    }
                                }
                            }
                            catch (Exception e) {
                                Logger.log("Failed to run JIT-Compiler!", e);
                                Jit.this.failed = true;
                            }
                        }
                        finally {
                            if (sourceFile != null) {
                                new File(String.valueOf(clazzName) + ".class").delete();
                                if (!sourceFile.delete()) {
                                    sourceFile.deleteOnExit();
                                    new File(String.valueOf(clazzName) + ".class").deleteOnExit();
                                }
                            }
                            Jit.this.initCode();
                            Jit.this.vars.clear();
                            Jit.this.jittedTerms.clear();
                            Jit.this.lastAdd = 0L;
                            Jit.this.compilerRunning = false;
                        }
                    }
                };
                compileThread.start();
            }
        }
    }

    private void initCode() {
        this.code.setLength(0);
        this.code.append("import com.sixtyfour.system.*; import com.sixtyfour.elements.*; \npublic class JittedImpl" + id + " implements com.sixtyfour.util.Jitted { private Variable[] vars; [vars] public JittedImpl" + id + "() {} \n public void setVars(Variable[] vars) {this.vars=vars;} ");
    }
}

