/*
 * Decompiled with CFR 0.152.
 */
package com.sixtyfour.util.rommap;

import com.sixtyfour.Loader;
import com.sixtyfour.Logger;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.util.rommap.MapLoader;
import com.sixtyfour.util.rommap.Mapping;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CallMapper {
    /*
     * WARNING - void declaration
     */
    public static Mapping mapCalls(CompilerConfig config, boolean verbose) {
        HashMap<String, String> mappedCalls = new HashMap<String, String>();
        Map<String, List<String>> c64 = MapLoader.getSymbolMapping(CallMapper.getStream("/rommap/rom-c64.txt"));
        Map<String, List<String>> x16 = null;
        if (config != null && config.getSymbolTable() != null && !config.getSymbolTable().isEmpty()) {
            Logger.log("Loading symbol table from file: " + config.getSymbolTable());
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (FileInputStream is = new FileInputStream(config.getSymbolTable());){
                    x16 = MapLoader.getSymbolMapping(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                Logger.log("Failed to load symbol table: " + e.getMessage());
                System.exit(15);
            }
        } else {
            x16 = MapLoader.getSymbolMapping(CallMapper.getStream("/rommap/basic-x16.txt"), CallMapper.getStream("/rommap/kernal-x16.txt"));
        }
        Map<String, String> calls = MapLoader.getRomCalls(CallMapper.class.getResourceAsStream("/rommap/runtime.map"));
        Map<String, String> fpLibCalls = MapLoader.getRomCalls(CallMapper.class.getResourceAsStream("/rommap/fplib-x16.txt"));
        HashMap<String, String> x16r = new HashMap<String, String>();
        ArrayList<String> redirs = new ArrayList<String>();
        String[] addAddrs = Loader.loadProgram(CallMapper.class.getResourceAsStream("/rommap/runtime_ext.lst"));
        for (Map.Entry<String, List<String>> entry : x16.entrySet()) {
            for (String label : entry.getValue()) {
                x16r.put(label, entry.getKey());
            }
        }
        Logger.log("Mapping runtime calls from c64 rom to x16 rom...");
        for (Map.Entry<String, Object> entry : calls.entrySet()) {
            String newAddr;
            int dif;
            String label;
            label = entry.getKey();
            String addr = (String)entry.getValue();
            boolean isKernalCall = CallMapper.isKernalCall(addr);
            String uLabel = label.toUpperCase(Locale.ENGLISH);
            List<String> matchys = c64.get(addr);
            String match = null;
            if (matchys != null && !matchys.isEmpty()) {
                match = matchys.get(0);
            }
            if (addr.startsWith("ff")) {
                if (verbose) {
                    Logger.log("Call to " + addr + " / " + label + " seems to be a ROM routine call. Using the same call in the target ROM!");
                }
                match = addr;
                x16r.put(addr, addr);
            }
            int add = 0;
            if (match == null) {
                int iaddr = Integer.parseInt(addr, 16);
                dif = 256;
                String closest = null;
                String claddr = null;
                for (String caddr : c64.keySet()) {
                    int ciaddr = Integer.parseInt(caddr, 16);
                    if (ciaddr >= iaddr || iaddr - ciaddr >= dif) continue;
                    dif = iaddr - ciaddr;
                    closest = null;
                    List<String> closs = c64.get(caddr);
                    if (closs != null && !closs.isEmpty()) {
                        closest = c64.get(caddr).get(0);
                    }
                    claddr = caddr;
                }
                if (closest != null) {
                    if (verbose) {
                        Logger.log("Closest match for " + addr + " / " + label + " in source rom is " + closest + " / " + claddr + " with a delta of " + dif);
                    }
                    match = closest;
                    add = dif;
                } else {
                    String msg = "!!! Failed to match call to " + addr + " / " + label;
                    Logger.log(msg);
                    throw new RuntimeException(msg);
                }
            }
            if ((newAddr = (String)x16r.get(match)) == null) {
                if (!verbose) continue;
                String err = "\n\n\nFailed to find symbol for " + label + ":  " + match + " in target rom\n\n\n\n";
                Logger.log(err);
                continue;
            }
            if (add != 0) {
                String poMatch;
                dif = add;
                if (verbose) {
                    Logger.log("Call to " + addr + " / " + label + " matches to " + match + " / " + newAddr + " + " + Integer.toHexString(dif) + " in target rom!");
                }
                if (fpLibCalls.containsKey(poMatch = match.replace(".", ""))) {
                    newAddr = fpLibCalls.get(poMatch);
                    dif = 0;
                    if (verbose) {
                        Logger.log("However, it's also part of the fpLib, so we use that instead and ignore the delta anyway: " + newAddr);
                    }
                }
                mappedCalls.put(uLabel, ("$" + Integer.toHexString(Integer.parseInt(newAddr, 16) + dif)).toUpperCase(Locale.ENGLISH));
            } else {
                String poMatch;
                if (verbose) {
                    Logger.log("Call to " + addr + " / " + label + " matches to " + match + " / " + newAddr + " in target rom!");
                }
                if (fpLibCalls.containsKey(poMatch = match.replace(".", ""))) {
                    newAddr = fpLibCalls.get(poMatch);
                    if (verbose) {
                        Logger.log("However, it's also part of the fpLib, so we use that instead: " + newAddr);
                    }
                }
                mappedCalls.put(uLabel, "$" + newAddr.toUpperCase(Locale.ENGLISH));
            }
            if (verbose) {
                Logger.log("---------------------------------------------------------");
            }
            if (CallMapper.isKernalCall(newAddr)) {
                newAddr = "0000";
                if (verbose) {
                    Logger.log("WARNING: Call to " + match + " / " + newAddr + " most likely requires a JSRFAR, but doesn't use one!");
                    String err = "\n\n\nFailed to properly map symbol for " + label + ":  " + match + " to target rom\n\n\n\n";
                    Logger.log(err);
                }
            }
            if (!isKernalCall) continue;
            CallMapper.addJarFar((String)mappedCalls.get(uLabel), redirs, uLabel);
            mappedCalls.remove(uLabel);
        }
        String[] stringArray = addAddrs;
        int n = addAddrs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.length() > 0) {
                void var10_21;
                boolean forceBank0 = false;
                if (string.startsWith("*")) {
                    forceBank0 = true;
                    String string2 = string.substring(1);
                }
                String[] parts = var10_21.split("\\+");
                int add = 0;
                if (parts.length == 2) {
                    add = Integer.valueOf(parts[1].trim());
                }
                String label = parts[0].trim().toLowerCase(Locale.ENGLISH);
                String uLabel = label.toUpperCase(Locale.ENGLISH);
                String addr = (String)x16r.get("." + label);
                if (addr == null) {
                    String msg = "!!! Failed to match additional address " + parts[0];
                    Logger.log(msg);
                    throw new RuntimeException(msg);
                }
                String val = "$" + Integer.toHexString(add += Integer.parseInt(addr, 16)).toUpperCase(Locale.ENGLISH);
                if (fpLibCalls.containsKey(label)) {
                    val = fpLibCalls.get(label);
                    if (verbose) {
                        Logger.log(String.valueOf(label) + " is part of the fpLib, so we use that and ignore the delta: " + val);
                    }
                    val = "$" + val.toUpperCase(Locale.ENGLISH);
                    mappedCalls.put(uLabel, val);
                } else if (!CallMapper.isKernalCall(add) || forceBank0) {
                    mappedCalls.put(uLabel, val);
                } else {
                    CallMapper.addJarFar(val, redirs, uLabel);
                }
                if (verbose) {
                    Logger.log("Call to " + parts[0] + " matches to " + val + " in target rom!");
                }
            }
            ++n2;
        }
        Mapping mapping = new Mapping();
        mapping.setMap(mappedCalls);
        mapping.setFarCalls(redirs);
        return mapping;
    }

    private static InputStream getStream(String name) {
        return CallMapper.class.getResourceAsStream(name);
    }

    private static void addJarFar(String addr, List<String> redirs, String uLabel) {
        redirs.add(String.valueOf(uLabel) + ":");
        redirs.add("JSR JSRFAR");
        redirs.add(".WORD " + addr);
        redirs.add(".BYTE 0");
        redirs.add("RTS");
        redirs.add(";###################################");
    }

    private static boolean isKernalCall(String addr) {
        int addri = Integer.parseInt(addr, 16);
        return addri >= 58624 && addri < 64512;
    }

    private static boolean isKernalCall(int addri) {
        return addri >= 58624 && addri < 64512;
    }
}

