/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.errors.printers;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import kickass.common.errors.AsmError;
import kickass.common.errors.printers.IErrorPrinter;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.CallStack;
import kickass.state.EvaluationState;

public class StackTraceErrorPrinter
implements IErrorPrinter {
    public static final StackTraceErrorPrinter instance = new StackTraceErrorPrinter();

    private StackTraceErrorPrinter() {
    }

    @Override
    public String printError(AsmError asmError, EvaluationState evaluationState) {
        String string = System.getProperties().getProperty("line.separator");
        CallStack callStack = asmError.getCallStack();
        if (asmError.getRange() == null) {
            return "Error: " + asmError.getMessage() + string;
        }
        String string2 = callStack == null ? "" : this.getTrace(asmError, evaluationState);
        return this.getMarkedErrorLine(asmError, evaluationState) + string + "Error: " + asmError.getMessage() + string + string2 + string;
    }

    public String getMarkedErrorLine(AsmError asmError, EvaluationState evaluationState) {
        SourceRange sourceRange = asmError.getRange();
        int n = sourceRange.getStartLineNo();
        int n2 = sourceRange.getStartLinePos();
        String string = sourceRange.getFileName();
        String string2 = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.removeTabs(this.getLinesInFile(n - 4, n - 2, string, evaluationState)));
        if (sourceRange.isEof()) {
            if (n2 > 1) {
                stringBuffer.append(this.removeTabs(this.getLinesInFile(n - 1, n - 1, string, evaluationState, false)));
            }
            stringBuffer.append("<EOF>" + string2);
            this.markColumn(stringBuffer, n2, string2);
        } else if (n2 < 0) {
            stringBuffer.append(">>>");
            stringBuffer.append(this.removeTabs(this.getLinesInFile(n - 1, n - 1, string, evaluationState)));
        } else {
            stringBuffer.append(this.removeTabs(this.getLinesInFile(n - 1, n - 1, string, evaluationState)));
            this.markColumn(stringBuffer, n2, string2);
        }
        return stringBuffer.toString();
    }

    private void markColumn(StringBuffer stringBuffer, int n, String string) {
        for (int i = 0; i < n - 1; ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append('^' + string);
    }

    private String getLinesInFile(int n, int n2, String string, EvaluationState evaluationState) {
        return this.getLinesInFile(n, n2, string, evaluationState, true);
    }

    private String getLinesInFile(int n, int n2, String string, EvaluationState evaluationState, boolean bl) {
        String string2 = System.getProperties().getProperty("line.separator");
        try {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            FileInputStream fileInputStream = new FileInputStream(evaluationState.fileMgr.getFile(string, false));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            for (n3 = 0; n3 < n; ++n3) {
                bufferedReader.readLine();
            }
            while (n3 <= n2) {
                boolean bl2;
                stringBuffer.append(bufferedReader.readLine());
                boolean bl3 = bl2 = n3 != n2 || bl;
                if (bl2) {
                    stringBuffer.append(string2);
                }
                ++n3;
            }
            bufferedReader.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Error - End of file reached";
        }
    }

    private String removeTabs(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\t') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public String getPositionString(SourceRange sourceRange, EvaluationState evaluationState) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = sourceRange.getStartLineNo();
        int n2 = sourceRange.getStartLinePos();
        if (n >= 0) {
            stringBuffer.append("at line " + n);
            if (n2 >= 0) {
                stringBuffer.append(", column " + n2 + " ");
            }
        }
        if (sourceRange.getFileName() != null) {
            stringBuffer.append("in " + this.formatFilename(sourceRange.getFileName(), evaluationState));
        }
        return stringBuffer.toString();
    }

    private String formatFilename(String string, EvaluationState evaluationState) {
        String string2 = evaluationState.fileMgr.getCurrentDirectory().getAbsolutePath();
        if (string.startsWith(string2)) {
            string = string.substring(string2.length() + 1);
        }
        return string;
    }

    private String getTrace(AsmError asmError, EvaluationState evaluationState) {
        int n;
        String string = System.getProperties().getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getPositionString(asmError.getRange(), evaluationState));
        stringBuffer.append(string);
        CallStack callStack = asmError.getCallStack();
        for (int i = n = callStack.getStackSize() - 1; i >= 0; --i) {
            stringBuffer.append("called ");
            stringBuffer.append(this.getPositionString(callStack.getRange(i), evaluationState));
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

