/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.output.D64Image;
import kickass.nonasm.tools.EnumUtil;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.state.EvaluationState;
import kickass.state.segments.D64Disk;
import kickass.state.segments.D64File;

public class DiskDirective
extends Directive {
    private static final String diskparam_filename = "filename";
    private static final String diskparam_name = "name";
    private static final String diskparam_id = "id";
    private static final String diskparam_format = "format";
    private static final String diskparam_splitFilesOverDir = "splitFilesOverDir";
    private static final String diskparam_storeFilesInDir = "storeFilesInDir";
    private static final String diskparam_interleave = "interleave";
    private static final Set<String> allDiskParameters = new HashSet<String>(Arrays.asList("filename", "name", "id", "format", "splitFilesOverDir", "storeFilesInDir", "interleave"));
    private static final String fileparam_name = "name";
    private static final String fileparam_type = "type";
    private static final String fileparam_interleave = "interleave";
    private static final String fileparam_visible = "visible";
    private static final String fileparam_segments = "segments";
    private static final String fileparam_prgfile = "prgFile";
    private static final Set<String> allFileParameters = new HashSet<String>(Arrays.asList("name", "type", "segments", "prgFile", "visible", "interleave"));
    private ParameterMap diskParameters;
    private List<ParameterMap> fileParameters;

    public DiskDirective(ParameterMap parameterMap, List<ParameterMap> list, SourceRange sourceRange) {
        super(sourceRange);
        this.diskParameters = parameterMap;
        this.fileParameters = list;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.diskParameters.addErrorIfNotExist(diskparam_filename, evaluationState);
        this.diskParameters.addErrorsForUnknownParameres(allDiskParameters, evaluationState);
        this.diskParameters.executePrepass(evaluationState);
        for (ParameterMap parameterMap : this.fileParameters) {
            parameterMap.addErrorsForUnknownParameres(allFileParameters, evaluationState);
            parameterMap.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        boolean bl = this.diskParameters.evaluateAllParameters(evaluationState);
        for (ParameterMap parameterMap : this.fileParameters) {
            boolean bl2 = parameterMap.evaluateAllParameters(evaluationState);
            bl &= bl2;
        }
        if (!bl) {
            return this;
        }
        D64Disk d64Disk = new D64Disk(this.diskParameters.getStringValue(diskparam_filename));
        d64Disk.setDiskName(this.diskParameters.getStringValue("name", "UNNAMED"));
        d64Disk.setDiskId(this.diskParameters.getStringValue(diskparam_id, "   2A"));
        d64Disk.setFormat(this.diskParameters.getEnumValue(D64Image.Format.class, diskparam_format, D64Image.Format.COMMODORE));
        d64Disk.setSplitFilesOverDirectory(this.diskParameters.getBoolValue(diskparam_splitFilesOverDir, true));
        d64Disk.setStoreFilesInDirectory(this.diskParameters.getBoolValue(diskparam_storeFilesInDir, false));
        int n = this.diskParameters.getIntValue("interleave", 10);
        for (ParameterMap parameterMap : this.fileParameters) {
            D64Image.FileType fileType;
            Object object;
            D64File d64File = new D64File();
            d64Disk.addFile(d64File);
            d64File.setFilename(parameterMap.getStringValue("name", ""));
            d64File.setVisible(parameterMap.getBoolValue(fileparam_visible, true));
            d64File.setInterleave(parameterMap.getIntValue("interleave", n));
            if (d64File.getInterleave() < 0) {
                parameterMap.throwParameterException("interleave", "Interleave can't be negative: " + d64File.getInterleave());
            }
            d64File.setSourcePrgFile(parameterMap.getStringValue(fileparam_prgfile, null));
            if (parameterMap.exist(fileparam_segments)) {
                object = parameterMap.getStringValue(fileparam_segments).split(",");
                d64File.setSourceSegment(object[0]);
            }
            object = parameterMap.getStringValue(fileparam_type, D64Image.FileType.PRG.toString());
            d64File.setLocked(false);
            if (((String)object).endsWith("<")) {
                d64File.setLocked(true);
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if ((fileType = EnumUtil.get(D64Image.FileType.class, (String)object)) == null) {
                throw new AsmErrorException("Unknown type: " + (String)object, parameterMap.getNameRange("name"));
            }
            d64File.setType(fileType);
        }
        evaluationState.segmentMgr.addD64Disk(d64Disk);
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

