/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.io.InputStream;
import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.ByteOutput;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ImportBinaryDirective
extends AsmDirective {
    private boolean isC64File;
    private List<ExprNode> argumentExprs;

    public ImportBinaryDirective(boolean bl, List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.isC64File = bl;
        this.argumentExprs = list;
    }

    @Override
    public Directive copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.argumentExprs.size() < 1 || 3 < this.argumentExprs.size()) {
            evaluationState.errorMgr.addError(new AsmError("Invalid number of arguments.", this.range));
            return EmptyOutput.instance;
        }
        for (ExprNode exprNode : this.argumentExprs) {
            exprNode.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Object object;
        Object object2;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.argumentExprs.get(0).evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("Must be able to solve filename during first pass", this.range);
        }
        String string = value.getString(this.range);
        Integer n = null;
        if (this.argumentExprs.size() >= 2) {
            object2 = this.argumentExprs.get(1).evaluate(evaluationState);
            if (((Value)object2).isInvalid()) {
                throw new AsmErrorException("Must be able to solve offset argument during first pass", this.range);
            }
            n = ((Value)object2).getInt(this.range);
            if (n < 0) {
                throw new AsmErrorException("Offset can't be negative", this.range);
            }
        }
        object2 = null;
        if (this.argumentExprs.size() >= 3) {
            object = this.argumentExprs.get(2).evaluate(evaluationState);
            if (((Value)object).isInvalid()) {
                throw new AsmErrorException("Must be able to solve length argument during first pass", this.range);
            }
            object2 = ((Value)object).getInt(this.range);
            if ((Integer)object2 < 0) {
                throw new AsmErrorException("Length can't be negative", this.range);
            }
        }
        object = evaluationState.fileMgr.openFileOrFail(string, false, this.range);
        int n2 = 0;
        int n3 = 65536;
        byte[] byArray = new byte[n3];
        try {
            if (this.isC64File) {
                ((InputStream)object).read(byArray, 0, 2);
            }
            if (n != null) {
                ((InputStream)object).read(byArray, 0, n);
            }
            if (object2 != null) {
                n3 = (Integer)object2;
            }
            n2 = ((InputStream)object).read(byArray, 0, n3);
        }
        catch (Exception exception) {
            throw new AsmErrorException("Can't read file: " + string, this.range);
        }
        finally {
            try {
                ((InputStream)object).close();
            }
            catch (Exception exception) {}
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (object2 != null && n2 < (Integer)object2) {
            throw new AsmErrorException("File is too short for the desired length", this.range);
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = byArray[i];
        }
        evaluationState.segmentMgr.increaseMemoryPosition(byArray2.length);
        return new ByteOutput(byArray2, this.range, evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

