/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.values;

import kickass.nonasm.util.functions.Func0;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.table.FunctionTable;
import kickass.pass.valueholder.ConstantValueHolder;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.valuerep.ValueRepresentation;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.pass.values.ZpNumberValue;
import kickass.state.EvaluationState;
import kickass.state.scope.symboltable.ISymbolInitializer;

public class LabelValue
extends Value {
    public static final ISymbolInitializer stdInitializer = iValueHolderArray -> new ConstantValueHolder(new LabelValue(null, false));
    public static final ISymbolInitializer zpInitializer = iValueHolderArray -> new ConstantValueHolder(new LabelValue(null, true));
    private Value numberValue = NumberValue.invalid;
    private Value connectedValue = null;

    public static ISymbolInitializer getInitializer(EvaluationState evaluationState) {
        return evaluationState.getZeropageFlag() ? zpInitializer : stdInitializer;
    }

    public static ISymbolInitializer getInitializer(EvaluationState evaluationState, Func0<Value> func0) {
        if (evaluationState.getZeropageFlag()) {
            return iValueHolderArray -> new ConstantValueHolder(new LabelValue((Value)func0.apply(), true));
        }
        return iValueHolderArray -> new ConstantValueHolder(new LabelValue((Value)func0.apply(), false));
    }

    public LabelValue(Value value, boolean bl) {
        this.connectedValue = value;
        this.numberValue = bl ? ZpNumberValue.invalid : NumberValue.invalid;
    }

    public void resolveLabel(Value value) {
        this.numberValue = value;
    }

    public Value getConnectedValue() {
        return this.connectedValue;
    }

    @Override
    public void lock(SourceRange sourceRange) {
    }

    @Override
    public boolean isLocked() {
        return true;
    }

    @Override
    public String getType() {
        return "LabelValue";
    }

    @Override
    protected IValueHolder localGetVariable(String string, SourceRange sourceRange) {
        if (this.connectedValue == null) {
            return null;
        }
        return this.connectedValue.localGetVariable(string, sourceRange);
    }

    @Override
    public Value operatorIndex(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        if (this.connectedValue == null) {
            super.operatorIndex(value, evaluationState, sourceRange);
        }
        return this.connectedValue.operatorIndex(value, evaluationState, sourceRange);
    }

    @Override
    public FunctionTable getFunctions() {
        return this.numberValue.getFunctions();
    }

    @Override
    public Object getRepresentation(ValueRepresentation valueRepresentation) {
        return this.numberValue.getRepresentation(valueRepresentation);
    }

    @Override
    public boolean hasRepresentation(ValueRepresentation valueRepresentation) {
        return this.numberValue.hasRepresentation(valueRepresentation);
    }

    @Override
    public boolean hasString() {
        return this.numberValue.hasString();
    }

    @Override
    public String getString(SourceRange sourceRange) {
        return this.numberValue.getString(sourceRange);
    }

    @Override
    public boolean hasBoolean() {
        return this.numberValue.hasBoolean();
    }

    @Override
    public boolean getBoolean(SourceRange sourceRange) {
        return this.numberValue.getBoolean(sourceRange);
    }

    @Override
    public double getDouble(SourceRange sourceRange) {
        return this.numberValue.getDouble(sourceRange);
    }

    @Override
    public boolean hasDouble() {
        return this.numberValue.hasDouble();
    }

    @Override
    public boolean isInvalid() {
        return this.numberValue.isInvalid();
    }

    @Override
    public boolean hasInvalidContent() {
        return this.numberValue.hasInvalidContent();
    }

    @Override
    public boolean isZeropageBound() {
        return this.numberValue.isZeropageBound();
    }
}

