/*
 * Decompiled with CFR 0.152.
 */
package kickass.setup;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import kickass._65xx._65xxArgType;
import kickass._65xx._65xxMnemonicNode;
import kickass._65xx._65xxMnemonics;
import kickass.nonasm.tools.tuples.Pair;
import kickass.nonasm.tools.tuples.Triple;
import kickass.nonasm.util.functions.Func5;
import kickass.parsing.baselang.BaseLangLexer;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.PeakTokenStream;
import kickass.parsing.baselang.tokenstreams.RangeProcessor;
import kickass.parsing.baselang.tokenstreams.WhiteSpaceSimplifierStream;
import kickass.parsing.functionparse.FunctionDirectiveParser;
import kickass.parsing.mainparse.IDirectiveParser;
import kickass.parsing.mainparse.MainParser;
import kickass.parsing.mainparse.tailparsers.AssertErrorTailParser;
import kickass.parsing.mainparse.tailparsers.AssertTailParser;
import kickass.parsing.mainparse.tailparsers.AssignmentTailParser;
import kickass.parsing.mainparse.tailparsers.BodyTailParser;
import kickass.parsing.mainparse.tailparsers.EnumTailParser;
import kickass.parsing.mainparse.tailparsers.ExprBodyParser;
import kickass.parsing.mainparse.tailparsers.ExprBodyTailParser;
import kickass.parsing.mainparse.tailparsers.ExprIdIdTailParser;
import kickass.parsing.mainparse.tailparsers.ExprListTailParser;
import kickass.parsing.mainparse.tailparsers.ExprTailParser;
import kickass.parsing.mainparse.tailparsers.FilemodifyTailParser;
import kickass.parsing.mainparse.tailparsers.ForTailParser;
import kickass.parsing.mainparse.tailparsers.FunctionModeTailParser;
import kickass.parsing.mainparse.tailparsers.IdArgsBodyTailParser;
import kickass.parsing.mainparse.tailparsers.IdArgsexprsBodyTailParser;
import kickass.parsing.mainparse.tailparsers.IdBodyTailParser;
import kickass.parsing.mainparse.tailparsers.IdFilebodyTailParser;
import kickass.parsing.mainparse.tailparsers.IdsBodyTailParser;
import kickass.parsing.mainparse.tailparsers.IfTailParser;
import kickass.parsing.mainparse.tailparsers.ImportTailParser;
import kickass.parsing.mainparse.tailparsers.LabelAssignmentTailParser;
import kickass.parsing.mainparse.tailparsers.NoArgBodyParser;
import kickass.parsing.mainparse.tailparsers.ParamMapParamMapListTailParser;
import kickass.parsing.mainparse.tailparsers.ParamMapTailParser;
import kickass.parsing.mainparse.tailparsers.ParanExprBodyTailParser;
import kickass.parsing.mainparse.tailparsers.PcBodyParser;
import kickass.parsing.mainparse.tailparsers.SegmentTailParser;
import kickass.parsing.mainparse.tailparsers.StmtBodyParser;
import kickass.parsing.mainparse.tailparsers.StringBodyParser;
import kickass.parsing.mainparse.tailparsers.StructBodyParser;
import kickass.parsing.mainparse.tailparsers._65xxMnemonicTailParser;
import kickass.parsing.mainparse.tailparsers._65xxPseudoCmdDefTailParser;
import kickass.parsing.mainparse.tailparsers._65xxPseudoCmdTailParser;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.preprocessor.PreProcessor;
import kickass.parsing.preprocessor.directives.PpdDefine;
import kickass.parsing.preprocessor.directives.PpdElif;
import kickass.parsing.preprocessor.directives.PpdElse;
import kickass.parsing.preprocessor.directives.PpdEndif;
import kickass.parsing.preprocessor.directives.PpdIf;
import kickass.parsing.preprocessor.directives.PpdImport;
import kickass.parsing.preprocessor.directives.PpdImportIf;
import kickass.parsing.preprocessor.directives.PpdImportOnce;
import kickass.parsing.preprocessor.directives.PpdUndef;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AlignDirective;
import kickass.pass.asmnode.directives.AssertCodeDirective;
import kickass.pass.asmnode.directives.AssertDirective;
import kickass.pass.asmnode.directives.AssertErrorCodeDirective;
import kickass.pass.asmnode.directives.AssertErrorDirective;
import kickass.pass.asmnode.directives.AssertSegmentDirective;
import kickass.pass.asmnode.directives.BracketScopeDirective;
import kickass.pass.asmnode.directives.DataBlockDirective;
import kickass.pass.asmnode.directives.DefineDirective;
import kickass.pass.asmnode.directives.DiskDirective;
import kickass.pass.asmnode.directives.EasterEggDirective;
import kickass.pass.asmnode.directives.EncodingDirective;
import kickass.pass.asmnode.directives.EnumDirective;
import kickass.pass.asmnode.directives.ErrorDirective;
import kickass.pass.asmnode.directives.ErrorIfDirective;
import kickass.pass.asmnode.directives.EvalDirective;
import kickass.pass.asmnode.directives.FileDirective;
import kickass.pass.asmnode.directives.FillDirective;
import kickass.pass.asmnode.directives.ForDirective;
import kickass.pass.asmnode.directives.FunctionDeclarationDirective;
import kickass.pass.asmnode.directives.IfDirective;
import kickass.pass.asmnode.directives.ImportBinaryDirective;
import kickass.pass.asmnode.directives.ImportOnceDirective;
import kickass.pass.asmnode.directives.ImportSourceDirective;
import kickass.pass.asmnode.directives.ImportTextDirective;
import kickass.pass.asmnode.directives.LabelAssignmentDirective;
import kickass.pass.asmnode.directives.LabelDirective;
import kickass.pass.asmnode.directives.MacroDefinition;
import kickass.pass.asmnode.directives.MacroExecution;
import kickass.pass.asmnode.directives.MemoryBlockDirective;
import kickass.pass.asmnode.directives.ModifyDirective;
import kickass.pass.asmnode.directives.MultiLabelDirective;
import kickass.pass.asmnode.directives.NamespaceDirective;
import kickass.pass.asmnode.directives.PluginDirective;
import kickass.pass.asmnode.directives.PrintDirective;
import kickass.pass.asmnode.directives.PrintNowDirective;
import kickass.pass.asmnode.directives.PseudoCommandDefinition;
import kickass.pass.asmnode.directives.PseudoCommandExecution;
import kickass.pass.asmnode.directives.PseudoPCDirective;
import kickass.pass.asmnode.directives.SegmentDefDirective;
import kickass.pass.asmnode.directives.SegmentDirective;
import kickass.pass.asmnode.directives.SoftMemoryBlock;
import kickass.pass.asmnode.directives.StructDirective;
import kickass.pass.asmnode.directives.TextBlockDirective;
import kickass.pass.asmnode.directives.ZpDirective;
import kickass.pass.asmnode.metanodes.AsmNodeList;
import kickass.pass.asmnode.metanodes.AsmNodePair;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.stmt.ConstDeclaration;
import kickass.pass.expressions.stmt.StmtNode;
import kickass.pass.expressions.stmt.VariableDeclaration;
import kickass.pass.functionnode.AssertFDirective;
import kickass.pass.functionnode.BracketScopeFDirective;
import kickass.pass.functionnode.ErrorFDirective;
import kickass.pass.functionnode.ErrorIfFDirective;
import kickass.pass.functionnode.EvalFDirective;
import kickass.pass.functionnode.ForFDirective;
import kickass.pass.functionnode.FunctionNode;
import kickass.pass.functionnode.FunctionNodeList;
import kickass.pass.functionnode.IfFDirective;
import kickass.pass.functionnode.PrintFDirective;
import kickass.pass.functionnode.PrintNowFDirective;
import kickass.pass.functionnode.ReturnFDirective;
import kickass.setup.configuration.parameters.KickAssemblerParameters;
import kickass.state.EvaluationState;
import kickass.state.libraries.ILibrary;
import kickass.state.libraries.MathLibrary;
import kickass.state.libraries.MiscLibrary;
import kickass.state.libraries.MnemonicsLibrary;
import kickass.state.libraries.PrintLibrary;
import kickass.state.libraries.StdConstructorLibrary;
import kickass.state.libraries.VectorLibrary;
import kickass.state.scope.ExecutableDirectives;

public class KickAssemblerSetup {
    public static List<ILibrary> getStdLibararies() {
        ArrayList<ILibrary> arrayList = new ArrayList<ILibrary>();
        arrayList.add(new MathLibrary());
        arrayList.add(new PrintLibrary());
        arrayList.add(new VectorLibrary());
        arrayList.add(new StdConstructorLibrary());
        arrayList.add(new MiscLibrary());
        arrayList.add(new MnemonicsLibrary());
        return arrayList;
    }

    public static ITokenStream getLexer(String string, Reader reader, EvaluationState evaluationState) {
        ITokenStream iTokenStream = KickAssemblerSetup.createPreprocessor(string, reader, evaluationState);
        iTokenStream = new RangeProcessor(iTokenStream, evaluationState);
        iTokenStream = new PeakTokenStream(iTokenStream);
        return iTokenStream;
    }

    public static PreProcessor createPreprocessor(String string, Reader reader, EvaluationState evaluationState) {
        BaseLangLexer baseLangLexer = new BaseLangLexer(reader);
        baseLangLexer.setFilename(string);
        baseLangLexer.setState(evaluationState);
        WhiteSpaceSimplifierStream whiteSpaceSimplifierStream = new WhiteSpaceSimplifierStream(baseLangLexer);
        PreProcessor preProcessor = new PreProcessor(whiteSpaceSimplifierStream, evaluationState);
        preProcessor.addDirective("#define", new PpdDefine(preProcessor));
        preProcessor.addDirective("#if", new PpdIf(preProcessor));
        preProcessor.addDirective("#else", new PpdElse(preProcessor));
        preProcessor.addDirective("#elif", new PpdElif(preProcessor));
        preProcessor.addDirective("#endif", new PpdEndif(preProcessor));
        preProcessor.addDirective("#undef", new PpdUndef(preProcessor));
        preProcessor.addDirective("#import", new PpdImport(preProcessor));
        preProcessor.addDirective("#importif", new PpdImportIf(preProcessor));
        preProcessor.addDirective("#importonce", new PpdImportOnce(preProcessor));
        return preProcessor;
    }

    public static IDirectiveParser<AsmNode> getMainParser(EvaluationState evaluationState) {
        IDirectiveParser<FunctionNode> iDirectiveParser = KickAssemblerSetup.getFunctionParser(evaluationState);
        KickAssemblerParameters kickAssemblerParameters = evaluationState.parameters;
        MainParser mainParser = new MainParser();
        MainParser mainParser2 = new MainParser();
        mainParser.setScopeNodeCreator(list -> new AsmNodeList((List<AsmNode>)list));
        mainParser.setMacroExecNodeCreator((string, list, sourceRange) -> new MacroExecution((String)string, (List<ExprNode>)list, (SourceRange)sourceRange));
        mainParser.setPseudoCmdExecNodeCreator(new _65xxPseudoCmdTailParser((string, list, sourceRange) -> new PseudoCommandExecution((String)string, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".filenamespace", new IdFilebodyTailParser<AsmNode>(mainParser, (string, list, sourceRange) -> new NamespaceDirective(new AsmNodeList((List<AsmNode>)list), (String)string, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".importonce", new NoArgBodyParser(sourceRange -> new ImportOnceDirective((SourceRange)sourceRange)));
        mainParser.addSubPaser(".filemodify", new FilemodifyTailParser(mainParser, (string, list, list2, sourceRange) -> new ModifyDirective((String)string, (List<ExprNode>)list, new AsmNodeList((List<AsmNode>)list2), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".easteregg", new NoArgBodyParser(sourceRange -> new EasterEggDirective((SourceRange)sourceRange)));
        mainParser.addSubPaser(".segment", new SegmentTailParser<AsmNode>(false, (string, exprNode, parameterMap, sourceRange) -> {
            SegmentDirective segmentDirective = new SegmentDirective((String)string, (ExprNode)exprNode, (SourceRange)sourceRange);
            if (parameterMap != null) {
                return new AsmNodePair(new SegmentDefDirective(true, (String)string, (ParameterMap)parameterMap, (SourceRange)sourceRange), segmentDirective);
            }
            return segmentDirective;
        }));
        mainParser.addSubPaser(".segmentdef", new SegmentTailParser<AsmNode>(true, (string, exprNode, parameterMap, sourceRange) -> new SegmentDefDirective(true, (String)string, (ParameterMap)parameterMap, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".memblock", new ExprTailParser<AsmNode>((exprNode, sourceRange) -> new SoftMemoryBlock((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".file", new ParamMapTailParser<AsmNode>((parameterMap, sourceRange) -> new FileDirective((ParameterMap)parameterMap, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".disk", new ParamMapParamMapListTailParser<AsmNode>((parameterMap, list, sourceRange) -> new DiskDirective((ParameterMap)parameterMap, (List<ParameterMap>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".zp", new BodyTailParser<AsmNode>(mainParser, (list, sourceRange) -> new ZpDirective(new AsmNodeList((List<AsmNode>)list), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".align", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new AlignDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".encoding", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new EncodingDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".text", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new TextBlockDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".te", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new TextBlockDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".eval", new StmtBodyParser<AsmNode>((stmtNode, sourceRange) -> new EvalDirective((StmtNode)stmtNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".error", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new ErrorDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".errorif", new ExprListTailParser<AsmNode>((list, sourceRange) -> new ErrorIfDirective((List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".print", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new PrintDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".printnow", new ExprBodyParser<AsmNode>((exprNode, sourceRange) -> new PrintNowDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".pseudopc", new ExprBodyTailParser<AsmNode>(mainParser, (exprNode, list, sourceRange) -> new PseudoPCDirective((ExprNode)exprNode, new AsmNodeList((List<AsmNode>)list), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".namespace", new IdBodyTailParser<AsmNode>(mainParser, (string, list, sourceRange) -> new NamespaceDirective(new AsmNodeList((List<AsmNode>)list), (String)string, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".byte", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(1, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".by", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(1, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".word", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(2, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".wo", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(2, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".dword", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(4, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".dw", new ExprListTailParser<AsmNode>((list, sourceRange) -> new DataBlockDirective(4, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".fill", new ExprListTailParser<AsmNode>((list, sourceRange) -> new FillDirective((List<ExprNode>)list, (SourceRange)sourceRange)).setFixedNoOfArgs(2));
        mainParser.addSubPaser(".struct", new StructBodyParser((string, list, sourceRange) -> new StructDirective((String)string, (List<String>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".label", new LabelAssignmentTailParser((iToken, iToken2, exprNode, sourceRange) -> new LabelAssignmentDirective(iToken.getStringValue(), (ExprNode)exprNode, iToken.getSourceRange())));
        mainParser.addSubPaser(".const", new AssignmentTailParser<AsmNode>((iToken, iToken2, exprNode, sourceRange) -> new EvalDirective(new ConstDeclaration(iToken.getStringValue(), (ExprNode)exprNode, false, iToken.getSourceRange()), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".enum", new EnumTailParser((string, list, sourceRange) -> new EnumDirective((List<Triple<String, SourceRange, ExprNode>>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".var", new AssignmentTailParser<AsmNode>((iToken, iToken2, exprNode, sourceRange) -> new EvalDirective(new VariableDeclaration(iToken.getStringValue(), (ExprNode)exprNode, false, iToken.getSourceRange()), (SourceRange)sourceRange)).setAssignmentIsOptional(true));
        mainParser.addSubPaser(".import", new ImportTailParser().addType("source", (list, sourceRange) -> new ImportSourceDirective((List<ExprNode>)list, (SourceRange)sourceRange)).addType("text", (list, sourceRange) -> new ImportTextDirective((List<ExprNode>)list, (SourceRange)sourceRange)).addType("binary", (list, sourceRange) -> new ImportBinaryDirective(false, (List<ExprNode>)list, (SourceRange)sourceRange)).addType("c64", (list, sourceRange) -> new ImportBinaryDirective(true, (List<ExprNode>)list, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".plugin", new StringBodyParser<AsmNode>((string, sourceRange) -> new PluginDirective((String)string, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".assert", new AssertTailParser<AsmNode>(mainParser2, (exprNode, exprNode2, exprNode3, sourceRange) -> new AssertDirective((ExprNode)exprNode, (ExprNode)exprNode2, (ExprNode)exprNode3, (SourceRange)sourceRange), (exprNode, asmNode, asmNode2, sourceRange) -> new AssertCodeDirective((ExprNode)exprNode, (AsmNode)asmNode, (AsmNode)asmNode2, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".asserterror", new AssertErrorTailParser(mainParser2, (exprNode, exprNode2, sourceRange) -> new AssertErrorDirective((ExprNode)exprNode, (ExprNode)exprNode2, (SourceRange)sourceRange), (exprNode, asmNode, sourceRange) -> new AssertErrorCodeDirective((ExprNode)exprNode, (AsmNode)asmNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".assertsegment", new ExprIdIdTailParser<AsmNode>((exprNode, string, string2, sourceRange) -> new AssertSegmentDirective((ExprNode)exprNode, (String)string, (String)string2, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".define", new FunctionModeTailParser(new IdsBodyTailParser<AsmNode, FunctionNode>(iDirectiveParser, (list, list2, sourceRange) -> new DefineDirective((List<String>)list, new FunctionNodeList((List<FunctionNode>)list2), (SourceRange)sourceRange))));
        mainParser.addSubPaser(".modify", new IdArgsexprsBodyTailParser<AsmNode>(mainParser, (string, list, list2, sourceRange) -> new ModifyDirective((String)string, (List<ExprNode>)list, new AsmNodeList((List<AsmNode>)list2), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".macro", new IdArgsBodyTailParser<AsmNode>(mainParser, (string, list, list2, sourceRange) -> new MacroDefinition((String)string, (List<String>)list, (List<AsmNode>)list2, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".pseudocommand", new _65xxPseudoCmdDefTailParser(mainParser, (string, executableDirectives, sourceRange) -> new PseudoCommandDefinition((String)string, (ExecutableDirectives)executableDirectives, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".function", new FunctionModeTailParser(new IdArgsBodyTailParser<FunctionNode>(iDirectiveParser, (string, list, list2, sourceRange) -> new FunctionDeclarationDirective((String)string, (List<String>)list, (List<FunctionNode>)list2, (SourceRange)sourceRange))));
        mainParser.addSubPaser(".if", new IfTailParser<AsmNode>(mainParser2, (exprNode, asmNode, asmNode2, sourceRange) -> new IfDirective((ExprNode)exprNode, (AsmNode)asmNode, (AsmNode)asmNode2, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".for", new ForTailParser<AsmNode>(mainParser2, (list, exprNode, list2, asmNode, sourceRange) -> new ForDirective((List<StmtNode>)list, (ExprNode)exprNode, (List<ExprNode>)list2, (AsmNode)asmNode, (SourceRange)sourceRange)));
        mainParser.addSubPaser(".while", new ParanExprBodyTailParser<AsmNode>(mainParser, (exprNode, list, sourceRange) -> new ForDirective(StmtNode.emptyList, (ExprNode)exprNode, ExprNode.emptyList, new AsmNodeList((List<AsmNode>)list), (SourceRange)sourceRange)));
        mainParser.addSubPaser(".pc", new PcBodyParser((exprNode, string, bl, sourceRange) -> new MemoryBlockDirective((ExprNode)exprNode, (String)string, (Boolean)bl, (SourceRange)sourceRange)));
        mainParser.setStarParser(new PcBodyParser((exprNode, string, bl, sourceRange) -> new MemoryBlockDirective((ExprNode)exprNode, (String)string, (Boolean)bl, (SourceRange)sourceRange)));
        mainParser.setLabelCreator((string, sourceRange) -> new LabelDirective((String)string, (SourceRange)sourceRange));
        mainParser.setMultiLabelCreator((string, sourceRange) -> new MultiLabelDirective((String)string, (SourceRange)sourceRange));
        ArrayList<Pair<String, int[]>> arrayList = new ArrayList<Pair<String, int[]>>();
        arrayList.addAll(_65xxMnemonics.get65xxMnemonics(kickAssemblerParameters.includeIllegalOpcodes));
        if (kickAssemblerParameters.dtvMode) {
            arrayList.addAll(_65xxMnemonics.getDtvMnemonics());
        }
        for (Pair pair : arrayList) {
            String string4 = (String)pair.getA();
            int[] nArray = (int[])pair.getB();
            Func5<String, _65xxArgType, ExprNode, String, SourceRange, AsmNode> func5 = (string2, _65xxArgType2, exprNode, string3, sourceRange) -> _65xxMnemonicNode.createNode(string4, string2, _65xxArgType2, exprNode, nArray, string3, sourceRange, evaluationState);
            mainParser.addSubPaser(string4, new _65xxMnemonicTailParser(func5));
        }
        mainParser.copyTo(mainParser2);
        mainParser.setScopeNodeCreator(list -> new BracketScopeDirective(new AsmNodeList((List<AsmNode>)list)));
        return mainParser;
    }

    public static IDirectiveParser<FunctionNode> getFunctionParser(EvaluationState evaluationState) {
        FunctionDirectiveParser functionDirectiveParser = new FunctionDirectiveParser();
        FunctionDirectiveParser functionDirectiveParser2 = new FunctionDirectiveParser();
        functionDirectiveParser.setScopeNodeCreator(list -> new FunctionNodeList((List<FunctionNode>)list));
        functionDirectiveParser.addSubPaser(".eval", new StmtBodyParser<FunctionNode>((stmtNode, sourceRange) -> new EvalFDirective((StmtNode)stmtNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".error", new ExprBodyParser<FunctionNode>((exprNode, sourceRange) -> new ErrorFDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".errorif", new ExprListTailParser<FunctionNode>((list, sourceRange) -> new ErrorIfFDirective((List<ExprNode>)list, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".print", new ExprBodyParser<FunctionNode>((exprNode, sourceRange) -> new PrintFDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".printnow", new ExprBodyParser<FunctionNode>((exprNode, sourceRange) -> new PrintNowFDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".return", new ExprBodyParser<FunctionNode>((exprNode, sourceRange) -> new ReturnFDirective((ExprNode)exprNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".const", new AssignmentTailParser<FunctionNode>((iToken, iToken2, exprNode, sourceRange) -> new EvalFDirective(new ConstDeclaration(iToken.getStringValue(), (ExprNode)exprNode, true, iToken.getSourceRange()), (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".var", new AssignmentTailParser<FunctionNode>((iToken, iToken2, exprNode, sourceRange) -> new EvalFDirective(new VariableDeclaration(iToken.getStringValue(), (ExprNode)exprNode, true, iToken.getSourceRange()), (SourceRange)sourceRange)).setAssignmentIsOptional(true));
        functionDirectiveParser.addSubPaser(".while", new ParanExprBodyTailParser<FunctionNode>(functionDirectiveParser, (exprNode, list, sourceRange) -> new ForFDirective(StmtNode.emptyList, (ExprNode)exprNode, ExprNode.emptyList, new FunctionNodeList((List<FunctionNode>)list), (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".if", new IfTailParser<FunctionNode>(functionDirectiveParser2, (exprNode, functionNode, functionNode2, sourceRange) -> new IfFDirective((ExprNode)exprNode, (FunctionNode)functionNode, (FunctionNode)functionNode2, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".for", new ForTailParser<FunctionNode>(functionDirectiveParser2, (list, exprNode, list2, functionNode, sourceRange) -> new ForFDirective((List<StmtNode>)list, (ExprNode)exprNode, (List<ExprNode>)list2, (FunctionNode)functionNode, (SourceRange)sourceRange)));
        functionDirectiveParser.addSubPaser(".assert", new AssertTailParser<FunctionNode>(functionDirectiveParser2, (exprNode, exprNode2, exprNode3, sourceRange) -> new AssertFDirective((ExprNode)exprNode, (ExprNode)exprNode2, (ExprNode)exprNode3, (SourceRange)sourceRange), null));
        functionDirectiveParser.copyTo(functionDirectiveParser2);
        functionDirectiveParser.setScopeNodeCreator(list -> new BracketScopeFDirective(new FunctionNodeList((List<FunctionNode>)list)));
        return functionDirectiveParser;
    }
}

