/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.segments.SegmentDefaultStartType;
import kickass.state.segments.SegmentType;

public class Segment {
    private boolean isInitialized = false;
    private String name;
    private SegmentType type = SegmentType.input;
    private boolean isDefault = false;
    private SegmentDefaultStartType startType = SegmentDefaultStartType.none;
    private Segment startsAfter = null;
    private boolean isVirtual = false;
    private Integer align = null;
    private List<String> subsegmentIds = new ArrayList<String>();
    private byte fillByte = 0;
    private boolean allowOverlap = false;
    private List<Pair<String, SourceRange>> prgFiles = new ArrayList<Pair<String, SourceRange>>();
    private int currentPc = -1;
    private int currentSegmentLenght = -1;
    private int resolvedStartPc = 8192;
    private int resolvedEndPc = -1;
    private int resolvedSegmentLenght = -1;

    public Segment(String string) {
        this.name = string;
    }

    public Segment(String string, SegmentType segmentType) {
        this.name = string;
        this.type = segmentType;
    }

    public String getName() {
        return this.name;
    }

    public SegmentType getType() {
        return this.type;
    }

    public List<String> getSubSegmentIds() {
        return this.subsegmentIds;
    }

    public List<Pair<String, SourceRange>> getPrgFiles() {
        return this.prgFiles;
    }

    public boolean getAllowOverlappingMemoryBlocks() {
        return this.allowOverlap;
    }

    public byte getFillByte() {
        return this.fillByte;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public Integer align() {
        return this.align;
    }

    public void setAlign(Integer n) {
        this.align = n;
    }

    public void setType(SegmentType segmentType) {
        this.type = segmentType;
    }

    public Segment setIsInitialized() {
        this.isInitialized = true;
        return this;
    }

    public Segment setVirtual(boolean bl) {
        this.isVirtual = bl;
        return this;
    }

    public Segment setStartAddr(int n) {
        this.startType = SegmentDefaultStartType.defaultValue;
        this.resolvedStartPc = n;
        return this;
    }

    public Segment setStartAfterSegement(Segment segment) {
        this.startType = SegmentDefaultStartType.afterSegment;
        this.startsAfter = segment;
        this.resolvedStartPc = -1;
        return this;
    }

    public Segment setAllowOverlappingMemoryBlocks(boolean bl) {
        this.allowOverlap = bl;
        return this;
    }

    public Segment setFillByte(byte by) {
        this.fillByte = by;
        return this;
    }

    public Segment addSubSegmentIds(String ... stringArray) {
        this.subsegmentIds.addAll(Arrays.asList(stringArray));
        return this;
    }

    public Segment addPrgFile(Pair<String, SourceRange> pair) {
        this.prgFiles.add(pair);
        return this;
    }

    public Segment setIsDefault(boolean bl) {
        this.isDefault = bl;
        return this;
    }

    public void initPass() {
        if (this.type != SegmentType.input) {
            return;
        }
        int n = this.getResolvedStartPc();
        if (n < 0) {
            this.invalidateMemoryPos(false);
        } else {
            this.currentPc = n;
        }
        this.currentSegmentLenght = 0;
    }

    public void postPass(EvaluationState evaluationState) {
        if (this.type != SegmentType.input) {
            return;
        }
        if (this.startType == SegmentDefaultStartType.afterSegment && !this.startsAfter.isInitialized()) {
            throw new AsmErrorException("Segment '" + this.name + "' is set to start after '" + this.startsAfter.name + "', which is never initialized");
        }
        if (this.resolvedSegmentLenght < 0 && this.currentSegmentLenght >= 0) {
            this.resolvedSegmentLenght = this.currentSegmentLenght;
            evaluationState.setMadeMetaProgress();
        }
        if (this.resolvedEndPc < 0 && this.currentPc >= 0) {
            this.resolvedEndPc = this.currentPc;
            evaluationState.setMadeMetaProgress();
        }
    }

    public int getMemoryPosition() {
        return this.currentPc;
    }

    public void invalidateMemoryPos(boolean bl) {
        this.currentPc = -1;
        if (bl) {
            this.currentSegmentLenght = -1;
        }
    }

    public void setMemoryPosition(int n) {
        this.currentSegmentLenght = -1;
        this.currentPc = n;
    }

    public void increaseMemoryPosition(int n) {
        if (this.currentPc >= 0) {
            this.currentPc += n;
        }
        if (this.currentSegmentLenght >= 0) {
            this.currentSegmentLenght += n;
        }
    }

    public boolean startIsResolved() {
        return this.resolvedStartPc >= 0;
    }

    public int getResolvedStartPc() {
        if (this.resolvedStartPc < 0 && this.startType == SegmentDefaultStartType.afterSegment && this.startsAfter.isInitialized()) {
            this.resolvedStartPc = this.startsAfter.getResolvedEndPc();
            if (this.resolvedStartPc >= 0 && this.align != null) {
                int n = this.align - this.resolvedStartPc % this.align;
                if (n == this.align) {
                    n = 0;
                }
                this.resolvedStartPc += n;
            }
        }
        return this.resolvedStartPc;
    }

    public int getResolvedEndPc() {
        int n;
        if (this.resolvedEndPc < 0 && this.resolvedSegmentLenght >= 0 && (n = this.getResolvedStartPc()) >= 0) {
            this.resolvedEndPc = n + this.resolvedSegmentLenght;
        }
        return this.resolvedEndPc;
    }
}

