/*
 * Decompiled with CFR 0.152.
 */
package kickass.converter.gui.controllers;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import kickass.converter.gui.controllers.ConverterFrameController;
import kickass.converter.gui.controllers.IController;
import kickass.converter.gui.controllers.IDialogController;
import kickass.converter.gui.controllers.subdialogs.AddFilesDialogController;
import kickass.converter.gui.controllers.subdialogs.AddSourceDirDialogController;
import kickass.converter.gui.controllers.subdialogs.ConvertDialogController;
import kickass.converter.gui.controllers.subdialogs.WelcomeDialogController;
import kickass.converter.gui.model.MainModel;

public class ConverterMainController {
    private Map<String, IController> controllerMap = new HashMap<String, IController>();
    private JFrame mainFrame;
    private MainModel model;
    private ConverterFrameController frameController;

    public ConverterMainController(MainModel mainModel) {
        this.model = mainModel;
        this.frameController = new ConverterFrameController(this);
        this.registerController("WelcomeDialogController", new WelcomeDialogController(this));
        this.registerController("AddFilesDialogController", new AddFilesDialogController(this));
        this.registerController("AddSourceDirDialogController", new AddSourceDirDialogController(this));
        this.registerController("ConvertDialogController", new ConvertDialogController(this));
    }

    public void start() {
        this.update();
        this.frameController.setVisible(true);
        this.executeDialog("WelcomeDialogController");
    }

    public void update() {
        this.frameController.update();
    }

    public MainModel getModel() {
        return this.model;
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(JFrame jFrame) {
        this.mainFrame = jFrame;
    }

    public void registerController(String string, IController iController) {
        this.controllerMap.put(string, iController);
    }

    public IController getController(String string) {
        return this.controllerMap.get(string);
    }

    public void executeDialog(String string) {
        ((IDialogController)((Object)this.getController(string))).execute();
    }
}

