/*
 * Decompiled with CFR 0.152.
 */
package kickass.converter.gui.controllers.subdialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import kickass.converter.file.ConverterConfig;
import kickass.converter.file.KickAss3To4FileConverter;
import kickass.converter.gui.controllers.BaseController;
import kickass.converter.gui.controllers.ConverterMainController;
import kickass.converter.gui.controllers.IDialogController;

public class ConvertDialogController
extends BaseController
implements IDialogController {
    public static final String ControllerId = "ConvertDialogController";
    private JDialog dialog = new JDialog(this.getMainController().getMainFrame(), "Converting", true);
    private JProgressBar progressBar;
    private JTextArea outputText;
    private JButton stopButton;
    private JButton closeButton;
    private boolean stop;

    public ConvertDialogController(ConverterMainController converterMainController) {
        super(converterMainController);
        this.dialog.setLocationRelativeTo(this.getMainController().getMainFrame());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setSize(500, 400);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.dialog.add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel.add((Component)jPanel2, "North");
        this.progressBar = new JProgressBar();
        jPanel2.add(new JLabel("Progress"));
        jPanel2.add(this.progressBar);
        this.outputText = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.outputText);
        jPanel.add((Component)jScrollPane, "Center");
        this.outputText.setText("Ouput goes here.......");
        this.outputText.setFont(new Font("Monospaced", 0, 12));
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel.add((Component)jPanel3, "South");
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertDialogController.this.stop = true;
            }
        });
        jPanel3.add(this.stopButton);
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertDialogController.this.dialog.setVisible(false);
            }
        });
        jPanel3.add(this.closeButton);
    }

    @Override
    public void execute() {
        this.stopButton.setEnabled(true);
        this.closeButton.setEnabled(false);
        this.progressBar.setValue(0);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(this.getMainModel().files.size());
        this.outputText.setText("");
        this.stop = false;
        Thread thread = new Thread(){

            @Override
            public void run() {
                ArrayList<String> arrayList = new ArrayList<String>(ConvertDialogController.this.getMainModel().files);
                Collections.sort(arrayList);
                int n = arrayList.size();
                ConvertDialogController.this.println("Converting " + n + " files.");
                int n2 = 0;
                for (int i = 0; i < n; ++i) {
                    Object object;
                    ConvertDialogController.this.updateProgressBar(i);
                    if (ConvertDialogController.this.stop) {
                        ConvertDialogController.this.println("Stopped by user!");
                        ConvertDialogController.this.switchToDone();
                        return;
                    }
                    String string = (String)arrayList.get(i);
                    ConvertDialogController.this.println("Converting file:  " + string);
                    try {
                        ConverterConfig converterConfig = ConvertDialogController.this.getMainModel().converterConfig;
                        object = new KickAss3To4FileConverter(converterConfig);
                        object.execute(string, string);
                        continue;
                    }
                    catch (Exception exception) {
                        ++n2;
                        ConvertDialogController.this.println("Error while converting file : \n" + exception.getMessage());
                        object = new StringWriter();
                        exception.printStackTrace(new PrintWriter((Writer)object));
                        ConvertDialogController.this.println(((StringWriter)object).toString());
                    }
                }
                ConvertDialogController.this.updateProgressBar(n);
                ConvertDialogController.this.println("Done! " + n2 + " errors.");
                ConvertDialogController.this.switchToDone();
            }
        };
        thread.start();
        this.dialog.setVisible(true);
    }

    private void updateProgressBar(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertDialogController.this.progressBar.setValue(n);
                ConvertDialogController.this.progressBar.repaint();
            }
        });
    }

    private void println(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertDialogController.this.outputText.append(string);
                ConvertDialogController.this.outputText.append("\n");
                ConvertDialogController.this.outputText.repaint();
            }
        });
    }

    private void switchToDone() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertDialogController.this.closeButton.setEnabled(true);
                ConvertDialogController.this.stopButton.setEnabled(false);
            }
        });
    }

    @Override
    public void update() {
    }
}

