/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.outputmanager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.outputmanager.IOutputManager;
import kickass.nonasm.tools.FileUtil;

public class FileOutputManager
implements IOutputManager {
    private boolean allowRandomOutputFiles = false;
    private File outDir;

    public FileOutputManager(File file, boolean bl) {
        this.allowRandomOutputFiles = bl;
        if (file.exists() && !file.isDirectory()) {
            throw new AsmErrorException("The output dir exist and is not a directory: " + file.getAbsolutePath());
        }
        if (!file.exists()) {
            try {
                Files.createDirectories(file.toPath(), new FileAttribute[0]);
            }
            catch (Exception exception) {
                throw new AsmErrorException("Can't create output dir: " + file.getAbsolutePath());
            }
        }
        this.outDir = FileUtil.getCanonicalFile(file);
    }

    @Override
    public OutputStream OpenOutputStream(String string, boolean bl) throws FileNotFoundException {
        Comparable<File> comparable;
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.outDir, string);
        }
        if (bl && !this.allowRandomOutputFiles) {
            comparable = this.outDir.toPath().normalize();
            Path path = FileUtil.getCanonicalFile(file).toPath();
            boolean bl2 = path.startsWith((Path)comparable);
            if (!bl2) {
                throw new AsmErrorException("Can't write file '" + string + "' since outputfiles specified in the sourcecode which is outside the natural output dir is blocked unless deliberately turned on. Use -afo switch to allow file output.");
            }
        }
        if ((comparable = file.getParentFile()) != null && !((File)comparable).exists()) {
            try {
                Files.createDirectories(((File)comparable).toPath(), new FileAttribute[0]);
            }
            catch (Exception exception) {
                throw new AsmErrorException("Can't create output dir: " + ((File)comparable).getAbsolutePath());
            }
        }
        return new FileOutputStream(file);
    }
}

