/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.common.errors.AsmError;
import kickass.nonasm.util.functions.Func4;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class SegmentTailParser<NODE>
implements ITailParser<NODE> {
    private boolean isDefOnly;
    private Func4<String, ExprNode, ParameterMap, SourceRange, NODE> nodeCreator;

    public SegmentTailParser(boolean bl, Func4<String, ExprNode, ParameterMap, SourceRange, NODE> func4) {
        this.isDefOnly = bl;
        this.nodeCreator = func4;
    }

    @Override
    public NODE parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        IToken iToken2;
        Object object;
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        tokenStreamList.skipWsAndNl();
        IToken iToken3 = tokenStreamList.expectType(TokenType.Id, evaluationState);
        if (iToken3 == null) {
            return null;
        }
        String string = iToken3.getStringValue();
        tokenStreamList.skipWs();
        IToken iToken4 = tokenStreamList.peek();
        IToken iToken5 = null;
        ExprNode exprNode = null;
        if (!this.isDefOnly && !iToken4.isEos() && iToken4.getType() != TokenType.SquareBracketRange) {
            object = tokenStreamList.getUntilType(TokenType.SquareBracketRange);
            iToken5 = ((TokenStreamList)object).getTerminatingToken();
            exprNode = ExprParser.parse((TokenStreamList)object, evaluationState);
            if (exprNode == null) {
                return null;
            }
        }
        object = null;
        tokenStreamList.skipWs();
        IToken iToken6 = iToken2 = iToken5 != null ? iToken5 : tokenStreamList.next();
        if (!iToken2.isEos()) {
            if (iToken2.getType() != TokenType.SquareBracketRange) {
                evaluationState.errorMgr.addError(new AsmError("Invalid token", iToken2.getSourceRange()));
                return null;
            }
            object = ExprParser.parseParametersMap(iToken2.getChildStream(), evaluationState, iToken2.getSourceRange());
            if (object == null) {
                return null;
            }
        }
        tokenStreamList.skipWsAndNl();
        tokenStreamList.next().expectEos(evaluationState);
        return this.nodeCreator.apply(string, exprNode, (ParameterMap)object, sourceRange);
    }
}

