/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.stmt.StmtNode;
import kickass.state.EvaluationState;

public class EvalDirective
extends Directive {
    private StmtNode stmt;
    private boolean evalFinished = false;

    public EvalDirective(StmtNode stmtNode, SourceRange sourceRange) {
        super(sourceRange);
        this.stmt = stmtNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.stmt.executeMetaRegistrations(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.stmt.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        this.stmt.evaluate(evaluationState);
        boolean bl = this.evalFinished = !evaluationState.sideeffectMgr.getErrorDuringFunctionEvaluation();
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }

    @Override
    public boolean isFinished() {
        return this.evalFinished;
    }
}

