/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.metanodes.MacroDefinitionRootNode;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.LabelValue;
import kickass.pass.values.ScopeValue;
import kickass.pass.values._65xxArgumentValue;
import kickass.state.EvaluationState;
import kickass.state.scope.symboltable.ISymbolPageIdx;

public class PseudoCommandExecution
extends AsmDirective
implements ILabelConnectorNode {
    private boolean isRootScope;
    private String name;
    private List<ExprNode> argumentExprs;
    private String labelId;
    private MacroDefinitionRootNode pseudoCmd;
    private ISymbolPageIdx labelPageIdx;

    public PseudoCommandExecution(String string, List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.isRootScope = string.startsWith("@");
        this.name = this.isRootScope ? string.substring(1) : string;
        this.argumentExprs = list;
    }

    @Override
    public boolean connectToLabel(ILabelNode iLabelNode) {
        this.labelId = iLabelNode.getName();
        return true;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) throws AsmException {
        for (ExprNode exprNode : this.argumentExprs) {
            exprNode.executePrepass(evaluationState);
        }
        this.pseudoCmd = evaluationState.namespaceMgr.getRootOrCurrentNamespace(this.isRootScope).getPseudoCommands().get(this.name);
        if (this.pseudoCmd == null) {
            evaluationState.errorMgr.addError(new AsmError("Pseudo command '" + this.name + "' not defined", this.range));
            return EmptyOutput.instance;
        }
        int n = this.pseudoCmd.getArgumentNames().size();
        if (n < this.argumentExprs.size() && (n != 0 || this.argumentExprs.size() != 1)) {
            evaluationState.errorMgr.addError(new AsmError("Too many arguments for pseudo command", this.range));
            return EmptyOutput.instance;
        }
        if (this.labelId != null) {
            this.labelPageIdx = evaluationState.scopeMgr.resolveSymbol(this.labelId);
            this.labelPageIdx.replaceInitializer(LabelValue.getInitializer(evaluationState, () -> new ScopeValue(this.pseudoCmd.getInnerScope(), null)));
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) throws AsmException {
        IValueHolder[] iValueHolderArray;
        if (this.labelId == null) {
            iValueHolderArray = this.pseudoCmd.getInnerScope().getSymbolTable().createPage();
        } else {
            LabelValue labelValue = (LabelValue)this.labelPageIdx.getValueHolder().getWithoutSideeffect();
            iValueHolderArray = ((ScopeValue)labelValue.getConnectedValue()).getSymbolPage();
        }
        return this.pseudoCmd.instantiate(this.argumentExprs, _65xxArgumentValue.noArgument, iValueHolderArray, this.range).executePass(evaluationState);
    }
}

