/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentParser;

public class SegmentDefDirective
extends AsmDirective {
    private boolean isDefOnly;
    private String segmentId;
    private ParameterMap parameters;
    private AsmNode resultOutput = null;

    public SegmentDefDirective(boolean bl, String string, ParameterMap parameterMap, SourceRange sourceRange) {
        super(sourceRange);
        this.isDefOnly = bl;
        this.segmentId = string;
        this.parameters = parameterMap;
    }

    @Override
    public AsmNode copy() {
        return new SegmentDefDirective(this.isDefOnly, this.segmentId, this.parameters, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        Segment segment = evaluationState.segmentMgr.getSegment(this.segmentId);
        if (segment == null) {
            evaluationState.segmentMgr.addSegment(new Segment(this.segmentId));
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.parameters != null) {
            if (SegmentParser.isCombiSegment(this.parameters)) {
                this.parameters.addErrorsForUnknownParameres(SegmentParser.allCombiSegmentParameters, evaluationState);
            } else {
                this.parameters.addErrorsForUnknownParameres(SegmentParser.allInputSegmentParameters, evaluationState);
                this.parameters.addErrorsForMutualExclusiveParameres(evaluationState, "start", "start");
            }
            this.parameters.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        boolean bl;
        if (this.resultOutput != null) {
            this.resultOutput.executePass(evaluationState);
            boolean bl2 = evaluationState.segmentMgr.getSegment(this.segmentId).startIsResolved();
            if (!bl2 && evaluationState.failOnInvalidValue()) {
                throw new AsmErrorException("Can't resolve start of segment.", this.range);
            }
            return bl2 ? this.resultOutput : this;
        }
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (this.parameters != null && !this.parameters.evaluateAllParameters(evaluationState)) {
            throw new AsmErrorException("All segment definition parameters must be valid in first pass", this.range);
        }
        Segment segment = evaluationState.segmentMgr.getSegment(this.segmentId);
        if (segment.isInitialized()) {
            throw new AsmErrorException(new AsmError("Segment '" + this.segmentId + "' already defined", this.range));
        }
        segment.setIsInitialized();
        boolean bl3 = bl = this.parameters != null && SegmentParser.isCombiSegment(this.parameters);
        if (bl && !this.isDefOnly) {
            throw new AsmErrorException("The .segment directive can't define a combi segment (use .segmentdef)", this.range);
        }
        if (bl) {
            SegmentParser.createCombiSegment(segment, this.parameters, evaluationState);
        } else {
            SegmentParser.createInputSegment(segment, this.parameters, evaluationState);
        }
        segment.initPass();
        this.resultOutput = new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
        return segment.startIsResolved() ? this.resultOutput : this;
    }

    private Value evaluateParam(String string, EvaluationState evaluationState) {
        Value value = this.parameters.getExpr(string).evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("Segement parameters must be able to evaluate in first pass", this.parameters.getNameRange(string));
        }
        return value;
    }
}

