/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.AsmOutput;
import kickass.pass.asmnode.output.CombiOutput;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.asmnode.output.StartOfMemoryBlockOutput;
import kickass.pass.asmnode.output.SwitchSegmentOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;

public class SegmentDirective
extends AsmDirective {
    private String segmentId;
    private ExprNode memBlockNameExpr = null;

    public SegmentDirective(String string, ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.segmentId = string;
        this.memBlockNameExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return new SegmentDirective(this.segmentId, this.memBlockNameExpr, this.range);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        if (this.memBlockNameExpr != null) {
            this.memBlockNameExpr.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Object object;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        String string = null;
        if (this.memBlockNameExpr != null) {
            object = this.memBlockNameExpr.evaluate(evaluationState);
            if (((Value)object).isInvalid()) {
                throw new AsmErrorException("Memblock name parameter must be valid in first pass", this.range);
            }
            string = ((Value)object).getString(this.range);
        }
        if ((object = evaluationState.segmentMgr.getSegment(this.segmentId)) == null || !((Segment)object).isInitialized()) {
            throw new AsmErrorException("Undefined segment '" + this.segmentId + "'", this.range);
        }
        evaluationState.segmentMgr.switchToSegment((Segment)object);
        SwitchSegmentOutput switchSegmentOutput = new SwitchSegmentOutput((Segment)object, evaluationState.sideeffectMgr.getFunctionSideOutput());
        AsmOutput asmOutput = string == null ? EmptyOutput.instance : new StartOfMemoryBlockOutput(null, string, ((Segment)object).isVirtual(), null);
        return new CombiOutput(evaluationState.sideeffectMgr.getFunctionSideOutput(), switchSegmentOutput, asmOutput);
    }
}

