/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.nonasm.c64.CharToPetsciiConverter;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.ByteOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class TextBlockDirective
extends AsmDirective {
    private ExprNode stringExpr;

    public TextBlockDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.stringExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.stringExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.stringExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            return this.invalidatePcAndReturnThis(evaluationState);
        }
        String string = value.getString(this.range);
        byte[] byArray = new byte[string.length()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = CharToPetsciiConverter.convert(string.charAt(i), true);
        }
        evaluationState.segmentMgr.increaseMemoryPosition(string.length());
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        return new ByteOutput(byArray, this.range, evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

