/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.metanodes;

import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.valueholder.IValueHolder;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolTable;

public class ScopeAndSymbolPageNode
extends AsmNode {
    private AsmNode body;
    private SymbolScope innerScope;
    private ISymbolTable symbolTable;
    private IValueHolder[] pageValues;

    public ScopeAndSymbolPageNode(AsmNode asmNode, SymbolScope symbolScope) {
        this(asmNode, symbolScope, null);
    }

    public ScopeAndSymbolPageNode(AsmNode asmNode, SymbolScope symbolScope, IValueHolder[] iValueHolderArray) {
        this.body = asmNode;
        this.innerScope = symbolScope;
        this.symbolTable = symbolScope.getSymbolTable();
        this.pageValues = iValueHolderArray;
    }

    @Override
    public AsmNode copy() {
        return new ScopeAndSymbolPageNode(this.body, this.innerScope);
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.body = this.body.executeMetaRegistrations(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.replaceCurrentScope(this.innerScope);
        this.body = this.body.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(symbolScope);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (this.pageValues == null) {
            this.pageValues = this.symbolTable.createPage();
        }
        IValueHolder[] iValueHolderArray = this.symbolTable.replaceCurrentPage(this.pageValues);
        this.body = this.body.executePass(evaluationState);
        this.symbolTable.setCurrentPage(iValueHolderArray);
        return this;
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        this.body.deliverOutput(iOutputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    public IValueHolder[] getSymbolPage() {
        return this.pageValues;
    }

    @Override
    public String toString() {
        return "ScopeNode[isFinised=" + this.isFinished() + "]";
    }
}

