/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import java.util.ArrayList;
import java.util.List;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.function.IFunction;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ObjFunctionCall
extends ExprNode {
    private String functionName;
    private ExprNode[] objAndArgumentExprs;

    public ObjFunctionCall(String string, SourceRange sourceRange, ExprNode exprNode, ExprNode ... exprNodeArray) {
        super(sourceRange);
        this.functionName = string;
        this.objAndArgumentExprs = new ExprNode[exprNodeArray.length + 1];
        this.objAndArgumentExprs[0] = exprNode;
        for (int i = 0; i < exprNodeArray.length; ++i) {
            this.objAndArgumentExprs[i + 1] = exprNodeArray[i];
        }
    }

    private ObjFunctionCall(String string, SourceRange sourceRange, ExprNode[] exprNodeArray) {
        super(sourceRange);
        this.functionName = string;
        this.objAndArgumentExprs = exprNodeArray;
    }

    public ObjFunctionCall(String string, SourceRange sourceRange, ExprNode exprNode, ArrayList<ExprNode> arrayList) {
        this(string, sourceRange, exprNode, ObjFunctionCall.toArray(arrayList));
    }

    private static ExprNode[] toArray(List<ExprNode> list) {
        int n = list.size();
        ExprNode[] exprNodeArray = new ExprNode[n];
        for (int i = 0; i < n; ++i) {
            exprNodeArray[i] = list.get(i);
        }
        return exprNodeArray;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        for (ExprNode exprNode : this.objAndArgumentExprs) {
            exprNode.executePrepass(evaluationState);
        }
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value;
        boolean bl = false;
        Value[] valueArray = new Value[this.objAndArgumentExprs.length];
        Value value2 = null;
        for (int i = 0; i < this.objAndArgumentExprs.length; ++i) {
            value = this.objAndArgumentExprs[i].evaluate(evaluationState);
            if (i == 0) {
                value2 = valueArray[i] = value;
            } else {
                valueArray[i] = value;
            }
            if (!value.isInvalid()) continue;
            bl = true;
        }
        IFunction iFunction = value2.getFunctions().getOrError(this.functionName, valueArray.length, this.range);
        if (bl && !iFunction.handlesInvalidArguments()) {
            return iFunction.getInvalidResult(valueArray);
        }
        evaluationState.callStack.push(this.range);
        value = iFunction.execute(valueArray, evaluationState, this.range);
        if (value.isInvalid()) {
            evaluationState.sideeffectMgr.setInvalidSideEffectsDuringFunctionEvaluation();
        }
        evaluationState.callStack.pop();
        return value;
    }

    public String toString() {
        return "obj." + this.functionName + "()";
    }
}

