/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.refexpr;

import kickass.common.errors.AsmError;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.refexpr.IReferenceExpr;
import kickass.pass.expressions.refexpr.ReferenceOperation;
import kickass.pass.valueholder.IValueHolder;
import kickass.state.EvaluationState;
import kickass.state.scope.symboltable.ISymbolPageIdx;

public class MultiSymbolReferenceExpr
implements IReferenceExpr {
    private String fullName;
    private SourceRange range;
    private ISymbolPageIdx symbolIdx;

    public MultiSymbolReferenceExpr(String string, SourceRange sourceRange) {
        this.range = sourceRange;
        this.fullName = string;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState, ReferenceOperation referenceOperation) {
        int n;
        if (this.fullName.endsWith("-")) {
            n = 0;
        } else if (this.fullName.endsWith("+")) {
            n = 1;
        } else {
            evaluationState.errorMgr.addError(new AsmError("Missing direction on multilabel reference '" + this.fullName + "'", this.range));
            return;
        }
        String string = this.fullName.substring(0, this.fullName.length() - 1);
        this.symbolIdx = evaluationState.scopeMgr.getCurrentScope().getMultiSymbol(string, n);
        if (this.symbolIdx == null) {
            evaluationState.errorMgr.addError(new AsmError("Unknown symbol '" + this.fullName + "'", this.range));
        }
    }

    @Override
    public IValueHolder getValueHolder(EvaluationState evaluationState) {
        return this.symbolIdx.getValueHolder();
    }

    public String toString() {
        return "MultiLabelReference(" + this.fullName + ")";
    }

    @Override
    public SourceRange getSourceRange() {
        return this.range;
    }
}

