/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.function.table;

import java.util.HashMap;
import java.util.Map;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.function.IFunction;
import kickass.pass.function.table.FunctionTable;

public class StdFunctionTable
extends FunctionTable {
    private static Integer anyNoOfArguments = -1;
    private Map<String, Map<Integer, IFunction>> functionMap = new HashMap<String, Map<Integer, IFunction>>();

    public StdFunctionTable() {
    }

    public StdFunctionTable(StdFunctionTable stdFunctionTable) {
        this.functionMap.putAll(stdFunctionTable.functionMap);
    }

    @Override
    public AsmError add(IFunction iFunction, boolean bl, SourceRange sourceRange) {
        Integer n;
        String string = iFunction.getName();
        Map<Integer, IFunction> map = this.functionMap.get(string);
        if (map == null) {
            map = new HashMap<Integer, IFunction>();
            this.functionMap.put(string, map);
        }
        Integer n2 = n = iFunction.getNoOfArguments() == null ? anyNoOfArguments : iFunction.getNoOfArguments();
        if (map.containsKey(n) && !bl) {
            return new AsmError("The function '" + string + "' is already defined.", sourceRange);
        }
        map.put(n, iFunction);
        return null;
    }

    @Override
    public IFunction get(String string, int n) {
        Map<Integer, IFunction> map = this.functionMap.get(string);
        if (map == null) {
            return null;
        }
        IFunction iFunction = map.get(n);
        if (iFunction == null) {
            iFunction = map.get(anyNoOfArguments);
        }
        if (iFunction == null) {
            return null;
        }
        return iFunction;
    }

    @Override
    public IFunction getOrError(String string, int n, SourceRange sourceRange) {
        Map<Integer, IFunction> map = this.functionMap.get(string);
        if (map == null) {
            throw new AsmErrorException("Unknown function : " + string, sourceRange);
        }
        IFunction iFunction = map.get(n);
        if (iFunction == null) {
            iFunction = map.get(anyNoOfArguments);
        }
        if (iFunction == null) {
            throw new AsmErrorException("Invalid number of arguments : " + string, sourceRange);
        }
        return iFunction;
    }
}

