/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kickass.common.errors.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.common.log.Logger;
import kickass.common.output.D64Image;
import kickass.nonasm.c64.CharToPetsciiConverter;
import kickass.nonasm.tools.collections.OrderedMap;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.sideeffect.SEIncreaseMemoryPosition;
import kickass.pass.sideeffect.SESetMemoryPosition;
import kickass.pass.sideeffect.SESwitchSegment;
import kickass.setup.configuration.parameters.KickAssemblerParameters;
import kickass.state.EvaluationState;
import kickass.state.segments.C64File;
import kickass.state.segments.C64FileType;
import kickass.state.segments.D64Disk;
import kickass.state.segments.D64File;
import kickass.state.segments.MemoryBlock;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentAssert;
import kickass.state.segments.SegmentType;

public class SegmentManager {
    public static final int defaultMemoryPosition = 8192;
    public static final String defaultSegmentName = "Default";
    private boolean isPseudoPcMode = false;
    public int pseudoPcPosition = -1;
    public Segment defaultSegment;
    public Segment currentSegment;
    private Map<String, Segment> segments = new OrderedMap<String, Segment>();
    private Map<String, C64File> c64Files = new OrderedMap<String, C64File>();
    private Map<String, D64Disk> d64Disks = new OrderedMap<String, D64Disk>();
    private EvaluationState state;
    private String executeFileCandidate = null;
    private List<SegmentAssert> asserts = new ArrayList<SegmentAssert>();
    private static Comparator<MemoryBlock> memoryBlockComparator = new Comparator<MemoryBlock>(){

        @Override
        public int compare(MemoryBlock memoryBlock, MemoryBlock memoryBlock2) {
            int n;
            int n2 = memoryBlock.getStartAdress();
            if (n2 < (n = memoryBlock2.getStartAdress())) {
                return -1;
            }
            if (n2 == n) {
                return 0;
            }
            return 1;
        }
    };

    public SegmentManager(EvaluationState evaluationState) {
        this.state = evaluationState;
        this.defaultSegment = new Segment(defaultSegmentName, SegmentType.input).setIsDefault(true).setFillByte(evaluationState.parameters.fillByte).setIsInitialized();
        this.segments.put(this.defaultSegment.getName(), this.defaultSegment);
    }

    public String getExecuteFileCandidate() {
        return this.executeFileCandidate;
    }

    public void addAssert(SegmentAssert segmentAssert) {
        this.asserts.add(segmentAssert);
    }

    public boolean c64FileExist(String string) {
        return this.c64Files.containsKey(string);
    }

    public C64File getC64File(String string) {
        return this.c64Files.get(string);
    }

    public boolean addC64File(C64File c64File) {
        if (this.c64Files.containsKey(c64File.getFilename())) {
            return false;
        }
        this.c64Files.put(c64File.getFilename(), c64File);
        return true;
    }

    public boolean d64DiskExist(String string) {
        return this.d64Disks.containsKey(string);
    }

    public boolean addD64Disk(D64Disk d64Disk) {
        if (this.d64Disks.containsKey(d64Disk.getDiskName())) {
            return false;
        }
        this.d64Disks.put(d64Disk.getFilename(), d64Disk);
        return true;
    }

    public Segment getSegment(String string) {
        return this.segments.get(string);
    }

    public void addSegment(Segment segment) {
        if (this.segments.containsKey(segment.getName())) {
            throw new AsmErrorException("Already have a segment by the name of: " + segment);
        }
        this.segments.put(segment.getName(), segment);
    }

    public void switchToSegment(Segment segment) {
        if (this.isPseudoPcMode) {
            throw new AsmErrorException("Can't switch segment while inside a pseudopc directive");
        }
        this.switchToSegmentWithoutSideEffect(segment);
        this.state.sideeffectMgr.addSideEffect(new SESwitchSegment(segment));
    }

    public void switchToSegmentWithoutSideEffect(Segment segment) {
        this.currentSegment = segment;
    }

    public Segment getCurrentSegment() {
        return this.currentSegment;
    }

    public int getMemoryPosition() {
        if (this.isPseudoPcMode) {
            return this.pseudoPcPosition;
        }
        return this.currentSegment.getMemoryPosition();
    }

    public void invalidateMemoryPosition() {
        this.currentSegment.invalidateMemoryPos(true);
        this.pseudoPcPosition = -1;
        this.state.sideeffectMgr.setErrorDuringFunctionEvaluation(true);
    }

    public void startMemoryBlock(int n, SourceRange sourceRange) {
        if (this.isPseudoPcMode) {
            throw new AsmErrorException("You can't start a new memoryblock in pseudo pc mode", sourceRange);
        }
        this.startMemoryBlockWithoutSideEfffect(n);
        this.state.sideeffectMgr.addSideEffect(new SESetMemoryPosition(n));
    }

    public void startMemoryBlockWithoutSideEfffect(int n) {
        this.currentSegment.setMemoryPosition(n);
    }

    public void increaseMemoryPosition(int n) {
        this.increaseMemoryPositionWithoutSideEffect(n);
        this.state.sideeffectMgr.addSideEffect(new SEIncreaseMemoryPosition(n));
    }

    public void increaseMemoryPositionWithoutSideEffect(int n) {
        this.currentSegment.increaseMemoryPosition(n);
        if (this.pseudoPcPosition >= 0) {
            this.pseudoPcPosition += n;
        }
    }

    public void enterPseudoPcMode(int n, SourceRange sourceRange) {
        if (this.isPseudoPcMode) {
            throw new AsmErrorException("You can't nest pseudo pc directives", sourceRange);
        }
        this.isPseudoPcMode = true;
        this.pseudoPcPosition = n;
    }

    public void exitPseudoPcMode() {
        this.isPseudoPcMode = false;
        this.pseudoPcPosition = -1;
    }

    public boolean isPseudoPcMode() {
        return this.isPseudoPcMode;
    }

    public void initPass() {
        this.currentSegment = this.defaultSegment;
        for (Segment segment : this.segments.values()) {
            segment.initPass();
        }
    }

    public void postPass() {
        for (Segment segment : this.segments.values()) {
            segment.postPass(this.state);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doOutputAfterPasses(Map<String, List<MemoryBlock>> map, Logger logger) {
        void var6_8;
        boolean bl;
        KickAssemblerParameters kickAssemblerParameters = this.state.parameters;
        Map<String, SegmentNode> map2 = this.processSegments(map);
        if (this.state.parameters.showMemoryMap) {
            logger.println();
            logger.println(this.printMemoryBlocks(map2));
        }
        if (this.state.errorMgr.hasErrors()) {
            return;
        }
        if (!this.asserts.isEmpty()) {
            logger.println();
            logger.println("Segment asserts:");
            for (SegmentAssert object2 : this.asserts) {
                logger.println("  " + this.doSegmentAssert(object2, map2));
            }
        }
        Object object3 = null;
        Object var6_7 = null;
        String string = null;
        boolean bl2 = map2.keySet().size() == 1;
        SegmentNode segmentNode = map2.get(defaultSegmentName);
        boolean bl3 = segmentNode != null && !segmentNode.memoryBlocks.isEmpty();
        boolean bl4 = bl = bl2 || bl3;
        if (bl) {
            if (this.c64FileExist(kickAssemblerParameters.outputfile)) {
                throw new AsmErrorException("Can't output default segment since a file called '" + kickAssemblerParameters.outputfile + "' already exist");
            }
            this.state.segmentMgr.addC64File(new C64File(kickAssemblerParameters.outputfile, defaultSegmentName).setType(kickAssemblerParameters.binFile ? C64FileType.bin : C64FileType.prg).setMbFiles(kickAssemblerParameters.filesForEachMemBlock).setIsDefaultFile());
        }
        for (C64File c64File : this.c64Files.values()) {
            SegmentNode segmentNode2 = map2.get(c64File.getSegmentId());
            if (segmentNode2 == null) {
                throw new AsmErrorException("Unknown source segment for file '" + c64File.getFilename() + "': " + c64File.getSegmentId());
            }
            if (!c64File.getMbFiles()) {
                if (c64File.isDefaultFile()) {
                    object3 = c64File.getFilename();
                }
                if (var6_8 == null) {
                    String string2 = c64File.getFilename();
                }
                this.writeC64File(c64File.getFilename(), c64File.getType(), c64File.isDefaultFile(), segmentNode2.minAddress, segmentNode2.flattenMemoryBlocks(false), logger);
            }
            if (!c64File.getMbFiles()) continue;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (MemoryBlock memoryBlock : segmentNode2.memoryBlocks) {
                if (memoryBlock.isVirtual()) continue;
                ArrayList<MemoryBlock> arrayList = (ArrayList<MemoryBlock>)hashMap.get(memoryBlock.getName());
                if (arrayList == null) {
                    arrayList = new ArrayList<MemoryBlock>();
                    hashMap.put(memoryBlock.getName(), arrayList);
                }
                arrayList.add(memoryBlock);
            }
            String[] stringArray = new String[]{".bin", ".prg"};
            Pair<String, String> pair = SegmentManager.findFilenameBaseAndPostfix(c64File.getFilename(), stringArray);
            for (String string3 : hashMap.keySet()) {
                Object object2;
                String string4 = pair.getA() + "_" + string3 + pair.getB();
                List list = (List)hashMap.get(string3);
                if (list.size() != 1) {
                    logger.warn("" + list.size() + " blocks have the name '" + string3 + "'. They will be merged in the same file.");
                }
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                for (Object object2 : list) {
                    n = Math.min(n, ((MemoryBlock)object2).getStartAdress());
                    n2 = Math.max(n2, ((MemoryBlock)object2).getStartAdress() + ((MemoryBlock)object2).getSize());
                }
                Object object4 = new byte[n2 - n];
                Arrays.fill((byte[])object4, segmentNode2.segment.getFillByte());
                object2 = list.iterator();
                while (object2.hasNext()) {
                    MemoryBlock memoryBlock = (MemoryBlock)object2.next();
                    byte[] byArray = memoryBlock.getMemory();
                    int n3 = memoryBlock.getStartAdress() - n;
                    int n4 = 0;
                    while (n4 < memoryBlock.getSize()) {
                        object4[n3++] = byArray[n4++];
                    }
                }
                this.writeC64File(string4, c64File.getType(), false, n, (byte[])object4, logger);
            }
        }
        for (D64Disk d64Disk : this.d64Disks.values()) {
            if (string == null) {
                string = d64Disk.getFilename();
            }
            this.writeD64Disk(d64Disk, map2, logger);
        }
        if (object3 != null) {
            this.executeFileCandidate = object3;
        } else if (string != null) {
            this.executeFileCandidate = string;
        } else if (var6_8 != null) {
            this.executeFileCandidate = var6_8;
        }
    }

    private static Pair<String, String> findFilenameBaseAndPostfix(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string.endsWith(string2)) continue;
            String string3 = string.substring(0, string.length() - string2.length());
            return new Pair<String, String>(string3, string2);
        }
        return new Pair<String, String>(string, "");
    }

    private Map<String, SegmentNode> processSegments(Map<String, List<MemoryBlock>> map) {
        HashMap<String, SegmentNode> hashMap = new HashMap<String, SegmentNode>();
        for (Segment object : this.segments.values()) {
            String string = object.getName();
            SegmentNode segmentNode = new SegmentNode();
            hashMap.put(string, segmentNode);
            segmentNode.segment = object;
            segmentNode.memoryBlocks = map.containsKey(string) ? map.get(string) : new ArrayList();
        }
        for (SegmentNode segmentNode : hashMap.values()) {
            this.processSegmentNode(segmentNode, hashMap);
        }
        return hashMap;
    }

    private void processSegmentNode(SegmentNode segmentNode, Map<String, SegmentNode> map) {
        int n;
        Object object;
        if (segmentNode.isProcessed) {
            return;
        }
        if (segmentNode.processingStarted) {
            segmentNode.hasError = true;
            this.state.errorMgr.addError(new AsmError("Segement '" + segmentNode.segment.getName() + "' is part of a circular dependancy of segments!", null));
            return;
        }
        segmentNode.processingStarted = true;
        Segment segment = segmentNode.segment;
        if (segment.getType() != SegmentType.input) {
            if (segment.getType() == SegmentType.combi) {
                for (String object2 : segment.getSubSegmentIds()) {
                    object = map.get(object2);
                    if (object == null) {
                        this.state.errorMgr.addError(new AsmError("Unknown subsegment '" + object2 + "' for '" + segment.getName() + "'", null));
                        segmentNode.hasError = true;
                        continue;
                    }
                    this.processSegmentNode((SegmentNode)object, map);
                    if (((SegmentNode)object).hasError) continue;
                    segmentNode.memoryBlocks.addAll(((SegmentNode)object).memoryBlocks);
                    segmentNode.allowedOverlaps.addAll(((SegmentNode)object).allowedOverlaps);
                }
            } else {
                throw new RuntimeException("Unknown segmenttype : " + (Object)((Object)segment.getType()));
            }
        }
        for (Pair pair : segment.getPrgFiles()) {
            object = MemoryBlock.loadPrgFile((String)pair.getA(), this.state.parameters.maxMemoryAddress, (SourceRange)pair.getB(), this.state);
            if (object == null) {
                segmentNode.hasError = true;
                continue;
            }
            segmentNode.memoryBlocks.add((MemoryBlock)object);
        }
        Collections.sort(segmentNode.memoryBlocks, memoryBlockComparator);
        int n2 = 8192;
        int n3 = 8192;
        boolean bl = true;
        int n4 = segmentNode.memoryBlocks.size();
        for (int i = 0; i < n4; ++i) {
            MemoryBlock memoryBlock;
            MemoryBlock memoryBlock2 = segmentNode.memoryBlocks.get(i);
            if (memoryBlock2.isVirtual()) continue;
            int n5 = memoryBlock2.getStartAdress() + memoryBlock2.getSize();
            if (bl) {
                n2 = memoryBlock2.getStartAdress();
                n = n5;
                bl = false;
            } else {
                n = Math.max(n, n5);
            }
            for (int j = i + 1; j < n4 && (memoryBlock = segmentNode.memoryBlocks.get(j)).getStartAdress() < n5; ++j) {
                if (memoryBlock.isVirtual()) continue;
                if (segmentNode.segment.getAllowOverlappingMemoryBlocks()) {
                    segmentNode.allowedOverlaps.add(new Pair<MemoryBlock, MemoryBlock>(memoryBlock2, memoryBlock));
                    segmentNode.allowedOverlaps.add(new Pair<MemoryBlock, MemoryBlock>(memoryBlock, memoryBlock2));
                    continue;
                }
                if (segmentNode.isOverlapAllowed(memoryBlock2, memoryBlock)) continue;
                String string = "'" + memoryBlock2.getName() + "' (" + memoryBlock2.getHexStartAddress() + "-" + memoryBlock2.getHexEndAddress() + ")";
                String string2 = "'" + memoryBlock.getName() + "' (" + memoryBlock.getHexStartAddress() + "-" + memoryBlock.getHexEndAddress() + ")";
                String string3 = "In segment '" + segment.getName() + "' the memoryblock " + string + " overlaps " + string2;
                segmentNode.hasError = true;
                this.state.errorMgr.addError(new AsmError(string3, null));
            }
        }
        segmentNode.maxAddress = n;
        segmentNode.minAddress = n2;
        segmentNode.isProcessed = true;
    }

    private void writeC64File(String string, C64FileType c64FileType, boolean bl, int n, byte[] byArray, Logger logger) {
        logger.println("Writing prg file: " + string);
        try {
            OutputStream outputStream = this.state.outputMgr.OpenOutputStream(string, !bl);
            if (c64FileType == C64FileType.prg) {
                byte by = (byte)(n & 0xFF);
                byte by2 = (byte)((n & 0xFF00) >> 8);
                outputStream.write(new byte[]{by, by2});
            }
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (AsmErrorException asmErrorException) {
            throw asmErrorException;
        }
        catch (Exception exception) {
            throw new AsmErrorException("Problem while writing file '" + string + "': " + exception.getMessage(), null);
        }
    }

    private void writeD64Disk(D64Disk d64Disk, Map<String, SegmentNode> map, Logger logger) {
        byte[] byArray = CharToPetsciiConverter.convert(d64Disk.getDiskId(), CharToPetsciiConverter.charToPetscii_upper);
        byte[] byArray2 = CharToPetsciiConverter.convert(d64Disk.getDiskName(), CharToPetsciiConverter.charToPetscii_upper);
        D64Image d64Image = new D64Image(d64Disk.getFormat(), d64Disk.getSplitFilesOverDirectory(), d64Disk.getStoreFilesInDirectory());
        d64Image.setID(byArray);
        d64Image.setName(byArray2);
        for (D64File d64File : d64Disk.getFiles()) {
            byte[] byArray3;
            Object object;
            if (d64File.getSourcePrgFile() != null) {
                try {
                    object = Paths.get(d64File.getSourcePrgFile(), new String[0]);
                    byArray3 = Files.readAllBytes((Path)object);
                }
                catch (IOException iOException) {
                    throw new AsmErrorException("Error while reading file:" + d64File.getFilename(), null);
                }
            } else if (d64File.getSourceSegment() != null) {
                object = map.get(d64File.getSourceSegment());
                if (object == null) {
                    throw new AsmErrorException("Unknown source segment for file '" + d64File.getFilename() + "': " + d64File.getSourceSegment());
                }
                byArray3 = ((SegmentNode)object).flattenMemoryBlocks(true);
            } else {
                byArray3 = new byte[]{};
            }
            object = CharToPetsciiConverter.convert(d64File.getFilename(), CharToPetsciiConverter.charToPetscii_upper);
            d64Image.addFile((byte[])object, d64File.getType(), d64File.getInterleave(), byArray3, d64File.isLocked(), d64File.isVisible());
        }
        logger.println("Writing d64 file: " + d64Disk.getFilename());
        try {
            OutputStream outputStream = this.state.outputMgr.OpenOutputStream(d64Disk.getFilename(), true);
            outputStream.write(d64Image.generateImage());
            outputStream.close();
        }
        catch (D64Image.D64ImageException d64ImageException) {
            throw new AsmErrorException("Error while generating '" + d64Disk.getFilename() + "': " + d64ImageException.getMessage(), null);
        }
        catch (IOException iOException) {
            throw new AsmErrorException("Error while writing disk '" + d64Disk.getFilename() + "': " + iOException.getMessage(), null);
        }
    }

    private String doSegmentAssert(SegmentAssert segmentAssert, Map<String, SegmentNode> map) {
        int n;
        SegmentNode segmentNode = map.get(segmentAssert.getActualSegment());
        if (segmentNode == null) {
            return this.createSegmentResult(segmentAssert, false, "Segment '" + segmentAssert.getActualSegment() + "'  not found.");
        }
        SegmentNode segmentNode2 = map.get(segmentAssert.getExpectedSegment());
        if (segmentNode2 == null) {
            return this.createSegmentResult(segmentAssert, false, "Segment '" + segmentAssert.getExpectedSegment() + "'  not found.");
        }
        byte[] byArray = segmentNode.flattenMemoryBlocks(true);
        byte[] byArray2 = segmentNode2.flattenMemoryBlocks(true);
        boolean bl = true;
        for (n = 0; n < byArray.length && n < byArray2.length && bl; ++n) {
            bl = byArray[n] == byArray2[n];
        }
        if (!bl) {
            if ((n -= 3) < 0) {
                return this.createSegmentResult(segmentAssert, false, "Different start address.");
            }
            return this.createSegmentResult(segmentAssert, false, "Differ at byte " + n);
        }
        boolean bl2 = bl = byArray.length == byArray2.length;
        if (!bl) {
            return this.createSegmentResult(segmentAssert, false, "Different size!");
        }
        return this.createSegmentResult(segmentAssert, true, null);
    }

    private String createSegmentResult(SegmentAssert segmentAssert, boolean bl, String string) {
        this.state.assertMgr.madeAssert(!bl);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(segmentAssert.getMessage() + " = " + segmentAssert.getActualSegment() + " (" + segmentAssert.getExpectedSegment() + ") ");
        if (bl) {
            stringBuilder.append("-- OK!");
        } else {
            stringBuilder.append("-- Error: " + string);
        }
        return stringBuilder.toString();
    }

    public String printMemoryBlocks(Map<String, SegmentNode> map) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Map.Entry<String, Segment> entry : this.segments.entrySet()) {
            SegmentNode segmentNode = map.get(entry.getKey());
            Object object = entry.getValue();
            if (((Segment)object).getType() != SegmentType.input || ((Segment)object).isDefault() && segmentNode.maxAddress - segmentNode.minAddress <= 0) continue;
            arrayList.add(segmentNode);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Memory Map\n");
        stringBuilder.append("----------\n");
        boolean bl = true;
        for (Object object : arrayList) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append("\n");
            }
            List<MemoryBlock> list = ((SegmentNode)object).memoryBlocks;
            stringBuilder.append(((SegmentNode)object).segment.getName() + "-segment:\n");
            Comparator<MemoryBlock> comparator = new Comparator<MemoryBlock>(){

                @Override
                public int compare(MemoryBlock memoryBlock, MemoryBlock memoryBlock2) {
                    int n;
                    int n2 = memoryBlock.getStartAdress();
                    if (n2 < (n = memoryBlock2.getStartAdress())) {
                        return -1;
                    }
                    if (n2 == n) {
                        return 0;
                    }
                    return 1;
                }
            };
            Collections.sort(list, comparator);
            for (MemoryBlock memoryBlock : list) {
                stringBuilder.append("  ");
                if (memoryBlock.isVirtual()) {
                    stringBuilder.append("*");
                }
                stringBuilder.append(memoryBlock.getHexStartAddress() + "-" + memoryBlock.getHexEndAddress() + " " + memoryBlock.getName() + "\n");
            }
        }
        return stringBuilder.toString();
    }

    static class SegmentNode {
        public boolean hasError = false;
        public boolean processingStarted = false;
        public boolean isProcessed = false;
        public Segment segment;
        public List<MemoryBlock> memoryBlocks;
        public int minAddress;
        public int maxAddress;
        public Set<Pair<MemoryBlock, MemoryBlock>> allowedOverlaps = new HashSet<Pair<MemoryBlock, MemoryBlock>>();

        SegmentNode() {
        }

        public boolean isOverlapAllowed(MemoryBlock memoryBlock, MemoryBlock memoryBlock2) {
            return this.allowedOverlaps.contains(new Pair<MemoryBlock, MemoryBlock>(memoryBlock, memoryBlock2));
        }

        public byte[] flattenMemoryBlocks(boolean bl) {
            int n = this.maxAddress - this.minAddress;
            if (bl) {
                n += 2;
            }
            byte[] byArray = new byte[n];
            Arrays.fill(byArray, this.segment.getFillByte());
            int n2 = 0;
            if (bl) {
                n2 = 2;
                byArray[0] = (byte)(this.minAddress & 0xFF);
                byArray[1] = (byte)(this.minAddress >> 8 & 0xFF);
            }
            for (MemoryBlock memoryBlock : this.memoryBlocks) {
                if (memoryBlock.isVirtual()) continue;
                byte[] byArray2 = memoryBlock.getMemory();
                int n3 = n2 + memoryBlock.getStartAdress() - this.minAddress;
                for (int i = 0; i < byArray2.length; ++i) {
                    byArray[n3++] = byArray2[i];
                }
            }
            return byArray;
        }
    }
}

