/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.segments;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import kickass.nonasm.tools.tuples.Pair;
import kickass.parsing.misc.ParameterMap;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.state.EvaluationState;
import kickass.state.segments.Segment;
import kickass.state.segments.SegmentType;

public class SegmentParser {
    public static final String gsparam_prgFiles = "prgFiles";
    public static final String gsparam_allowOverlap = "allowOverlap";
    public static final String gsparam_modifiers = "modifiers";
    public static final Set<String> allGeneralSegmentParameters = new HashSet<String>(Arrays.asList("allowOverlap", "modifiers", "prgFiles"));
    public static final String isparam_start = "start";
    public static final String isparam_startAfter = "startAfter";
    public static final String isparam_virtual = "virtual";
    public static final String isparam_align = "align";
    public static final Set<String> allInputSegmentParameters = new HashSet<String>(Arrays.asList("start", "startAfter", "align", "virtual", "align"));
    public static final String csparam_segments = "segments";
    public static final Set<String> allCombiSegmentParameters = new HashSet<String>(Arrays.asList("segments"));

    public static boolean isCombiSegment(ParameterMap parameterMap) {
        return parameterMap.exist(csparam_segments);
    }

    public static Segment createInputSegment(Segment segment, ParameterMap parameterMap, EvaluationState evaluationState) {
        segment.setType(SegmentType.input);
        if (parameterMap == null) {
            return segment;
        }
        SegmentParser.addGeneralParamenter(segment, parameterMap, evaluationState);
        if (parameterMap.exist(isparam_start)) {
            segment.setStartAddr(parameterMap.getIntValue(isparam_start));
        } else if (parameterMap.exist(isparam_startAfter)) {
            String string = parameterMap.getStringValue(isparam_startAfter);
            Segment segment2 = evaluationState.segmentMgr.getSegment(string);
            if (segment2 == null) {
                parameterMap.throwParameterException(isparam_startAfter, "Unknown startAfter segment: " + string);
            }
            segment.setStartAfterSegement(segment2);
        }
        segment.setVirtual(parameterMap.getBoolValue(isparam_virtual, false));
        segment.setAlign(parameterMap.getIntegerValue(isparam_align, null));
        return segment;
    }

    public static Segment createCombiSegment(Segment segment, ParameterMap parameterMap, EvaluationState evaluationState) {
        String[] stringArray;
        segment.setType(SegmentType.combi);
        SegmentParser.addGeneralParamenter(segment, parameterMap, evaluationState);
        for (String string : stringArray = parameterMap.getStringValue(csparam_segments).split(",")) {
            if ((string = string.trim()).isEmpty()) continue;
            segment.addSubSegmentIds(string);
        }
        return segment;
    }

    private static void addGeneralParamenter(Segment segment, ParameterMap parameterMap, EvaluationState evaluationState) {
        segment.setAllowOverlappingMemoryBlocks(parameterMap.getBoolValue(gsparam_allowOverlap, false));
        String string = parameterMap.getStringValue(gsparam_prgFiles);
        if (string != null) {
            String[] stringArray;
            SourceRange sourceRange = parameterMap.getNameRange(gsparam_prgFiles);
            for (String string2 : stringArray = string.split(",")) {
                if ((string2 = string2.trim()).isEmpty()) continue;
                segment.addPrgFile(new Pair<String, SourceRange>(string2, sourceRange));
            }
        }
    }

    static {
        allInputSegmentParameters.addAll(allGeneralSegmentParameters);
        allCombiSegmentParameters.addAll(allGeneralSegmentParameters);
    }
}

