package com.sixtyfour.test;

import com.sixtyfour.Basic;
import com.sixtyfour.Loader;
import com.sixtyfour.config.CompilerConfig;
import com.sixtyfour.extensions.graphics.GraphicsBasic;

/**
 * @author EgonOlsen
 * 
 */
public class GraphicsBasicTest {
	private static CompilerConfig config = new CompilerConfig();

	public static void main(String[] args) throws Exception {
		/*
		  testGronGroff(); testLines(); testPlot(); testCircles(); testFilledCircles();
		  testRects(); testClears(); testFloodFill(); testFractal(); testFractal();
		  testShapes(); testDoubleBuffer(); testGPrint(); test3D();
		  testRotatedShapes();
		 
		  testGget(); testCopy(); testGetShape(); testSprites();
		 */
		testFractalLand();
	}

	private static void testFractalLand() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/fractalland.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testSprites() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/sprites.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testGetShape() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/getshape.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testCopy() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/copy.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	@SuppressWarnings("unused")
	private static void testGget() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/controls.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testRotatedShapes() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/rotatedshapes.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void test3D() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/graphics3d.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testGPrint() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/gprint.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testDoubleBuffer() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/doublebuffer.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testShapes() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/shapes.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testFractal() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/fractal.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testLines() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/lines.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testPlot() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/plot.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testCircles() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/circles.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testFilledCircles() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/filledcircles.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testRects() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/rects.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testClears() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/clears.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testFloodFill() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/floodfill.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}

	private static void testGronGroff() {
		String[] vary = Loader.loadProgram("src/test/resources/ext/grongroff.bas");
		Basic.registerExtension(new GraphicsBasic());
		Basic inty = new Basic(vary);
		inty.run(config);
	}
}
