#include <stdlib.h>
#include <stdio.h>
#include <time.h>

static char romname[]="tfr08.bin";

static unsigned int parseint(const char *string)
{
	unsigned int val, i;
	char c;

	val = 0;
	i = 0;
	while (string[i])
	{
		c = string[i];
		if ((c < '0') || (c > '9')) break;
		val *= 10;
		val += (c - '0');
		i++;
	}
	return val;
}

static unsigned int countint(const char *string)
{
	unsigned int i;
	char c;

	i = 0;
	while (string[i])
	{
		c = string[i];
		if ((c < '0') || (c > '9')) break;
		i++;
	}
	return i;
}

static unsigned int parseip(const char *string)
{
	unsigned int val, i, k, x;

	val = 0;
	i = 0;
	x = 0;
	while (1)
	{
		x++;
		k = parseint(&string[i]);
		if (k >= 256) return 0xFFFFFFFF;
		val |= k;
		k = countint(&string[i]);
		if (k <= 0) return 0xFFFFFFFF;
		i += k;
		if (x >= 4) break;
		if (string[i] != '.') return 0xFFFFFFFF;
		i++;
		val <<= 8;
	}

	return val;
}

static void printwarning(void)
{
	printf("Warning! These IP addresses propably do not work!\n");
	printf("The IP address of your C64 should look like this: ");
}

int main(int argc, char *argv[])
{
	FILE *f;
	unsigned char *data;
	unsigned long ip1, ip2, ipsum, i ,macvendor, macrandom;

	if (argc < 3)
	{
		printf("Not enough arguments!\n");
		printf("Usage: SETIP <C64 IP> <PC IP>\n");
		return -1;
	}
	ip1 = parseip(argv[1]);
	if (ip1 == 0xFFFFFFFF)
	{
		printf("Could not parse C64 IP address!\n");
		return -1;
	}
	ip2 = parseip(argv[2]);
	if (ip2 == 0xFFFFFFFF)
	{
		printf("Could not parse PC IP address!\n");
		return -1;
	}

	if (ip1 == ip2)
	{
		printf("C64 and PC IP address must be different!\n");
		return -1;
	}

	if (((ip1 & 0xFF000000) == 0x7F000000) || ((ip2 & 0xFF000000) == 0x7F000000))
	{
		printf("No loopback IP addresses allowed!\n");
		return -1;
	}

	// test for class A
	if ((ip2 & 0x80000000) == 0x00000000)
	{
		if ((ip1 ^ ip2) & 0xFF000000)
		{
			printwarning();
			printf("%i.x.y.z\n", (ip2 >> 24) & 0xFF);
		}
	}

	// test for class B
	if ((ip2 & 0xC0000000) == 0x80000000)
	{
		if ((ip1 ^ ip2) & 0xFFFF0000)
		{
			printwarning();
			printf("%i.%i.x.y\n", (ip2 >> 24) & 0xFF, (ip2 >> 16) & 0xFF);
		}
	}

	// test for class C
	if ((ip2 & 0xE0000000) == 0xC0000000)
	{
		if ((ip1 ^ ip2) & 0xFFFFFF00)
		{
			printwarning();
			printf("%i.%i.%i.x\n", (ip2 >> 24) & 0xFF, (ip2 >> 16) & 0xFF, (ip2 >> 8) & 0xFF);
		}
	}

	// precalculated checksum for faster IP header creation
	ipsum = (ip1 & 0x0000FFFF) + (ip1 >> 16) + (ip2 & 0x0000FFFF) + (ip2 >> 16);
	while (ipsum >= 0x0000FFFF)
	{
		ipsum = (ipsum & 0x0000FFFF) + (ipsum >> 16);
	}

	// prepare random number generator for MAC address
	srand((unsigned)time(0));
	for (i=0;i<32;i++) rand();

	macvendor = 0x008010;
	macrandom = (rand() & 0x0000FFFF) | ((rand() & 0x000000FF) << 16);

	// allocate buffer for ROM data
	data = new unsigned char[0x8000];

	f = fopen(romname, "rb");
	if (f)
	{
		fread((void *)data, 1, 0x8000, f);
		fclose(f);

		for (i=0;i<3;i++)
		{
			data[0x1000+2-i] = (unsigned char)(macvendor & 0x000000FF);
			data[0x7E00+2-i] = (unsigned char)(macvendor & 0x000000FF);
			data[0x1003+2-i] = (unsigned char)(macrandom & 0x000000FF);
			data[0x7E03+2-i] = (unsigned char)(macrandom & 0x000000FF);
			macvendor >>= 8;
			macrandom >>= 8;
		}
		for (i=0;i<4;i++)
		{
			data[0x1006+3-i] = (unsigned char)(ip1 & 0x000000FF);
			data[0x100C+3-i] = (unsigned char)(ip2 & 0x000000FF);
//			data[0x7E06+3-i] = (unsigned char)(ip1 & 0x000000FF);
			ip1 >>= 8;
			ip2 >>= 8;
		}
		data[0x1012] = (unsigned char)((ipsum >> 8) & 0x000000FF);
		data[0x1013] = (unsigned char)(ipsum & 0x000000FF);


		f = fopen(romname, "wb");
		if (f)
		{
			fwrite((void *)data, 1, 0x8000, f);
			fclose(f);
		} else {
			printf("Could not write modified ROM file!\n");
			delete[] data;
			return -1;
		}
	} else {
		printf("The Final Replay V0.8 ROM file not found! (%s)\n", romname);
		delete[] data;
		return -1;
	}
	printf("ROM file successfully updated.\n");
	delete[] data;

	return 0;
}
